/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculatorAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import java.util.Optional;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSimpleFilterProjectSemiJoinStatsRule
extends BaseStatsCalculatorTest {
    private VariableStatsEstimate aStats = VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(10.0).setDistinctValuesCount(10.0).setNullsFraction(0.1).build();
    private VariableStatsEstimate bStats = VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(100.0).setDistinctValuesCount(10.0).setNullsFraction(0.0).build();
    private VariableStatsEstimate cStats = VariableStatsEstimate.builder().setLowValue(5.0).setHighValue(30.0).setDistinctValuesCount(2.0).setNullsFraction(0.5).build();
    private VariableStatsEstimate expectedAInC = VariableStatsEstimate.builder().setDistinctValuesCount(2.0).setLowValue(0.0).setHighValue(10.0).setNullsFraction(0.0).build();
    private VariableStatsEstimate expectedANotInC = VariableStatsEstimate.builder().setDistinctValuesCount(1.6).setLowValue(0.0).setHighValue(8.0).setNullsFraction(0.0).build();
    private VariableStatsEstimate expectedANotInCWithExtraFilter = VariableStatsEstimate.builder().setDistinctValuesCount(8.0).setLowValue(0.0).setHighValue(10.0).setNullsFraction(0.0).build();
    private static final PlanNodeId LEFT_SOURCE_ID = new PlanNodeId("left_source_values");
    private static final PlanNodeId RIGHT_SOURCE_ID = new PlanNodeId("right_source_values");
    private static final TestingRowExpressionTranslator TRANSLATOR = new TestingRowExpressionTranslator((Metadata)MetadataManager.createTestMetadataManager());

    @DataProvider(name="toRowExpression")
    public Object[][] toRowExpressionProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="toRowExpression")
    public void testFilterPositiveSemiJoin(boolean toRowExpression) {
        this.getStatsCalculatorAssertion((Expression)new SymbolReference("sjo"), toRowExpression).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), this.aStats).addVariableStatistics(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addVariableStatistics(new VariableReferenceExpression("c", (Type)BigintType.BIGINT), this.cStats).build()).check(check -> check.outputRowsCount(180.0).variableStats(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.expectedAInC)).variableStats(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.bStats)).variableStatsUnknown("c").variableStatsUnknown("sjo"));
    }

    @Test(dataProvider="toRowExpression")
    public void testFilterPositiveNarrowingProjectSemiJoin(boolean toRowExpression) {
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression a = pb.variable("a", (Type)BigintType.BIGINT);
            VariableReferenceExpression b = pb.variable("b", (Type)BigintType.BIGINT);
            VariableReferenceExpression c = pb.variable("c", (Type)BigintType.BIGINT);
            VariableReferenceExpression semiJoinOutput = pb.variable("sjo", (Type)BooleanType.BOOLEAN);
            SemiJoinNode semiJoinNode = pb.semiJoin((PlanNode)pb.values(LEFT_SOURCE_ID, a, b), (PlanNode)pb.values(RIGHT_SOURCE_ID, c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty());
            if (toRowExpression) {
                return pb.filter(TRANSLATOR.translateAndOptimize(PlanBuilder.expression("sjo"), pb.getTypes()), (PlanNode)pb.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((VariableReferenceExpression[])new VariableReferenceExpression[]{semiJoinOutput, a}), (PlanNode)semiJoinNode));
            }
            return pb.filter(PlanBuilder.expression("sjo"), (PlanNode)pb.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((VariableReferenceExpression[])new VariableReferenceExpression[]{semiJoinOutput, a}), (PlanNode)semiJoinNode));
        }).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), this.aStats).addVariableStatistics(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addVariableStatistics(new VariableReferenceExpression("c", (Type)BigintType.BIGINT), this.cStats).build()).check(check -> check.outputRowsCount(180.0).variableStats(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.expectedAInC)).variableStatsUnknown("b").variableStatsUnknown("c").variableStatsUnknown("sjo"));
    }

    @Test(dataProvider="toRowExpression")
    public void testFilterPositivePlusExtraConjunctSemiJoin(boolean toRowExpression) {
        this.getStatsCalculatorAssertion(PlanBuilder.expression("sjo AND a < 8"), toRowExpression).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), this.aStats).addVariableStatistics(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addVariableStatistics(new VariableReferenceExpression("c", (Type)BigintType.BIGINT), this.cStats).build()).check(check -> check.outputRowsCount(144.0).variableStats(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.expectedANotInC)).variableStats(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.bStats)).variableStatsUnknown("c").variableStatsUnknown("sjo"));
    }

    @Test(dataProvider="toRowExpression")
    public void testFilterNegativeSemiJoin(boolean toRowExpression) {
        this.getStatsCalculatorAssertion(PlanBuilder.expression("NOT sjo"), toRowExpression).withSourceStats(LEFT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), this.aStats).addVariableStatistics(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), this.bStats).build()).withSourceStats(RIGHT_SOURCE_ID, PlanNodeStatsEstimate.builder().setOutputRowCount(2000.0).addVariableStatistics(new VariableReferenceExpression("c", (Type)BigintType.BIGINT), this.cStats).build()).check(check -> check.outputRowsCount(720.0).variableStats(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.expectedANotInCWithExtraFilter)).variableStats(new VariableReferenceExpression("b", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.bStats)).variableStatsUnknown("c").variableStatsUnknown("sjo"));
    }

    private StatsCalculatorAssertion getStatsCalculatorAssertion(Expression expression, boolean toRowExpression) {
        return this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression a = pb.variable("a", (Type)BigintType.BIGINT);
            VariableReferenceExpression b = pb.variable("b", (Type)BigintType.BIGINT);
            VariableReferenceExpression c = pb.variable("c", (Type)BigintType.BIGINT);
            VariableReferenceExpression semiJoinOutput = pb.variable("sjo", (Type)BooleanType.BOOLEAN);
            SemiJoinNode semiJoinNode = pb.semiJoin((PlanNode)pb.values(LEFT_SOURCE_ID, a, b), (PlanNode)pb.values(RIGHT_SOURCE_ID, c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty());
            if (toRowExpression) {
                return pb.filter(TRANSLATOR.translateAndOptimize(expression, pb.getTypes()), (PlanNode)semiJoinNode);
            }
            return pb.filter(expression, (PlanNode)semiJoinNode);
        });
    }
}

