/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.VariableStatsAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestStatsNormalizer {
    private final FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private final ConnectorSession session = new TestingConnectorSession(Collections.emptyList());
    private final StatsNormalizer normalizer = new StatsNormalizer();

    @Test
    public void testNoCapping() {
        VariableReferenceExpression a = new VariableReferenceExpression("a", (Type)BigintType.BIGINT);
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().setOutputRowCount(30.0).setTotalSize(120.0).addVariableStatistics(a, VariableStatsEstimate.builder().setDistinctValuesCount(20.0).build()).build();
        this.assertNormalized(estimate).totalSize(120.0).variableStats(a, variableAssert -> variableAssert.distinctValuesCount(20.0));
    }

    @Test
    public void testDropNonOutputSymbols() {
        VariableReferenceExpression a = new VariableReferenceExpression("a", (Type)BigintType.BIGINT);
        VariableReferenceExpression b = new VariableReferenceExpression("b", (Type)BigintType.BIGINT);
        VariableReferenceExpression c = new VariableReferenceExpression("c", (Type)BigintType.BIGINT);
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).setTotalSize(160.0).addVariableStatistics(a, VariableStatsEstimate.builder().setDistinctValuesCount(20.0).build()).addVariableStatistics(b, VariableStatsEstimate.builder().setDistinctValuesCount(30.0).build()).addVariableStatistics(c, VariableStatsEstimate.unknown()).build();
        PlanNodeStatsAssertion.assertThat(this.normalizer.normalize(estimate, (Collection)ImmutableList.of((Object)b, (Object)c))).totalSize(160.0).variablesWithKnownStats(b).variableStats(b, variableAssert -> variableAssert.distinctValuesCount(30.0));
    }

    @Test
    public void tesCapDistinctValuesByOutputRowCount() {
        VariableReferenceExpression a = new VariableReferenceExpression("a", (Type)BigintType.BIGINT);
        VariableReferenceExpression b = new VariableReferenceExpression("b", (Type)BigintType.BIGINT);
        VariableReferenceExpression c = new VariableReferenceExpression("c", (Type)BigintType.BIGINT);
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().addVariableStatistics(a, VariableStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(20.0).build()).addVariableStatistics(b, VariableStatsEstimate.builder().setNullsFraction(0.4).setDistinctValuesCount(20.0).build()).addVariableStatistics(c, VariableStatsEstimate.unknown()).setOutputRowCount(10.0).setTotalSize(40.0).build();
        this.assertNormalized(estimate).totalSize(40.0).variableStats(a, variableAssert -> variableAssert.distinctValuesCount(10.0)).variableStats(b, variableAssert -> variableAssert.distinctValuesCount(8.0)).variableStats(c, VariableStatsAssertion::distinctValuesCountUnknown);
    }

    @Test
    public void testCapDistinctValuesByToDomainRangeLength() {
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 2.0E10, 1, 1000000000, 1.0E9);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 3.0, 1, 5, 3.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, Double.NaN, 1, 5, Double.NaN);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BigintType.BIGINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)SmallintType.SMALLINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)TinyintType.TINYINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 11.0, 1, 1, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 13.0, 101, 103, 3.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 10.0, 100, 200, 10.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DoubleType.DOUBLE, 42.0, 10.1, 10.2, 42.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DoubleType.DOUBLE, 42.0, 10.1, 10.1, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BooleanType.BOOLEAN, 11.0, true, true, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BooleanType.BOOLEAN, 12.0, false, true, 2.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DateType.DATE, 12.0, LocalDate.of(2017, 8, 31).toEpochDay(), LocalDate.of(2017, 9, 2).toEpochDay(), 3.0);
    }

    private void testCapDistinctValuesByToDomainRangeLength(Type type, double ndv, Object low, Object high, double expectedNormalizedNdv) {
        VariableReferenceExpression variable = new VariableReferenceExpression("x", type);
        VariableStatsEstimate symbolStats = VariableStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(ndv).setLowValue(this.asStatsValue(low, type)).setHighValue(this.asStatsValue(high, type)).build();
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0E10).setTotalSize(4.0E10).addVariableStatistics(variable, symbolStats).build();
        this.assertNormalized(estimate).totalSize(4.0E10).variableStats(variable, variableAssert -> variableAssert.distinctValuesCount(expectedNormalizedNdv));
    }

    private PlanNodeStatsAssertion assertNormalized(PlanNodeStatsEstimate estimate) {
        PlanNodeStatsEstimate normalized = this.normalizer.normalize(estimate, (Collection)estimate.getVariablesWithKnownStatistics());
        return PlanNodeStatsAssertion.assertThat(normalized);
    }

    private double asStatsValue(Object value, Type type) {
        return StatsUtil.toStatsRepresentation((FunctionAndTypeManager)this.functionAndTypeManager, (ConnectorSession)this.session, (Type)type, (Object)value).orElse(Double.NaN);
    }
}

