/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.Session;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.dispatcher.DefaultQueryPrerequisites;
import com.facebook.presto.dispatcher.LocalDispatchQuery;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.event.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.resourceGroups.QueryQueueFullException;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryFailureInfo;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.spi.prerequisites.QueryPrerequisites;
import com.facebook.presto.spi.prerequisites.QueryPrerequisitesContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLocalDispatchQuery {
    private static final QueryPrerequisites QUERY_PREREQUISITES = new DefaultQueryPrerequisites();
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testSimpleExecutionCreationFailure() {
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(this.createStateMachine(), this.createQueryMonitor(eventListener), Futures.immediateFailedFuture((Throwable)new IllegalStateException("abc")), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {}, false, QUERY_PREREQUISITES);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
    }

    @Test
    public void testQueryQueuedExceptionBeforeDispatch() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        SettableFuture queryExecutionFuture = SettableFuture.create();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), (ListenableFuture)queryExecutionFuture, this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {
            throw new QueryQueueFullException(new ResourceGroupId("global"));
        }, execution -> {}, false, QUERY_PREREQUISITES);
        query.startWaitingForPrerequisites();
        queryExecutionFuture.setException((Throwable)new IllegalStateException("abc"));
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.QUERY_QUEUE_FULL.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.QUERY_QUEUE_FULL.toErrorCode());
    }

    @Test
    public void testErrorInPrerequisitesFuture() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {
            throw new AccessDeniedException("sdf");
        }, false, (queryId, context) -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_TASK, "something went wrong"));
            return future;
        });
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForPrerequisites();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.ABANDONED_TASK.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.ABANDONED_TASK.toErrorCode());
    }

    @Test
    public void testErrorInPrerequisitesSubmission() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {
            throw new AccessDeniedException("sdf");
        }, false, (queryId, context) -> {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_QUERY, "something went wrong");
        });
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        try {
            query.startWaitingForPrerequisites();
            Assert.fail((String)"Exception should be thrown");
        }
        catch (Throwable t) {
            Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
            Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.ABANDONED_QUERY.toErrorCode());
            Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
            Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
            Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.ABANDONED_QUERY.toErrorCode());
        }
    }

    @Test
    public void testPrerequisitesQueryFinishedCalled() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        final CompletableFuture<Object> prequisitesFuture = new CompletableFuture<Object>();
        final AtomicBoolean queryFinishedCalled = new AtomicBoolean();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {}, false, new QueryPrerequisites(){

            public CompletableFuture<?> waitForPrerequisites(QueryId queryId, QueryPrerequisitesContext context) {
                return prequisitesFuture;
            }

            public void queryFinished(QueryId queryId) {
                queryFinishedCalled.set(true);
            }
        });
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForPrerequisites();
        prequisitesFuture.complete(null);
        query.fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_QUERY, "foo"));
        Assert.assertTrue((boolean)queryFinishedCalled.get());
    }

    @Test
    public void testPrerequisiteFutureCancellationWhenQueryCancelled() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        CompletableFuture prequisitesFuture = new CompletableFuture();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {}, false, (queryId, context) -> prequisitesFuture);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForPrerequisites();
        query.fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_QUERY, "foo"));
        Assert.assertTrue((boolean)prequisitesFuture.isCancelled());
    }

    @Test
    public void testQueryQueueSubmission() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        AtomicBoolean queryQueuerCalled = new AtomicBoolean();
        CompletableFuture<Object> prerequisitesFuture = new CompletableFuture<Object>();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> queryQueuerCalled.compareAndSet(false, true), execution -> {}, false, (queryId, context) -> prerequisitesFuture);
        Assert.assertEquals((Object)stateMachine.getBasicQueryInfo(Optional.empty()).getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        query.startWaitingForPrerequisites();
        Assert.assertEquals((Object)stateMachine.getBasicQueryInfo(Optional.empty()).getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)queryQueuerCalled.get());
        prerequisitesFuture.complete(null);
        Assert.assertEquals((Object)stateMachine.getBasicQueryInfo(Optional.empty()).getState(), (Object)QueryState.QUEUED);
        Assert.assertTrue((boolean)queryQueuerCalled.get());
    }

    @Test
    public void testErrorInQuerySubmitter() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {
            throw new AccessDeniedException("sdf");
        }, false, QUERY_PREREQUISITES);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForResources();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.PERMISSION_DENIED.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.PERMISSION_DENIED.toErrorCode());
    }

    @Test
    public void testTimeOutWaitingForClusterResources() throws Exception {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(1), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {}, false, QUERY_PREREQUISITES);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForResources();
        Thread.sleep(300L);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES.toErrorCode());
    }

    @Test
    public void testQueryCancellation() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {}, false, QUERY_PREREQUISITES);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.cancel();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.USER_CANCELED.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.USER_CANCELED.toErrorCode());
    }

    @Test
    public void testQueryDispatched() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), dispatchQuery -> {}, execution -> {}, false, QUERY_PREREQUISITES);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.WAITING_FOR_PREREQUISITES);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForResources();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.DISPATCHING);
        Assert.assertNull((Object)query.getBasicQueryInfo().getErrorCode());
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
    }

    private ClusterSizeMonitor createClusterSizeMonitor(int minimumNodes) {
        return new ClusterSizeMonitor((InternalNodeManager)new InMemoryNodeManager(), true, minimumNodes, minimumNodes, new Duration(10.0, TimeUnit.MILLISECONDS), 1, new Duration(1.0, TimeUnit.SECONDS));
    }

    private QueryMonitor createQueryMonitor(CountingEventListener eventListener) {
        EventListenerManager eventListenerManager = this.createEventListenerManager(eventListener);
        return new QueryMonitor(JsonCodec.jsonCodec(StageInfo.class), JsonCodec.jsonCodec(ExecutionFailureInfo.class), JsonCodec.jsonCodec(OperatorInfo.class), eventListenerManager, new NodeInfo("test"), NodeVersion.UNKNOWN, new SessionPropertyManager(), (Metadata)this.metadata, new QueryMonitorConfig());
    }

    private EventListenerManager createEventListenerManager(CountingEventListener countingEventListener) {
        EventListenerManager eventListenerManager = new EventListenerManager();
        eventListenerManager.addEventListenerFactory((EventListenerFactory)new TestEventListenerFactory(countingEventListener));
        eventListenerManager.loadConfiguredEventListener((Map)ImmutableMap.of((Object)"event-listener.name", (Object)"name"));
        return eventListenerManager;
    }

    private QueryStateMachine createStateMachine() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setTransactionId(transactionManager.beginTransaction(false)).build();
        return TaskTestUtils.createQueryStateMachine("COMMIT", session, true, transactionManager, MoreExecutors.directExecutor(), this.metadata);
    }

    private static class CountingEventListener
    implements EventListener {
        private final AtomicReference<QueryCompletedEvent> queryCompletedEvent = new AtomicReference();

        private CountingEventListener() {
        }

        public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
            Assert.fail((String)"Query creation events should not be created in this test");
        }

        public void queryCompleted(QueryCompletedEvent event) {
            Assert.assertTrue((boolean)this.queryCompletedEvent.compareAndSet(null, Objects.requireNonNull(event, "event is null")), (String)"Duplicate completion event sent");
        }

        public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
            Assert.fail((String)"splitCompleted should never be called");
        }

        public Optional<QueryCompletedEvent> getQueryCompletedEvent() {
            return Optional.ofNullable(this.queryCompletedEvent.get());
        }
    }

    private static class TestEventListenerFactory
    implements EventListenerFactory {
        public static final String NAME = "name";
        private final CountingEventListener countingEventListener;

        public TestEventListenerFactory(CountingEventListener countingEventListener) {
            this.countingEventListener = Objects.requireNonNull(countingEventListener, "countingEventListener is null");
        }

        public String getName() {
            return NAME;
        }

        public EventListener create(Map<String, String> config) {
            return this.countingEventListener;
        }
    }
}

