/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.CreateFunctionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestCreateFunctionTask {
    private final MetadataManager metadataManager = MetadataManager.createTestMetadataManager();
    private final ExecutorService executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testCreateTemporaryFunction() {
        SqlParser parser = new SqlParser();
        String sqlString = "CREATE TEMPORARY FUNCTION foo() RETURNS int RETURN 1";
        CreateFunction statement = (CreateFunction)parser.createStatement(sqlString, ParsingOptions.builder().build());
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(sqlString, SessionTestUtils.TEST_SESSION, false, transactionManager, this.executorService, this.metadataManager);
        new CreateFunctionTask(parser).execute(statement, transactionManager, (Metadata)this.metadataManager, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        Assert.assertEquals((int)stateMachine.getAddedSessionFunctions().size(), (int)1);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Session function .* has already been defined")
    public void testCreateTemporaryFunctionWithSameNameFails() {
        SqlParser parser = new SqlParser();
        String sqlString = "CREATE TEMPORARY FUNCTION foo() RETURNS int RETURN 1";
        CreateFunction statement = (CreateFunction)parser.createStatement(sqlString, ParsingOptions.builder().build());
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(sqlString, SessionTestUtils.TEST_SESSION, false, transactionManager, this.executorService, this.metadataManager);
        new CreateFunctionTask(parser).execute(statement, transactionManager, (Metadata)this.metadataManager, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        new CreateFunctionTask(parser).execute(statement, transactionManager, (Metadata)this.metadataManager, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
    }
}

