/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.MemoryRevokingScheduler;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.TaskThresholdMemoryRevokingScheduler;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SpoolingOutputBufferFactory;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryRevokingScheduler {
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private final AtomicInteger idGeneator = new AtomicInteger();
    private final SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(10.0, DataSize.Unit.GIGABYTE));
    private final Map<QueryId, QueryContext> queryContexts = new HashMap<QueryId, QueryContext>();
    private ExecutorService singleThreadedExecutor;
    private ScheduledExecutorService singleThreadedScheduledExecutor;
    private ScheduledExecutorService scheduledExecutor;
    private SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private MemoryPool memoryPool;
    private Set<OperatorContext> allOperatorContexts;

    @BeforeMethod
    public void setUp() {
        this.memoryPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10.0, DataSize.Unit.BYTE));
        TaskExecutor taskExecutor = new TaskExecutor(8, 16, 3, 4, TaskManagerConfig.TaskPriorityTracking.TASK_FAIR, Ticker.systemTicker());
        taskExecutor.start();
        this.singleThreadedExecutor = Executors.newSingleThreadExecutor(Threads.threadsNamed((String)"task-notification-%s"));
        this.singleThreadedScheduledExecutor = Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"task-notification-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"task-notification-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.singleThreadedExecutor, taskExecutor, planner, (BlockEncodingSerde)new BlockEncodingManager(), new OrderingCompiler(), TaskTestUtils.createTestSplitMonitor(), new TaskManagerConfig().setPerOperatorAllocationTrackingEnabled(true).setTaskCpuTimerEnabled(true).setPerOperatorAllocationTrackingEnabled(true).setTaskAllocationTrackingEnabled(true));
        this.allOperatorContexts = null;
        TestOperatorContext.firstOperator = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.queryContexts.clear();
        this.memoryPool = null;
        this.singleThreadedExecutor.shutdownNow();
        this.singleThreadedScheduledExecutor.shutdown();
        this.scheduledExecutor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryPoolRevoking() throws Exception {
        QueryContext q1 = this.getOrCreateQueryContext(new QueryId("q1"), this.memoryPool);
        QueryContext q2 = this.getOrCreateQueryContext(new QueryId("q2"), this.memoryPool);
        SqlTask sqlTask1 = this.newSqlTask(q1.getQueryId(), this.memoryPool);
        SqlTask sqlTask2 = this.newSqlTask(q2.getQueryId(), this.memoryPool);
        TaskContext taskContext1 = this.getOrCreateTaskContext(sqlTask1);
        PipelineContext pipelineContext11 = taskContext1.addPipelineContext(0, false, false, false);
        DriverContext driverContext111 = pipelineContext11.addDriverContext();
        OperatorContext operatorContext1 = driverContext111.addOperatorContext(1, new PlanNodeId("na"), "na");
        OperatorContext operatorContext2 = driverContext111.addOperatorContext(2, new PlanNodeId("na"), "na");
        DriverContext driverContext112 = pipelineContext11.addDriverContext();
        OperatorContext operatorContext3 = driverContext112.addOperatorContext(3, new PlanNodeId("na"), "na");
        TaskContext taskContext2 = this.getOrCreateTaskContext(sqlTask2);
        PipelineContext pipelineContext21 = taskContext2.addPipelineContext(1, false, false, false);
        DriverContext driverContext211 = pipelineContext21.addDriverContext();
        OperatorContext operatorContext4 = driverContext211.addOperatorContext(4, new PlanNodeId("na"), "na");
        OperatorContext operatorContext5 = driverContext211.addOperatorContext(5, new PlanNodeId("na"), "na");
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testMemoryPoolRevoking$0((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_CREATE_TIME, false);
        try {
            scheduler.start();
            this.allOperatorContexts = ImmutableSet.of((Object)operatorContext1, (Object)operatorContext2, (Object)operatorContext3, (Object)operatorContext4, (Object)operatorContext5);
            this.assertMemoryRevokingNotRequested();
            Assert.assertEquals((long)10L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            LocalMemoryContext revocableMemory1 = operatorContext1.localRevocableMemoryContext();
            LocalMemoryContext revocableMemory3 = operatorContext3.localRevocableMemoryContext();
            LocalMemoryContext revocableMemory4 = operatorContext4.localRevocableMemoryContext();
            LocalMemoryContext revocableMemory5 = operatorContext5.localRevocableMemoryContext();
            revocableMemory1.setBytes(3L);
            revocableMemory3.setBytes(6L);
            Assert.assertEquals((long)1L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            revocableMemory4.setBytes(7L);
            Assert.assertEquals((long)-6L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext3);
            revocableMemory1.setBytes(0L);
            operatorContext1.resetMemoryRevokingRequested();
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext3);
            Assert.assertEquals((long)-3L, (long)this.memoryPool.getFreeBytes());
            revocableMemory5.setBytes(3L);
            Assert.assertEquals((long)-6L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext3);
            revocableMemory5.setBytes(4L);
            Assert.assertEquals((long)-7L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext3, operatorContext4);
        }
        finally {
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountAlreadyRevokedMemoryWithinAPool() throws Exception {
        MemoryPool anotherMemoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(10.0, DataSize.Unit.BYTE));
        SqlTask sqlTask1 = this.newSqlTask(new QueryId("q1"), anotherMemoryPool);
        OperatorContext operatorContext1 = this.createContexts(sqlTask1);
        SqlTask sqlTask2 = this.newSqlTask(new QueryId("q2"), this.memoryPool);
        OperatorContext operatorContext2 = this.createContexts(sqlTask2);
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Arrays.asList(this.memoryPool, anotherMemoryPool), () -> TestMemoryRevokingScheduler.lambda$testCountAlreadyRevokedMemoryWithinAPool$1((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_CREATE_TIME, false);
        try {
            scheduler.start();
            this.allOperatorContexts = ImmutableSet.of((Object)operatorContext1, (Object)operatorContext2);
            operatorContext1.localRevocableMemoryContext().setBytes(12L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext1);
            operatorContext2.localRevocableMemoryContext().setBytes(12L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext2);
        }
        finally {
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskRevokingOrderForCreateTime() throws Exception {
        SqlTask sqlTask1 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext1 = this.createTestingOperatorContexts(sqlTask1, "operator1");
        SqlTask sqlTask2 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext2 = this.createTestingOperatorContexts(sqlTask2, "operator2");
        this.allOperatorContexts = ImmutableSet.of((Object)((Object)operatorContext1), (Object)((Object)operatorContext2));
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testTaskRevokingOrderForCreateTime$2((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_CREATE_TIME, false);
        try {
            scheduler.start();
            this.assertMemoryRevokingNotRequested();
            operatorContext1.localRevocableMemoryContext().setBytes(11L);
            operatorContext2.localRevocableMemoryContext().setBytes(12L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext2);
            Assert.assertEquals((String)TestOperatorContext.firstOperator, (String)"operator1");
        }
        finally {
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskRevokingOrderForRevocableBytes() throws Exception {
        SqlTask sqlTask1 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext1 = this.createTestingOperatorContexts(sqlTask1, "operator1");
        SqlTask sqlTask2 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext2 = this.createTestingOperatorContexts(sqlTask2, "operator2");
        this.allOperatorContexts = ImmutableSet.of((Object)((Object)operatorContext1), (Object)((Object)operatorContext2));
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testTaskRevokingOrderForRevocableBytes$3((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_REVOCABLE_BYTES, false);
        try {
            scheduler.start();
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            operatorContext1.localRevocableMemoryContext().setBytes(11L);
            operatorContext2.localRevocableMemoryContext().setBytes(12L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext2);
            Assert.assertEquals((String)TestOperatorContext.firstOperator, (String)"operator2");
        }
        finally {
            scheduler.stop();
        }
    }

    @Test
    public void testTaskThresholdRevokingScheduler() throws Exception {
        SqlTask sqlTask1 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext11 = this.createTestingOperatorContexts(sqlTask1, "operator11");
        TestOperatorContext operatorContext12 = this.createTestingOperatorContexts(sqlTask1, "operator12");
        SqlTask sqlTask2 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext2 = this.createTestingOperatorContexts(sqlTask2, "operator2");
        this.allOperatorContexts = ImmutableSet.of((Object)((Object)operatorContext11), (Object)((Object)operatorContext12), (Object)((Object)operatorContext2));
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        ImmutableMap taskMap = ImmutableMap.of((Object)sqlTask1.getTaskId(), (Object)sqlTask1, (Object)sqlTask2.getTaskId(), (Object)sqlTask2);
        TaskThresholdMemoryRevokingScheduler scheduler = new TaskThresholdMemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testTaskThresholdRevokingScheduler$4((List)tasks), arg_0 -> ((ImmutableMap)taskMap).get(arg_0), this.singleThreadedScheduledExecutor, 5L);
        this.assertMemoryRevokingNotRequested();
        operatorContext11.localRevocableMemoryContext().setBytes(3L);
        operatorContext2.localRevocableMemoryContext().setBytes(2L);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingNotRequested();
        operatorContext12.localRevocableMemoryContext().setBytes(3L);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext11);
        operatorContext11.localRevocableMemoryContext().setBytes(1L);
        operatorContext11.resetMemoryRevokingRequested();
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingNotRequested();
        operatorContext12.localRevocableMemoryContext().setBytes(6L);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext11, operatorContext12);
        operatorContext11.localRevocableMemoryContext().setBytes(2L);
        operatorContext11.resetMemoryRevokingRequested();
        operatorContext12.localRevocableMemoryContext().setBytes(2L);
        operatorContext12.resetMemoryRevokingRequested();
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingNotRequested();
        operatorContext2.localRevocableMemoryContext().setBytes(6L);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext2);
    }

    @Test
    public void testTaskThresholdRevokingSchedulerImmediate() throws Exception {
        SqlTask sqlTask1 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext11 = this.createTestingOperatorContexts(sqlTask1, "operator11");
        TestOperatorContext operatorContext12 = this.createTestingOperatorContexts(sqlTask1, "operator12");
        SqlTask sqlTask2 = this.newSqlTask(new QueryId("query"), this.memoryPool);
        TestOperatorContext operatorContext2 = this.createTestingOperatorContexts(sqlTask2, "operator2");
        this.allOperatorContexts = ImmutableSet.of((Object)((Object)operatorContext11), (Object)((Object)operatorContext12), (Object)((Object)operatorContext2));
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        ImmutableMap taskMap = ImmutableMap.of((Object)sqlTask1.getTaskId(), (Object)sqlTask1, (Object)sqlTask2.getTaskId(), (Object)sqlTask2);
        TaskThresholdMemoryRevokingScheduler scheduler = new TaskThresholdMemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testTaskThresholdRevokingSchedulerImmediate$5((List)tasks), arg_0 -> ((ImmutableMap)taskMap).get(arg_0), this.singleThreadedScheduledExecutor, 5L);
        scheduler.registerPoolListeners();
        this.assertMemoryRevokingNotRequested();
        operatorContext11.localRevocableMemoryContext().setBytes(3L);
        operatorContext2.localRevocableMemoryContext().setBytes(2L);
        this.awaitTaskThresholdAsynchronousCallbacksRun();
        this.assertMemoryRevokingNotRequested();
        operatorContext12.localRevocableMemoryContext().setBytes(3L);
        this.awaitTaskThresholdAsynchronousCallbacksRun();
        this.assertMemoryRevokingRequestedFor(operatorContext11);
        operatorContext11.localRevocableMemoryContext().setBytes(1L);
        operatorContext11.resetMemoryRevokingRequested();
        this.awaitTaskThresholdAsynchronousCallbacksRun();
        this.assertMemoryRevokingNotRequested();
        operatorContext12.localRevocableMemoryContext().setBytes(6L);
        this.awaitTaskThresholdAsynchronousCallbacksRun();
        this.assertMemoryRevokingRequestedFor(operatorContext11, operatorContext12);
        operatorContext11.localRevocableMemoryContext().setBytes(2L);
        operatorContext11.resetMemoryRevokingRequested();
        operatorContext12.localRevocableMemoryContext().setBytes(2L);
        operatorContext12.resetMemoryRevokingRequested();
        this.awaitTaskThresholdAsynchronousCallbacksRun();
        this.assertMemoryRevokingNotRequested();
        operatorContext2.localRevocableMemoryContext().setBytes(6L);
        this.awaitTaskThresholdAsynchronousCallbacksRun();
        this.assertMemoryRevokingRequestedFor(operatorContext2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMemoryRevoking() throws Exception {
        QueryId queryId = new QueryId("query");
        MemoryPool queryLimitMemoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(100.0, DataSize.Unit.GIGABYTE));
        SqlTask sqlTask1 = this.newSqlTask(queryId, queryLimitMemoryPool);
        TestOperatorContext operatorContext11 = this.createTestingOperatorContexts(sqlTask1, "operator11");
        TestOperatorContext operatorContext12 = this.createTestingOperatorContexts(sqlTask1, "operator12");
        SqlTask sqlTask2 = this.newSqlTask(queryId, queryLimitMemoryPool);
        TestOperatorContext operatorContext2 = this.createTestingOperatorContexts(sqlTask2, "operator2");
        this.allOperatorContexts = ImmutableSet.of((Object)((Object)operatorContext11), (Object)((Object)operatorContext12), (Object)((Object)operatorContext2));
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(queryLimitMemoryPool), () -> TestMemoryRevokingScheduler.lambda$testQueryMemoryRevoking$6((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_REVOCABLE_BYTES, true);
        try {
            scheduler.start();
            this.assertMemoryRevokingNotRequested();
            operatorContext11.localRevocableMemoryContext().setBytes(150000L);
            operatorContext2.localRevocableMemoryContext().setBytes(100000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            operatorContext12.localRevocableMemoryContext().setBytes(300000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext11);
            operatorContext11.localRevocableMemoryContext().setBytes(0L);
            scheduler.awaitAsynchronousCallbacksRun();
            operatorContext11.resetMemoryRevokingRequested();
            operatorContext12.resetMemoryRevokingRequested();
            operatorContext2.resetMemoryRevokingRequested();
            this.assertMemoryRevokingNotRequested();
            operatorContext11.localRevocableMemoryContext().setBytes(20000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            operatorContext2.localSystemMemoryContext().setBytes(150000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext11, operatorContext12);
            operatorContext11.localRevocableMemoryContext().setBytes(0L);
            operatorContext12.localRevocableMemoryContext().setBytes(0L);
            scheduler.awaitAsynchronousCallbacksRun();
            operatorContext11.resetMemoryRevokingRequested();
            operatorContext12.resetMemoryRevokingRequested();
            operatorContext2.resetMemoryRevokingRequested();
            this.assertMemoryRevokingNotRequested();
            operatorContext11.localRevocableMemoryContext().setBytes(50000L);
            operatorContext12.localRevocableMemoryContext().setBytes(50000L);
            operatorContext2.localSystemMemoryContext().setBytes(150000L);
            operatorContext2.localRevocableMemoryContext().setBytes(150000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            operatorContext12.localUserMemoryContext().setBytes(300000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext2, operatorContext11);
        }
        finally {
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRevokesPoolWhenFullBeforeQueryLimit() throws Exception {
        QueryContext q1 = this.getOrCreateQueryContext(new QueryId("q1"), this.memoryPool);
        QueryContext q2 = this.getOrCreateQueryContext(new QueryId("q2"), this.memoryPool);
        SqlTask sqlTask1 = this.newSqlTask(q1.getQueryId(), this.memoryPool);
        SqlTask sqlTask2 = this.newSqlTask(q2.getQueryId(), this.memoryPool);
        TaskContext taskContext1 = this.getOrCreateTaskContext(sqlTask1);
        PipelineContext pipelineContext11 = taskContext1.addPipelineContext(0, false, false, false);
        DriverContext driverContext111 = pipelineContext11.addDriverContext();
        OperatorContext operatorContext1 = driverContext111.addOperatorContext(1, new PlanNodeId("na"), "na");
        OperatorContext operatorContext2 = driverContext111.addOperatorContext(2, new PlanNodeId("na"), "na");
        DriverContext driverContext112 = pipelineContext11.addDriverContext();
        OperatorContext operatorContext3 = driverContext112.addOperatorContext(3, new PlanNodeId("na"), "na");
        TaskContext taskContext2 = this.getOrCreateTaskContext(sqlTask2);
        PipelineContext pipelineContext21 = taskContext2.addPipelineContext(1, false, false, false);
        DriverContext driverContext211 = pipelineContext21.addDriverContext();
        OperatorContext operatorContext4 = driverContext211.addOperatorContext(4, new PlanNodeId("na"), "na");
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testRevokesPoolWhenFullBeforeQueryLimit$7((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_CREATE_TIME, true);
        try {
            scheduler.start();
            this.allOperatorContexts = ImmutableSet.of((Object)operatorContext1, (Object)operatorContext2, (Object)operatorContext3, (Object)operatorContext4);
            this.assertMemoryRevokingNotRequested();
            Assert.assertEquals((long)10L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            LocalMemoryContext revocableMemory1 = operatorContext1.localRevocableMemoryContext();
            LocalMemoryContext revocableMemory3 = operatorContext3.localRevocableMemoryContext();
            LocalMemoryContext revocableMemory4 = operatorContext4.localRevocableMemoryContext();
            revocableMemory1.setBytes(3L);
            revocableMemory3.setBytes(6L);
            Assert.assertEquals((long)1L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
            revocableMemory4.setBytes(7L);
            Assert.assertEquals((long)-6L, (long)this.memoryPool.getFreeBytes());
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext3);
        }
        finally {
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMemoryNotRevokedWhenNotEnabled() throws Exception {
        QueryId queryId = new QueryId("query");
        MemoryPool queryLimitMemoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(100.0, DataSize.Unit.GIGABYTE));
        SqlTask sqlTask1 = this.newSqlTask(queryId, queryLimitMemoryPool);
        TestOperatorContext operatorContext11 = this.createTestingOperatorContexts(sqlTask1, "operator11");
        this.allOperatorContexts = ImmutableSet.of((Object)((Object)operatorContext11));
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(queryLimitMemoryPool), () -> TestMemoryRevokingScheduler.lambda$testQueryMemoryNotRevokedWhenNotEnabled$8((List)tasks), this.queryContexts::get, 1.0, 1.0, FeaturesConfig.TaskSpillingStrategy.ORDER_BY_REVOCABLE_BYTES, false);
        try {
            scheduler.start();
            this.assertMemoryRevokingNotRequested();
            operatorContext11.localRevocableMemoryContext().setBytes(600000L);
            scheduler.awaitAsynchronousCallbacksRun();
            this.assertMemoryRevokingNotRequested();
        }
        finally {
            scheduler.stop();
        }
    }

    private OperatorContext createContexts(SqlTask sqlTask) {
        TaskContext taskContext = this.getOrCreateTaskContext(sqlTask);
        PipelineContext pipelineContext = taskContext.addPipelineContext(0, false, false, false);
        DriverContext driverContext = pipelineContext.addDriverContext();
        return driverContext.addOperatorContext(1, new PlanNodeId("na"), "na");
    }

    private TestOperatorContext createTestingOperatorContexts(SqlTask sqlTask, String operatorName) {
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), false)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        TaskContext taskContext = sqlTask.getQueryContext().getTaskContextByTaskId(sqlTask.getTaskId());
        PipelineContext pipelineContext = taskContext.addPipelineContext(0, false, false, false);
        DriverContext driverContext = pipelineContext.addDriverContext();
        TestOperatorContext testOperatorContext = new TestOperatorContext(1, new PlanNodeId("na"), "na", driverContext, this.singleThreadedExecutor, driverContext.getDriverMemoryContext().newMemoryTrackingContext(), operatorName);
        driverContext.addOperatorContext((OperatorContext)testOperatorContext);
        return testOperatorContext;
    }

    private void requestMemoryRevoking(TaskThresholdMemoryRevokingScheduler scheduler) throws Exception {
        scheduler.revokeHighMemoryTasksIfNeeded();
        this.awaitTaskThresholdAsynchronousCallbacksRun();
    }

    private void awaitTaskThresholdAsynchronousCallbacksRun() throws Exception {
        this.singleThreadedScheduledExecutor.invokeAll(Collections.singletonList(() -> null));
    }

    private void assertMemoryRevokingRequestedFor(OperatorContext ... operatorContexts) {
        ImmutableSet operatorContextsSet = ImmutableSet.copyOf((Object[])operatorContexts);
        operatorContextsSet.forEach(operatorContext -> Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested(), (String)("expected memory requested for operator " + operatorContext.getOperatorId())));
        Sets.difference(this.allOperatorContexts, (Set)operatorContextsSet).forEach(operatorContext -> Assert.assertFalse((boolean)operatorContext.isMemoryRevokingRequested(), (String)("expected memory  not requested for operator " + operatorContext.getOperatorId())));
    }

    private void assertMemoryRevokingNotRequested() {
        this.assertMemoryRevokingRequestedFor(new OperatorContext[0]);
    }

    private SqlTask newSqlTask(QueryId queryId, MemoryPool memoryPool) {
        QueryContext queryContext = this.getOrCreateQueryContext(queryId, memoryPool);
        TaskId taskId = new TaskId(queryId.getId(), 0, 0, this.idGeneator.incrementAndGet());
        URI location = URI.create("fake://task/" + taskId);
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)queryContext, (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExchangeClientSupplier)new TestSqlTaskManager.MockExchangeClientSupplier(), (ExecutorService)this.singleThreadedExecutor, (Function)Functions.identity(), (DataSize)new DataSize(32.0, DataSize.Unit.MEGABYTE), (CounterStat)new CounterStat(), (SpoolingOutputBufferFactory)new SpoolingOutputBufferFactory(new FeaturesConfig()));
    }

    private QueryContext getOrCreateQueryContext(QueryId queryId, MemoryPool memoryPool) {
        return this.queryContexts.computeIfAbsent(queryId, id -> new QueryContext(id, new DataSize(500.0, DataSize.Unit.KILOBYTE), new DataSize(500.0, DataSize.Unit.KILOBYTE), new DataSize(500.0, DataSize.Unit.KILOBYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.singleThreadedExecutor, this.scheduledExecutor, new DataSize(1.0, DataSize.Unit.GIGABYTE), this.spillSpaceTracker));
    }

    private TaskContext getOrCreateTaskContext(SqlTask sqlTask) {
        if (!sqlTask.getTaskContext().isPresent()) {
            TaskTestUtils.updateTask(sqlTask, (List<TaskSource>)ImmutableList.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        }
        return (TaskContext)sqlTask.getTaskContext().orElseThrow(() -> new IllegalStateException("TaskContext not present"));
    }

    private static /* synthetic */ List lambda$testQueryMemoryNotRevokedWhenNotEnabled$8(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testRevokesPoolWhenFullBeforeQueryLimit$7(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testQueryMemoryRevoking$6(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testTaskThresholdRevokingSchedulerImmediate$5(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testTaskThresholdRevokingScheduler$4(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testTaskRevokingOrderForRevocableBytes$3(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testTaskRevokingOrderForCreateTime$2(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testCountAlreadyRevokedMemoryWithinAPool$1(List tasks) {
        return tasks;
    }

    private static /* synthetic */ List lambda$testMemoryPoolRevoking$0(List tasks) {
        return tasks;
    }

    private static class TestOperatorContext
    extends OperatorContext {
        public static String firstOperator;
        private final String operatorName;

        public TestOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, DriverContext driverContext, Executor executor, MemoryTrackingContext operatorMemoryContext, String operatorName) {
            super(operatorId, planNodeId, operatorType, driverContext, executor, operatorMemoryContext);
            this.operatorName = operatorName;
        }

        public long requestMemoryRevoking() {
            if (firstOperator == null) {
                firstOperator = this.operatorName;
            }
            return super.requestMemoryRevoking();
        }
    }
}

