/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestResetSessionTask {
    private static final String CATALOG_NAME = "catalog";
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final MetadataManager metadata;

    public TestResetSessionTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.metadata.getSessionPropertyManager().addSystemSessionProperty(PropertyMetadata.stringProperty((String)"foo", (String)"test property", null, (boolean)false));
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        this.metadata.getSessionPropertyManager().addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        catalogManager.registerCatalog(bogusTestingCatalog);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void test() {
        Session session = TestingSession.testSessionBuilder((SessionPropertyManager)this.metadata.getSessionPropertyManager()).setSystemProperty("foo", "bar").setCatalogSessionProperty(CATALOG_NAME, "baz", "blah").build();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine("reset foo", session, false, this.transactionManager, this.executor, this.metadata);
        MoreFutures.getFutureValue((Future)new ResetSessionTask().execute(new ResetSession(QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"baz"})), this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, Collections.emptyList()));
        Set sessionProperties = stateMachine.getResetSessionProperties();
        Assert.assertEquals((Set)sessionProperties, (Set)ImmutableSet.of((Object)"catalog.baz"));
    }
}

