/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageExecutionStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestStageExecutionStateMachine {
    private static final StageExecutionId STAGE_ID = new StageExecutionId(new StageId(new QueryId("query"), 0), 0);
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private final ExecutorService executor = Executors.newCachedThreadPool();

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testBasicStateChanges() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.PLANNED);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULING);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULED);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FINISHED);
    }

    @Test
    public void testPlanned() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.PLANNED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FINISHED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FAILED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.ABORTED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.CANCELED);
    }

    @Test
    public void testScheduling() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULING);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FAILED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.ABORTED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.CANCELED);
    }

    @Test
    public void testScheduled() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULED);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULED);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.SCHEDULED);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FAILED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.ABORTED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.CANCELED);
    }

    @Test
    public void testRunning() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.FAILED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.ABORTED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageExecutionStateMachine.assertState(stateMachine, StageExecutionState.CANCELED);
    }

    @Test
    public void testFinished() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertFinalState(stateMachine, StageExecutionState.FINISHED);
    }

    @Test
    public void testFailed() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageExecutionStateMachine.assertFinalState(stateMachine, StageExecutionState.FAILED);
    }

    @Test
    public void testAborted() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageExecutionStateMachine.assertFinalState(stateMachine, StageExecutionState.ABORTED);
    }

    @Test
    public void testCanceled() {
        StageExecutionStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageExecutionStateMachine.assertFinalState(stateMachine, StageExecutionState.CANCELED);
    }

    private static void assertFinalState(StageExecutionStateMachine stateMachine, StageExecutionState expectedState) {
        Assert.assertTrue((boolean)expectedState.isDone());
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduled());
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFinished());
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToAborted());
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish")));
        TestStageExecutionStateMachine.assertState(stateMachine, expectedState);
    }

    private static void assertState(StageExecutionStateMachine stateMachine, StageExecutionState expectedState) {
        Assert.assertEquals((Object)stateMachine.getStageExecutionId(), (Object)STAGE_ID);
        StageExecutionInfo stageExecutionInfo = stateMachine.getStageExecutionInfo(ImmutableList::of, 0, 0);
        Assert.assertEquals((Collection)stageExecutionInfo.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((Object)stateMachine.getState(), (Object)expectedState);
        Assert.assertEquals((Object)stageExecutionInfo.getState(), (Object)expectedState);
        if (expectedState == StageExecutionState.FAILED) {
            ExecutionFailureInfo failure = (ExecutionFailureInfo)stageExecutionInfo.getFailureCause().get();
            Assert.assertEquals((String)failure.getMessage(), (String)FAILED_CAUSE.getMessage());
            Assert.assertEquals((String)failure.getType(), (String)FAILED_CAUSE.getClass().getName());
        } else {
            Assert.assertFalse((boolean)stageExecutionInfo.getFailureCause().isPresent());
        }
    }

    private StageExecutionStateMachine createStageStateMachine() {
        return new StageExecutionStateMachine(STAGE_ID, this.executor, new SplitSchedulerStats(), false);
    }
}

