/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.FixedCountScheduler;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestFixedCountScheduler {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final MockRemoteTaskFactory taskFactory = new MockRemoteTaskFactory(this.executor, this.scheduledExecutor);

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdown();
    }

    @Test
    public void testSingleNode() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition) -> Optional.of(this.taskFactory.createTableScanTask(new TaskId("test", 1, 0, 1), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.NodeStatsTracker(delta -> {}, delta -> {}, (age, delta) -> {}))), TestFixedCountScheduler.generateRandomNodes(1));
        ScheduleResult result = nodeScheduler.schedule();
        Assert.assertTrue((boolean)result.isFinished());
        Assert.assertTrue((boolean)result.getBlocked().isDone());
        Assert.assertEquals((int)result.getNewTasks().size(), (int)1);
        Assert.assertTrue((boolean)((RemoteTask)result.getNewTasks().iterator().next()).getNodeId().equals("other 0"));
    }

    @Test
    public void testMultipleNodes() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition) -> Optional.of(this.taskFactory.createTableScanTask(new TaskId("test", 1, 0, 1), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.NodeStatsTracker(delta -> {}, delta -> {}, (age, delta) -> {}))), TestFixedCountScheduler.generateRandomNodes(5));
        ScheduleResult result = nodeScheduler.schedule();
        Assert.assertTrue((boolean)result.isFinished());
        Assert.assertTrue((boolean)result.getBlocked().isDone());
        Assert.assertEquals((int)result.getNewTasks().size(), (int)5);
        Assert.assertEquals((int)((ImmutableSet)result.getNewTasks().stream().map(RemoteTask::getNodeId).collect(ImmutableSet.toImmutableSet())).size(), (int)5);
    }

    private static List<InternalNode> generateRandomNodes(int count) {
        return (List)IntStream.range(0, count).mapToObj(i -> new InternalNode("other " + i, URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false)).collect(ImmutableList.toImmutableList());
    }
}

