/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.DynamicSplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.SplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.NoOpFailureDetector;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.split.ConnectorAwareSplitSource;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSourcePartitionedScheduler {
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("connector_id");
    private static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("plan_id");
    private final ExecutorService queryExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final LocationFactory locationFactory = new TestSqlTaskManager.MockLocationFactory();
    private final InMemoryNodeManager nodeManager = new InMemoryNodeManager();
    private final FinalizerService finalizerService = new FinalizerService();

    public TestSourcePartitionedScheduler() {
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
    }

    @BeforeClass
    public void setUp() {
        this.finalizerService.start();
    }

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.queryExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.finalizerService.destroy();
    }

    @Test
    public void testScheduleNoSplits() {
        SubPlan plan = TestSourcePartitionedScheduler.createPlan();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(0, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
        stage.abort();
    }

    @Test
    public void testScheduleSplitsOneAtATime() {
        SubPlan plan = TestSourcePartitionedScheduler.createPlan();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(60, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        for (int i = 0; i < 60; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 59) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i < 3 ? 1 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)(i < 3 ? i + 1 : 3));
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBatched() {
        SubPlan plan = TestSourcePartitionedScheduler.createPlan();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(60, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 7);
        for (int i = 0; i <= 8; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 8) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i == 0 ? 3 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min((i + 1) * 7, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBlock() {
        ScheduleResult scheduleResult;
        SubPlan plan = TestSourcePartitionedScheduler.createPlan();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(80, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        for (int i = 0; i <= 60; ++i) {
            scheduleResult = scheduler.schedule();
            Assert.assertFalse((boolean)scheduleResult.isFinished());
            Assert.assertEquals((boolean)scheduleResult.getBlocked().isDone(), (i != 60 ? 1 : 0) != 0);
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)(i < 3 ? 1 : 0));
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)(i < 3 ? i + 1 : 3));
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        ((MockRemoteTaskFactory.MockRemoteTask)stage.getAllTasks().get(0)).clearSplits();
        for (int i = 0; i < 20; ++i) {
            scheduleResult = scheduler.schedule();
            if (i == 19) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assert.assertFalse((boolean)scheduleResult.isFinished());
            }
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
            Assert.assertEquals((int)stage.getAllTasks().size(), (int)3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 41, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSlowSplitSource() {
        QueuedSplitSource queuedSplitSource = new QueuedSplitSource((Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit));
        SubPlan plan = TestSourcePartitionedScheduler.createPlan();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(queuedSplitSource, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assert.assertFalse((boolean)scheduleResult.isFinished());
        Assert.assertFalse((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)stage.getAllTasks().size(), (int)0);
        queuedSplitSource.addSplits(1);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
    }

    @Test
    public void testNoNodes() {
        try {
            NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
            InMemoryNodeManager nodeManager = new InMemoryNodeManager();
            NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)nodeManager, new NodeSelectionStats(), new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap);
            SubPlan plan = TestSourcePartitionedScheduler.createPlan();
            SqlStageExecution stage = this.createSqlStageExecution(plan, nodeTaskMap);
            StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)new ConnectorAwareSplitSource(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), TestSourcePartitionedScheduler.createFixedSplitSource(20, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit))), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(TestingSession.testSessionBuilder().build(), CONNECTOR_ID), () -> ((SqlStageExecution)stage).getAllTasks()), (int)2);
            scheduler.schedule();
            Assert.fail((String)"expected PrestoException");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NO_NODES_AVAILABLE.toErrorCode());
        }
    }

    @Test
    public void testBalancedSplitAssignment() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SubPlan firstPlan = TestSourcePartitionedScheduler.createPlan();
        SqlStageExecution firstStage = this.createSqlStageExecution(firstPlan, nodeTaskMap);
        StageScheduler firstScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(15, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), firstStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)firstStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)5);
        }
        InternalNode additionalNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{additionalNode});
        SubPlan secondPlan = TestSourcePartitionedScheduler.createPlan();
        SqlStageExecution secondStage = this.createSqlStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(5, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), secondStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200);
        scheduleResult = secondScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, secondScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)1);
        Assert.assertEquals((int)secondStage.getAllTasks().size(), (int)1);
        RemoteTask task = (RemoteTask)secondStage.getAllTasks().get(0);
        Assert.assertEquals((int)task.getPartitionedSplitCount(), (int)5);
        firstStage.abort();
        secondStage.abort();
    }

    @Test
    public void testBlockCausesFullSchedule() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        SubPlan firstPlan = TestSourcePartitionedScheduler.createPlan();
        SqlStageExecution firstStage = this.createSqlStageExecution(firstPlan, nodeTaskMap);
        StageScheduler firstScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(60, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), firstStage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 200);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)firstStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)20);
        }
        SubPlan secondPlan = TestSourcePartitionedScheduler.createPlan();
        SqlStageExecution secondStage = this.createSqlStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = TestSourcePartitionedScheduler.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(5, (Supplier<ConnectorSplit>)((Supplier)TestingSplit::createRemoteSplit)), secondStage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 200);
        scheduleResult = secondScheduler.schedule();
        Assert.assertFalse((boolean)scheduleResult.isFinished());
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)scheduleResult.getNewTasks().size(), (int)3);
        Assert.assertEquals((int)secondStage.getAllTasks().size(), (int)3);
        for (RemoteTask remoteTask : secondStage.getAllTasks()) {
            Assert.assertEquals((int)remoteTask.getPartitionedSplitCount(), (int)0);
        }
        firstStage.abort();
        secondStage.abort();
    }

    private static void assertPartitionedSplitCount(SqlStageExecution stage, int expectedPartitionedSplitCount) {
        Assert.assertEquals((int)stage.getAllTasks().stream().mapToInt(RemoteTask::getPartitionedSplitCount).sum(), (int)expectedPartitionedSplitCount);
    }

    private static void assertEffectivelyFinished(ScheduleResult scheduleResult, StageScheduler scheduler) {
        if (scheduleResult.isFinished()) {
            Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
            return;
        }
        Assert.assertTrue((boolean)scheduleResult.getBlocked().isDone());
        ScheduleResult nextScheduleResult = scheduler.schedule();
        Assert.assertTrue((boolean)nextScheduleResult.isFinished());
        Assert.assertTrue((boolean)nextScheduleResult.getBlocked().isDone());
        Assert.assertEquals((int)nextScheduleResult.getNewTasks().size(), (int)0);
        Assert.assertEquals((int)nextScheduleResult.getSplitsScheduled(), (int)0);
    }

    private static StageScheduler getSourcePartitionedScheduler(ConnectorSplitSource connectorSplitSource, SqlStageExecution stage, InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, int splitBatchSize) {
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(false).setMaxSplitsPerNode(20).setMaxPendingSplitsPerTask(0);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap);
        ConnectorAwareSplitSource splitSource = new ConnectorAwareSplitSource(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), connectorSplitSource);
        DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(TestingSession.testSessionBuilder().build(), splitSource.getConnectorId()), () -> ((SqlStageExecution)stage).getAllTasks());
        return SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((SqlStageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)splitSource, (SplitPlacementPolicy)placementPolicy, (int)splitBatchSize);
    }

    private static SubPlan createPlan() {
        VariableReferenceExpression variable = new VariableReferenceExpression("column", (Type)VarcharType.VARCHAR);
        TableScanNode tableScan = new TableScanNode(TABLE_SCAN_NODE_ID, new TableHandle(CONNECTOR_ID, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List)ImmutableList.of((Object)variable), (Map)ImmutableMap.of((Object)variable, (Object)new TestingMetadata.TestingColumnHandle("column")), TupleDomain.all(), TupleDomain.all());
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("remote_id"), new PlanFragmentId(0), (List)ImmutableList.of(), false, Optional.empty(), ExchangeNode.Type.GATHER);
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId(0), (PlanNode)new JoinNode(new PlanNodeId("join_id"), JoinNode.Type.INNER, (PlanNode)tableScan, (PlanNode)remote, (List)ImmutableList.of(), (List)ImmutableList.builder().addAll((Iterable)tableScan.getOutputVariables()).addAll((Iterable)remote.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of()), (Set)ImmutableSet.of((Object)variable), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of((Object)variable)), StageExecutionDescriptor.ungroupedExecution(), false, StatsAndCosts.empty(), Optional.empty());
        return new SubPlan(testFragment, (List)ImmutableList.of());
    }

    private static ConnectorSplitSource createFixedSplitSource(int splitCount, Supplier<ConnectorSplit> splitFactory) {
        ImmutableList.Builder splits = ImmutableList.builder();
        for (int i = 0; i < splitCount; ++i) {
            splits.add(splitFactory.get());
        }
        return new FixedSplitSource((Iterable)splits.build());
    }

    private SqlStageExecution createSqlStageExecution(SubPlan tableScanPlan, NodeTaskMap nodeTaskMap) {
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageExecutionId)new StageExecutionId(stageId, 0), (PlanFragment)tableScanPlan.getFragment(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.queryExecutor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.queryExecutor, (FailureDetector)new NoOpFailureDetector(), (SplitSchedulerStats)new SplitSchedulerStats(), (TableWriteInfo)new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()));
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        return stage;
    }

    private static class QueuedSplitSource
    implements ConnectorSplitSource {
        private final Supplier<ConnectorSplit> splitFactory;
        private final LinkedBlockingQueue<ConnectorSplit> queue = new LinkedBlockingQueue();
        private CompletableFuture<?> notEmptyFuture = new CompletableFuture();
        private boolean closed;

        public QueuedSplitSource(Supplier<ConnectorSplit> splitFactory) {
            this.splitFactory = Objects.requireNonNull(splitFactory, "splitFactory is null");
        }

        synchronized void addSplits(int count) {
            if (this.closed) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                this.queue.add((ConnectorSplit)this.splitFactory.get());
                this.notEmptyFuture.complete(null);
            }
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            Preconditions.checkArgument((boolean)partitionHandle.equals((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED), (Object)"partitionHandle must be NOT_PARTITIONED");
            return ((CompletableFuture)this.notEmptyFuture.thenApply(x -> this.getBatch(maxSize))).thenApply(splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
        }

        private synchronized List<ConnectorSplit> getBatch(int maxSize) {
            ArrayList elements = new ArrayList(maxSize);
            this.queue.drainTo(elements, maxSize);
            if (this.queue.isEmpty() && !this.closed && this.notEmptyFuture.isDone()) {
                this.notEmptyFuture = new CompletableFuture();
            }
            return ImmutableList.copyOf(elements);
        }

        public synchronized boolean isFinished() {
            return this.closed && this.queue.isEmpty();
        }

        public synchronized void close() {
            this.closed = true;
        }
    }
}

