/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.warnings;

import com.facebook.presto.execution.warnings.DefaultWarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.execution.warnings.WarningHandlingLevel;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultWarningCollector {
    @Test
    public void testNoWarnings() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig().setMaxWarnings(0), WarningHandlingLevel.NORMAL);
        warningCollector.add(new PrestoWarning(new WarningCode(1, "1"), "warning 1"));
        Assert.assertEquals((int)warningCollector.getWarnings().size(), (int)0);
    }

    @Test
    public void testMaxWarnings() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig().setMaxWarnings(2), WarningHandlingLevel.NORMAL);
        warningCollector.add(new PrestoWarning(new WarningCode(1, "1"), "warning 1"));
        warningCollector.add(new PrestoWarning(new WarningCode(2, "2"), "warning 2"));
        warningCollector.add(new PrestoWarning(new WarningCode(3, "3"), "warning 3"));
        Assert.assertEquals((int)warningCollector.getWarnings().size(), (int)2);
    }

    @Test
    public void testWarningSuppress() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig(), WarningHandlingLevel.SUPPRESS);
        warningCollector.add(new PrestoWarning(new WarningCode(1, "1"), "warning 1"));
        Assert.assertEquals((int)warningCollector.getWarnings().size(), (int)0);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testWarningAsErrorThrowsException() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig(), WarningHandlingLevel.AS_ERROR);
        warningCollector.add(new PrestoWarning(new WarningCode(1, "1"), "warning 1"));
    }

    @Test
    public void testWarningAsErrorNoExceptionWhenAddingParserWarning() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig(), WarningHandlingLevel.AS_ERROR);
        warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PARSER_WARNING, "1"));
        Assert.assertEquals((int)warningCollector.getWarnings().size(), (int)1);
    }
}

