/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.NodeMemoryConfig;
import io.airlift.units.DataSize;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLocalMemoryManager {
    @Test
    public void testReservedMemoryDisabled() {
        NodeMemoryConfig config = new NodeMemoryConfig().setReservedPoolEnabled(false).setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        LocalMemoryManager localMemoryManager = new LocalMemoryManager(config, new DataSize(60.0, DataSize.Unit.GIGABYTE).toBytes());
        Assert.assertFalse((boolean)localMemoryManager.getReservedPool().isPresent());
        Assert.assertEquals((int)localMemoryManager.getPools().size(), (int)1);
    }

    @Test
    public void testReservedMemoryEnabled() {
        NodeMemoryConfig config = new NodeMemoryConfig().setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        LocalMemoryManager localMemoryManager = new LocalMemoryManager(config, new DataSize(60.0, DataSize.Unit.GIGABYTE).toBytes());
        Assert.assertTrue((boolean)localMemoryManager.getReservedPool().isPresent());
        Assert.assertEquals((int)localMemoryManager.getPools().size(), (int)2);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMaxQueryMemoryPerNodeBiggerQueryTotalMemoryPerNode() {
        NodeMemoryConfig config = new NodeMemoryConfig().setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(200.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        new LocalMemoryManager(config, new DataSize(60.0, DataSize.Unit.GIGABYTE).toBytes());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Invalid memory configuration.* The sum of max total query memory per node .* and heap headroom .*cannot be larger than the available heap memory .*")
    public void testNotEnoughAvailableMemory() {
        NodeMemoryConfig config = new NodeMemoryConfig().setHeapHeadroom(new DataSize(10.0, DataSize.Unit.GIGABYTE)).setMaxQueryMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(20.0, DataSize.Unit.GIGABYTE));
        new LocalMemoryManager(config, new DataSize(10.0, DataSize.Unit.GIGABYTE).toBytes());
    }
}

