/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeMemoryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setMaxQueryBroadcastMemory(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE)).setMaxQueryMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE)).setSoftMaxQueryMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE)).setMaxQueryTotalMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)).setSoftMaxQueryTotalMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)).setHeapHeadroom(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)).setReservedPoolEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"query.max-broadcast-memory", (Object)"512MB").put((Object)"query.soft-max-memory-per-node", (Object)"512MB").put((Object)"query.max-total-memory-per-node", (Object)"3GB").put((Object)"query.soft-max-total-memory-per-node", (Object)"2GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").put((Object)"experimental.reserved-pool-enabled", (Object)"false").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryBroadcastMemory(new DataSize(512.0, DataSize.Unit.MEGABYTE)).setMaxQueryMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryMemoryPerNode(new DataSize(512.0, DataSize.Unit.MEGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(3.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryTotalMemoryPerNode(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setHeapHeadroom(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setReservedPoolEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testOutOfRangeBroadcastMemoryLimit() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"query.max-broadcast-memory", (Object)"5GB").put((Object)"query.soft-max-memory-per-node", (Object)"512MB").put((Object)"query.max-total-memory-per-node", (Object)"3GB").put((Object)"query.soft-max-total-memory-per-node", (Object)"2GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").put((Object)"experimental.reserved-pool-enabled", (Object)"false").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setMaxQueryBroadcastMemory(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryMemoryPerNode(new DataSize(512.0, DataSize.Unit.MEGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(3.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryTotalMemoryPerNode(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setHeapHeadroom(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setReservedPoolEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidValues() {
        NodeMemoryConfig config = new NodeMemoryConfig();
        config.setMaxQueryTotalMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        config.setHeapHeadroom(new DataSize(3.1, DataSize.Unit.GIGABYTE));
        LocalMemoryManager.validateHeapHeadroom((NodeMemoryConfig)config, (long)new DataSize(4.0, DataSize.Unit.GIGABYTE).toBytes());
    }
}

