/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestQueryContext {
    private static final ScheduledExecutorService TEST_EXECUTOR = Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"test-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        TEST_EXECUTOR.shutdownNow();
    }

    @DataProvider
    public Object[][] testSetMemoryPoolOptions() {
        return new Object[][]{{false}, {true}};
    }

    @Test(dataProvider="testSetMemoryPoolOptions")
    public void testSetMemoryPool(boolean useReservedPool) {
        QueryId secondQuery = new QueryId("second");
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, new DataSize(10.0, DataSize.Unit.BYTE));
        long secondQueryMemory = reservedPool.getMaxBytes() - 1L;
        if (useReservedPool) {
            Assert.assertTrue((boolean)reservedPool.reserve(secondQuery, "test", secondQueryMemory).isDone());
        }
        try (LocalQueryRunner localQueryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);){
            QueryContext queryContext = new QueryContext(new QueryId("query"), new DataSize(10.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(10.0, DataSize.Unit.BYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10.0, DataSize.Unit.BYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)localQueryRunner.getExecutor(), localQueryRunner.getScheduler(), new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
            queryContext.getQueryMemoryContext().initializeLocalMemoryContexts("test");
            LocalMemoryContext userMemoryContext = queryContext.getQueryMemoryContext().localUserMemoryContext();
            LocalMemoryContext revocableMemoryContext = queryContext.getQueryMemoryContext().localRevocableMemoryContext();
            Assert.assertTrue((boolean)userMemoryContext.setBytes(3L).isDone());
            Assert.assertTrue((boolean)revocableMemoryContext.setBytes(5L).isDone());
            queryContext.setMemoryPool(reservedPool);
            if (useReservedPool) {
                reservedPool.free(secondQuery, "test", secondQueryMemory);
            }
            userMemoryContext.close();
            revocableMemoryContext.close();
        }
    }

    @Test(expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp=".*Query exceeded per-node total memory limit of 20B.*")
    public void testChecksTotalMemoryOnUserMemoryAllocation() {
        try (LocalQueryRunner localQueryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);){
            QueryContext queryContext = new QueryContext(new QueryId("query"), new DataSize(10.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(10.0, DataSize.Unit.BYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10.0, DataSize.Unit.BYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)localQueryRunner.getExecutor(), localQueryRunner.getScheduler(), new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
            queryContext.getQueryMemoryContext().initializeLocalMemoryContexts("test");
            LocalMemoryContext systemMemoryContext = queryContext.getQueryMemoryContext().localSystemMemoryContext();
            LocalMemoryContext userMemoryContext = queryContext.getQueryMemoryContext().localUserMemoryContext();
            systemMemoryContext.setBytes(15L);
            userMemoryContext.setBytes(6L);
        }
    }

    @Test
    public void testMoveTaggedAllocations() {
        MemoryPool generalPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        QueryId queryId = new QueryId("query");
        QueryContext queryContext = TestQueryContext.createQueryContext(queryId, generalPool);
        TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"queryid.0.0.0"), (Executor)TEST_EXECUTOR);
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, SessionTestUtils.TEST_SESSION, false, false, false, false, false);
        DriverContext driverContext = taskContext.addPipelineContext(0, false, false, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), "test");
        LocalMemoryContext memoryContext = operatorContext.aggregateUserMemoryContext().newLocalMemoryContext("test_context");
        memoryContext.setBytes(1000L);
        Map allocations = generalPool.getTaggedMemoryAllocations(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        queryContext.setMemoryPool(reservedPool);
        Assert.assertNull((Object)generalPool.getTaggedMemoryAllocations(queryId));
        allocations = reservedPool.getTaggedMemoryAllocations(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)9000L);
        memoryContext.close();
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)10000L);
    }

    private static QueryContext createQueryContext(QueryId queryId, MemoryPool generalPool) {
        return new QueryContext(queryId, new DataSize(10000.0, DataSize.Unit.BYTE), new DataSize(10000.0, DataSize.Unit.BYTE), new DataSize(10000.0, DataSize.Unit.BYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), generalPool, (GcMonitor)new TestingGcMonitor(), (Executor)TEST_EXECUTOR, TEST_EXECUTOR, new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
    }
}

