/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignature {
    @Test
    public void testSerializationRoundTrip() {
        JsonObjectMapperProvider objectMapperProvider = new JsonObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)FunctionAndTypeManager.createTestFunctionAndTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider, true).jsonCodec(Signature.class);
        Signature expected = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"function"), FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"bigint"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"boolean"), (Object)TypeSignature.parseTypeSignature((String)"double"), (Object)TypeSignature.parseTypeSignature((String)"varchar")));
        String json = codec.toJson((Object)expected);
        Signature actual = (Signature)codec.fromJson(json);
        Assert.assertEquals((String)actual.getNameSuffix(), (String)expected.getNameSuffix());
        Assert.assertEquals((Object)actual.getKind(), (Object)expected.getKind());
        Assert.assertEquals((Object)actual.getReturnType(), (Object)expected.getReturnType());
        Assert.assertEquals((Collection)actual.getArgumentTypes(), (Collection)expected.getArgumentTypes());
    }
}

