/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.operator.SimpleArrayAllocator;
import com.facebook.presto.operator.UncheckedStackArrayAllocator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayAllocator {
    @Benchmark
    public void borrowAndReturnArrays(BenchmarkData data) {
        for (int i = 0; i < 100000; ++i) {
            data.borrowAndReturnArrays();
        }
    }

    @Test
    public void verifyBorrowAndReturnArrays() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.borrowAndReturnArrays(data);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkArrayAllocator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int ARRAY_COUNT = 1000;
        private final Random random = new Random(0L);
        private final int[][] allocatedArrays = new int[1000][];
        private final int[] arrayLengths = new int[1000];
        @Param(value={"SimpleArrayAllocator", "UncheckedStackArrayAllocator"})
        private String arrayAllocatorType = "SimpleArrayAllocator";
        private ArrayAllocator arrayAllocator;

        @Setup
        public void setup() {
            switch (this.arrayAllocatorType) {
                case "SimpleArrayAllocator": {
                    this.arrayAllocator = new SimpleArrayAllocator();
                    break;
                }
                case "UncheckedStackArrayAllocator": {
                    this.arrayAllocator = new UncheckedStackArrayAllocator();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported arrayAllocatorType");
                }
            }
            for (int i = 0; i < 1000; ++i) {
                this.arrayLengths[i] = this.random.nextInt(100);
            }
        }

        private void borrowAndReturnArrays() {
            int i;
            for (i = 0; i < 1000; ++i) {
                this.allocatedArrays[i] = this.arrayAllocator.borrowIntArray(this.arrayLengths[i]);
            }
            for (i = 999; i >= 0; --i) {
                this.arrayAllocator.returnArray(this.allocatedArrays[i]);
            }
        }
    }
}

