/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import io.airlift.compress.Compressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkCompressToByteBuffer {
    @Benchmark
    public void compressToByteBuffer(BenchmarkData data) {
        data.byteBuffer.mark();
        BenchmarkData.COMPRESSOR.compress(data.slice.toByteBuffer(), data.byteBuffer);
        data.byteBuffer.reset();
    }

    @Benchmark
    public void compressToByteArray(BenchmarkData data) {
        BenchmarkData.COMPRESSOR.compress((byte[])data.slice.getBase(), 0, data.slice.length(), data.bytes, 0, BenchmarkData.MAX_COMPRESSED_SIZE);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkCompressToByteBuffer.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final Random RANDOM = new Random(0L);
        private static final Compressor COMPRESSOR = new Lz4Compressor();
        private static final int UNCOMPRESSED_SIZE = 1000000;
        private static final int MAX_COMPRESSED_SIZE = COMPRESSOR.maxCompressedLength(1000000);
        private final byte[] byteValues = new byte[1000000];
        private final Slice slice = Slices.wrappedBuffer((byte[])this.byteValues);
        private final byte[] bytes = new byte[MAX_COMPRESSED_SIZE];
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_COMPRESSED_SIZE);

        @Setup
        public void setup() {
            int runLength = 100000;
            byte[] randomBytes = new byte[runLength];
            for (int i = 0; i < 10; i += 2) {
                RANDOM.nextBytes(randomBytes);
                System.arraycopy(randomBytes, 0, this.byteValues, i * runLength, runLength);
            }
        }
    }
}

