/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.UncheckedByteArrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import sun.misc.Unsafe;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=0)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkReadBlock {
    @Benchmark
    public int sequentialCopyLongValues(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[i]);
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyLongArrayBlock(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockNoNulls.getLong(i));
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyUncheckedLongArrayBlock(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockNoNulls.getLongUnchecked(i));
        }
        return index;
    }

    @Benchmark
    public int randomCopyLongValues(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[data.positions[i]]);
        }
        return index;
    }

    @Benchmark
    public int randomCopyLongArrayBlock(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockNoNulls.getLong(data.positions[i]));
        }
        return index;
    }

    @Benchmark
    public int randomCopyUncheckedLongArrayBlock(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockNoNulls.getLongUnchecked(data.positions[i]));
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyLongValuesWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[i]);
            if (data.nulls[i]) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyLongArrayBlockWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockWithNulls.getLong(i));
            if (data.blockWithNulls.isNull(i)) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyUncheckedLongArrayBlockWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockWithNulls.getLongUnchecked(i));
            if (data.blockWithNulls.isNullUnchecked(i)) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int randomCopyLongValuesWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[data.positions[i]]);
            if (data.nulls[data.positions[i]]) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int randomCopyLongArrayBlockWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockNoNulls.getLong(data.positions[i]));
            if (data.blockWithNulls.isNull(data.positions[i])) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int randomCopyUncheckedLongArrayBlockWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.blockNoNulls.getLongUnchecked(data.positions[i]));
            if (data.blockWithNulls.isNullUnchecked(data.positions[i])) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int randomCopyLongValuesWithDictionary(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[data.ids[data.positions[i]]]);
        }
        return index;
    }

    @Benchmark
    public int randomCopyDictionaryBlock(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.dictionaryBlockNoNulls.getLong(data.positions[i]));
        }
        return index;
    }

    @Benchmark
    public int randomCopyUncheckedDictionaryBlock(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.dictionaryBlockNoNulls.getLongUnchecked(data.positions[i]));
        }
        return index;
    }

    @Benchmark
    public int randomCopyLongValuesWithDictionaryWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[data.positions[i]]);
            if (data.nulls[data.ids[data.positions[i]]]) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int randomCopyDictionaryBlockWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.dictionaryBlockWithNulls.getLong(data.positions[i]));
            if (data.dictionaryBlockWithNulls.isNull(data.positions[i])) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int randomCopyUncheckedDictionaryBlockWithNulls(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.dictionaryBlockWithNulls.getLongUnchecked(data.positions[i]));
            if (data.dictionaryBlockWithNulls.isNullUnchecked(data.positions[i])) continue;
            index = newIndex;
        }
        return index;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkReadBlock.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int POSITIONS_PER_PAGE = 10000;
        private final Random random = new Random(0L);
        private final long[] longValues = new long[10000];
        private final boolean[] nulls = new boolean[10000];
        private final int[] ids = new int[10000];
        private final int[] positions = new int[10000];
        private final Block blockNoNulls = BlockAssertions.createRandomLongsBlock(10000, 0.0f);
        private final Block blockWithNulls = BlockAssertions.createRandomLongsBlock(10000, 0.2f);
        private final Block dictionaryBlockNoNulls = BlockAssertions.createRandomDictionaryBlock(this.blockNoNulls, 10000);
        private final Block dictionaryBlockWithNulls = BlockAssertions.createRandomDictionaryBlock(this.blockWithNulls, 10000);
        private final byte[] bytes = new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE];

        @Setup
        public void setup() {
            for (int i = 0; i < 10000; ++i) {
                this.longValues[i] = this.random.nextLong();
                this.ids[i] = this.random.nextInt(1000);
                this.positions[i] = i;
                this.nulls[i] = i % 7 == 0;
            }
        }
    }
}

