/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.unnest.UnnestOperator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=8, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=8, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkUnnestOperator {
    private static final int TOTAL_POSITIONS = 10000;

    @Benchmark
    public List<Page> unnest(BenchmarkData context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkUnnestOperator().unnest(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkUnnestOperator.class.getSimpleName() + ".*").addProfiler(GCProfiler.class).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"bigint", "varchar"})
        private String replicateType = "bigint";
        @Param(value={"array(varchar)", "array(integer)", "map(varchar,varchar)", "array(row(varchar,varchar,varchar))", "array(array(varchar))", "array(bigint)|array(bigint)", "array(varchar)|array(varchar)"})
        private String nestedType = "array(bigint)";
        @Param(value={"0.0", "0.2"})
        private float primitiveNullsRatio;
        @Param(value={"0.0", "0.05"})
        private float rowNullsRatio;
        @Param(value={"1000"})
        private int positionsPerPage = 1000;
        @Param(value={"false", "true"})
        private boolean withOrdinality;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages = new ArrayList<Page>();

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            ImmutableList.Builder replicatedTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder unnestTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder replicatedChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder unnestChannelsBuilder = ImmutableList.builder();
            String[] replicatedTypes = this.replicateType.split("\\|");
            for (int i = 0; i < replicatedTypes.length; ++i) {
                Type replicateType = this.getType((Metadata)metadata, replicatedTypes[i]).get();
                typesBuilder.add((Object)replicateType);
                replicatedTypesBuilder.add((Object)replicateType);
                replicatedChannelsBuilder.add((Object)i);
            }
            String[] unnestTypes = this.nestedType.split("\\|");
            for (int i = 0; i < unnestTypes.length; ++i) {
                Type unnestType = this.getType((Metadata)metadata, unnestTypes[i]).get();
                typesBuilder.add((Object)unnestType);
                unnestTypesBuilder.add((Object)unnestType);
                unnestChannelsBuilder.add((Object)(i + replicatedTypes.length));
            }
            int pageCount = 10000 / this.positionsPerPage;
            for (int i = 0; i < pageCount; ++i) {
                this.pages.add(PageAssertions.createPageWithRandomData((List<Type>)typesBuilder.build(), this.positionsPerPage, false, false, this.primitiveNullsRatio, this.rowNullsRatio, false, (List<BlockAssertions.Encoding>)ImmutableList.of()));
            }
            this.operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)replicatedChannelsBuilder.build(), (List)replicatedTypesBuilder.build(), (List)unnestChannelsBuilder.build(), (List)unnestTypesBuilder.build(), this.withOrdinality);
        }

        public Optional<Type> getType(Metadata metadata, String typeString) {
            if (typeString.equals("NONE")) {
                return Optional.empty();
            }
            TypeSignature signature = TypeSignature.parseTypeSignature((String)typeString);
            return Optional.of(metadata.getType(signature));
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(2.0, DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

