/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.DynamicFilterSourceOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDynamicFilterSourceOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private PipelineContext pipelineContext;
    private ImmutableList.Builder<TupleDomain<String>> partitions;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.pipelineContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false);
        this.partitions = ImmutableList.builder();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    private void verifyPassThrough(Operator operator, List<Type> types, Page ... pages) {
        ImmutableList inputPages = ImmutableList.copyOf((Object[])pages);
        List<Page> outputPages = OperatorAssertion.toPages(operator, inputPages.iterator());
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, outputPages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, (List<Page>)inputPages);
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    private OperatorFactory createOperatorFactory(DynamicFilterSourceOperator.Channel ... buildChannels) {
        return new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(0, new PlanNodeId("PLAN_NODE_ID"), this::consumePredicate, Arrays.stream(buildChannels).collect(Collectors.toList()), SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)SessionTestUtils.TEST_SESSION), SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)SessionTestUtils.TEST_SESSION));
    }

    private void consumePredicate(TupleDomain<String> partitionPredicate) {
        this.partitions.add(partitionPredicate);
    }

    private Operator createOperator(OperatorFactory operatorFactory) {
        return operatorFactory.createOperator(this.pipelineContext.addDriverContext());
    }

    private static DynamicFilterSourceOperator.Channel channel(int index, Type type) {
        return new DynamicFilterSourceOperator.Channel(Integer.toString(index), type, index);
    }

    @Test
    public void testCollectMultipleOperators() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        Operator operator1 = this.createOperator(operatorFactory);
        this.verifyPassThrough(operator1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2)}), new Page(new Block[]{BlockAssertions.createLongsBlock(3, 5)}));
        Operator operator2 = this.createOperator(operatorFactory);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L))))));
        this.verifyPassThrough(operator2, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(2, 3)}), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 4)}));
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L)))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L))))));
    }

    @Test
    public void testCollectMultipleColumns() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN), TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false)), (Object)"1", (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectOnlyFirstColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false))))));
    }

    @Test
    public void testCollectOnlyLastColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"1", (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectWithNulls() {
        Block blockWithNulls = IntegerType.INTEGER.createFixedSizeBlockBuilder(0).writeInt(3).appendNull().writeInt(4).build();
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)IntegerType.INTEGER));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}), new Page(new Block[]{blockWithNulls}), new Page(new Block[]{BlockAssertions.createLongsBlock(4, 5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}), (boolean)false)))));
    }

    @Test
    public void testCollectNoFilters() {
        OperatorFactory operatorFactory = this.createOperatorFactory(new DynamicFilterSourceOperator.Channel[0]);
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectEmptyBuildSide() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page[0]);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.none()));
    }

    @Test
    public void testCollectTooManyRows() {
        int maxRowCount = SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)this.pipelineContext.getSession());
        Page largePage = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), maxRowCount + 1);
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), largePage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooManyBytesSingleColumn() {
        long maxByteSize = SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)this.pipelineContext.getSession()).toBytes();
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock(Strings.repeat((String)"A", (int)((int)maxByteSize + 1)))});
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)VarcharType.VARCHAR));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), largePage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooManyBytesMultipleColumns() {
        long maxByteSize = SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)this.pipelineContext.getSession()).toBytes();
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock(Strings.repeat((String)"A", (int)((int)(maxByteSize / 2L) + 1))), BlockAssertions.createStringsBlock(Strings.repeat((String)"B", (int)((int)(maxByteSize / 2L) + 1)))});
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)VarcharType.VARCHAR), TestDynamicFilterSourceOperator.channel(1, (Type)VarcharType.VARCHAR));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), largePage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectDeduplication() {
        int maxRowCount = SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)this.pipelineContext.getSession());
        Page largePage = new Page(new Block[]{BlockAssertions.createLongRepeatBlock(7, maxRowCount * 10)});
        Page nullsPage = new Page(new Block[]{BlockAssertions.createLongsBlock(Arrays.asList(new Long[maxRowCount * 10]))});
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassThrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), largePage, nullsPage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)7L, (Object[])new Object[0]), (boolean)false)))));
    }
}

