/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.operator.FileFragmentResultCacheConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFileFragmentResultCacheConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FileFragmentResultCacheConfig)ConfigAssertions.recordDefaults(FileFragmentResultCacheConfig.class)).setCachingEnabled(false).setBaseDirectory(null).setBlockEncodingCompressionEnabled(false).setMaxCachedEntries(10000).setCacheTtl(new Duration(2.0, TimeUnit.DAYS)).setMaxInFlightSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() throws Exception {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"fragment-result-cache.enabled", (Object)"true").put((Object)"fragment-result-cache.base-directory", (Object)"tcp://abc").put((Object)"fragment-result-cache.block-encoding-compression-enabled", (Object)"true").put((Object)"fragment-result-cache.max-cached-entries", (Object)"100000").put((Object)"fragment-result-cache.cache-ttl", (Object)"1d").put((Object)"fragment-result-cache.max-in-flight-size", (Object)"2GB").build();
        FileFragmentResultCacheConfig expected = new FileFragmentResultCacheConfig().setCachingEnabled(true).setBaseDirectory(new URI("tcp://abc")).setBlockEncodingCompressionEnabled(true).setMaxCachedEntries(100000).setCacheTtl(new Duration(1.0, TimeUnit.DAYS)).setMaxInFlightSize(new DataSize(2.0, DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

