/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.FileFragmentResultCacheConfig;
import com.facebook.presto.operator.FileFragmentResultCacheManager;
import com.facebook.presto.operator.FragmentCacheStats;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFileFragmentResultCacheManager {
    private static final String SERIALIZED_PLAN_FRAGMENT_1 = "test plan fragment 1";
    private static final String SERIALIZED_PLAN_FRAGMENT_2 = "test plan fragment 2";
    private static final Split SPLIT_1 = new Split(new ConnectorId("test"), new ConnectorTransactionHandle(){}, (ConnectorSplit)new TestingSplit(1));
    private static final Split SPLIT_2 = new Split(new ConnectorId("test"), new ConnectorTransactionHandle(){}, (ConnectorSplit)new TestingSplit(2));
    private final ExecutorService writeExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"test-cache-flusher-%s"));
    private final ExecutorService removalExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"test-cache-remover-%s"));
    private URI cacheDirectory;

    @BeforeClass
    public void setup() throws Exception {
        this.cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]).toUri();
    }

    @AfterClass
    public void close() throws IOException {
        this.writeExecutor.shutdown();
        this.removalExecutor.shutdown();
        Preconditions.checkState((this.cacheDirectory != null ? 1 : 0) != 0);
        File[] files = new File(this.cacheDirectory).listFiles();
        if (files != null) {
            for (File file : files) {
                Files.delete(file.toPath());
            }
        }
        Files.deleteIfExists(new File(this.cacheDirectory).toPath());
    }

    @Test(timeOut=30000L)
    public void testBasic() throws Exception {
        FragmentCacheStats stats = new FragmentCacheStats();
        FileFragmentResultCacheManager cacheManager = this.fileFragmentResultCacheManager(stats);
        Assert.assertFalse((boolean)cacheManager.get(SERIALIZED_PLAN_FRAGMENT_1, SPLIT_1).isPresent());
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)0L);
        Assert.assertEquals((long)stats.getCacheEntries(), (long)0L);
        cacheManager.put(SERIALIZED_PLAN_FRAGMENT_1, SPLIT_1, (List)ImmutableList.of()).get();
        Optional result = cacheManager.get(SERIALIZED_PLAN_FRAGMENT_1, SPLIT_1);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertFalse((boolean)((Iterator)result.get()).hasNext());
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)1L);
        Assert.assertEquals((long)stats.getCacheEntries(), (long)1L);
        ImmutableList pages = ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createStringsBlock("plan-1-split-2")}));
        cacheManager.put(SERIALIZED_PLAN_FRAGMENT_2, SPLIT_2, (List)pages).get();
        result = cacheManager.get(SERIALIZED_PLAN_FRAGMENT_2, SPLIT_2);
        Assert.assertTrue((boolean)result.isPresent());
        TestFileFragmentResultCacheManager.assertPagesEqual((Iterator)result.get(), pages.iterator());
        Assert.assertEquals((long)stats.getCacheMiss(), (long)1L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)2L);
        Assert.assertEquals((long)stats.getCacheEntries(), (long)2L);
        cacheManager.get(SERIALIZED_PLAN_FRAGMENT_1, SPLIT_2);
        Assert.assertEquals((long)stats.getCacheMiss(), (long)2L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)2L);
        Assert.assertEquals((long)stats.getCacheEntries(), (long)2L);
        cacheManager.get(SERIALIZED_PLAN_FRAGMENT_2, SPLIT_1);
        Assert.assertEquals((long)stats.getCacheMiss(), (long)3L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)2L);
        Assert.assertEquals((long)stats.getCacheEntries(), (long)2L);
        cacheManager.invalidateAllCache();
        Assert.assertEquals((long)stats.getCacheMiss(), (long)3L);
        Assert.assertEquals((long)stats.getCacheHit(), (long)2L);
        Assert.assertEquals((long)stats.getCacheEntries(), (long)0L);
        Assert.assertEquals((long)stats.getCacheRemoval(), (long)2L);
    }

    private static void assertPagesEqual(Iterator<Page> pages1, Iterator<Page> pages2) {
        while (pages1.hasNext() && pages2.hasNext()) {
            Page page1 = pages1.next();
            Page page2 = pages2.next();
            Assert.assertEquals((int)page1.getChannelCount(), (int)page2.getChannelCount());
            for (int i = 0; i < page1.getChannelCount(); ++i) {
                Assert.assertTrue((boolean)page1.getBlock(i).equals(0, 0, page2.getBlock(i), 0, 0, page1.getBlock(0).getSliceLength(0)));
            }
        }
        Assert.assertFalse((boolean)pages1.hasNext());
        Assert.assertFalse((boolean)pages2.hasNext());
    }

    private FileFragmentResultCacheManager fileFragmentResultCacheManager(FragmentCacheStats fragmentCacheStats) {
        FileFragmentResultCacheConfig cacheConfig = new FileFragmentResultCacheConfig();
        return new FileFragmentResultCacheManager(cacheConfig.setBaseDirectory(this.cacheDirectory), (BlockEncodingSerde)new TestingBlockEncodingSerde(new BlockEncoding[0]), fragmentCacheStats, this.writeExecutor, this.removalExecutor);
    }

    private static class TestingSplit
    implements ConnectorSplit {
        private final int id;

        public TestingSplit(int id) {
            this.id = id;
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.NO_PREFERENCE;
        }

        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }

        public Object getSplitIdentifier() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingSplit that = (TestingSplit)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", this.id).toString();
        }
    }
}

