/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHashYieldAssertion;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashSemiJoinOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private TaskContext taskContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{VarcharType.VARCHAR}, {BigintType.BIGINT}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testSemiJoin(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(10L).row(30L).row(30L).row(35L).row(36L).row(37L).row(50L).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), rowPagesBuilder.getTypes().get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(10, 30, 0).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, new PlanNodeId("test"), setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{30L, 0L, true}).row(new Object[]{31L, 1L, false}).row(new Object[]{32L, 2L, false}).row(new Object[]{33L, 3L, false}).row(new Object[]{34L, 4L, false}).row(new Object[]{35L, 5L, true}).row(new Object[]{36L, 6L, true}).row(new Object[]{37L, 7L, true}).row(new Object[]{38L, 8L, false}).row(new Object[]{39L, 9L, false}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="dataType")
    public void testSemiJoinMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 5000, 500);
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), type, 0, Optional.of(1), 10, new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)setBuilderOperatorFactory, operator -> ((SetBuilderOperator)operator).getCapacity(), 1400000L);
        Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        Assert.assertEquals((int)result.getOutput().stream().mapToInt(Page::getPositionCount).sum(), (int)0);
    }

    @Test(dataProvider="hashEnabledValues")
    public void testBuildSideNulls(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(0L).row(1L).row(2L).row(2L).row(3L).row(new Object[]{null}).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(4, 1).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, new PlanNodeId("test"), setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{1L, true}).row(new Object[]{2L, true}).row(new Object[]{3L, true}).row(new Object[]{4L, null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testProbeSideNulls(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(0L).row(1L).row(3L).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row(0L).row(new Object[]{null}).row(1L).row(2L).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, new PlanNodeId("test"), setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0L, true}).row(new Object[]{null, null}).row(new Object[]{1L, true}).row(new Object[]{2L, false}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testProbeAndBuildNulls(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(0L).row(1L).row(new Object[]{null}).row(3L).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row(0L).row(new Object[]{null}).row(1L).row(2L).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, new PlanNodeId("test"), setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0L, true}).row(new Object[]{null, null}).row(new Object[]{1L, true}).row(new Object[]{2L, null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test(dataProvider="hashEnabledValues", expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Query exceeded per-node user memory limit of.*")
    public void testMemoryLimit(boolean hashEnabled) {
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(100.0, DataSize.Unit.BYTE)).addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.addSequencePage(10000, 20).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
    }
}

