/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.MoreByteArrays;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Bytes;
import io.airlift.slice.ByteArrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;
import sun.misc.Unsafe;

public class TestMoreByteArrays {
    private static final int POSITIONS_PER_PAGE = 10000;

    private TestMoreByteArrays() {
    }

    @Test
    public static void testFill() {
        byte[] destination = new byte[10000];
        int filledBytes = MoreByteArrays.fill((byte[])destination, (int)0, (int)10000, (byte)5);
        Assert.assertEquals((int)filledBytes, (int)10000);
        TestMoreByteArrays.assertCopied(Collections.nCopies(10000, (byte)5), destination, Unsafe.ARRAY_BYTE_INDEX_SCALE, MoreByteArrays::getByte);
    }

    @Test
    public static void testSetBytes() {
        byte[] destination = new byte[10000];
        byte[] source = new byte[10000];
        ThreadLocalRandom.current().nextBytes(source);
        int setBytes = MoreByteArrays.setBytes((byte[])destination, (int)0, (byte[])source, (int)0, (int)10000);
        Assert.assertEquals((int)setBytes, (int)10000);
        TestMoreByteArrays.assertCopied(Bytes.asList((byte[])source), destination, Unsafe.ARRAY_BYTE_INDEX_SCALE, MoreByteArrays::getByte);
    }

    @Test
    public static void testSetInts() {
        byte[] destination = new byte[10000 * Unsafe.ARRAY_INT_INDEX_SCALE];
        int copiedBytes = MoreByteArrays.setInts((byte[])destination, (int)0, (int[])IntStream.range(0, 10000).toArray(), (int)0, (int)10000);
        Assert.assertEquals((int)copiedBytes, (int)(10000 * Unsafe.ARRAY_INT_INDEX_SCALE));
        TestMoreByteArrays.assertCopied((List)IntStream.range(0, 10000).boxed().collect(ImmutableList.toImmutableList()), destination, Unsafe.ARRAY_INT_INDEX_SCALE, ByteArrays::getInt);
    }

    private static <T> void assertCopied(List<T> expected, byte[] actual, int elementSize, BiFunction<byte[], Integer, T> readFunction) {
        for (int index = 0; index < expected.size(); ++index) {
            Assert.assertEquals(readFunction.apply(actual, index * elementSize), expected.get(index));
        }
    }
}

