/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.PartitionedOutputBuffer;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.operator.repartition.PartitionedOutputOperator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionedOutputOperator {
    private static final int PAGE_COUNT = 100;
    private static final int POSITIONS_PER_PAGE = 1000;
    private static final int PARTITION_COUNT = 512;
    private static final DataSize MAX_MEMORY = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private static final DataSize PARTITION_MAX_MEMORY = new DataSize(5.0, DataSize.Unit.MEGABYTE);
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final List<Type> REPLICATION_TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-EXECUTOR-%s"));
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"test-%s"));
    private static final Block NULL_BLOCK = new RunLengthEncodedBlock(BigintType.BIGINT.createBlockBuilder(null, 1).appendNull().build(), 1000);
    private static final Block TESTING_BLOCK = BlockAssertions.createLongSequenceBlock(0, 1000);
    private static final Block TESTING_DICTIONARY_BLOCK = BlockAssertions.createLongDictionaryBlock(0, 1000);
    private static final Block TESTING_RLE_BLOCK = BlockAssertions.createRLEBlock(new Random(0L).nextLong(), 1000);
    private static final Page TESTING_PAGE = new Page(new Block[]{TESTING_BLOCK});
    private static final Page TESTING_PAGE_WITH_NULL_BLOCK = new Page(1000, new Block[]{NULL_BLOCK, TESTING_BLOCK});

    @Test
    public void testOutputForSimplePage() {
        PartitionedOutputOperator partitionedOutputOperator = TestPartitionedOutputOperator.createPartitionedOutputOperator(false);
        for (int i = 0; i < 100; ++i) {
            partitionedOutputOperator.addInput(TESTING_PAGE);
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(100L * TESTING_PAGE.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(100 * TESTING_PAGE.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithDictionary() {
        PartitionedOutputOperator partitionedOutputOperator = TestPartitionedOutputOperator.createPartitionedOutputOperator(false);
        for (int i = 0; i < 100; ++i) {
            partitionedOutputOperator.addInput(new Page(new Block[]{TESTING_DICTIONARY_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(100L * TESTING_PAGE.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(100 * TESTING_PAGE.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithRunLength() {
        PartitionedOutputOperator partitionedOutputOperator = TestPartitionedOutputOperator.createPartitionedOutputOperator(false);
        for (int i = 0; i < 100; ++i) {
            partitionedOutputOperator.addInput(new Page(new Block[]{TESTING_RLE_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(100L * TESTING_PAGE.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(100 * TESTING_PAGE.getPositionCount()));
    }

    @Test
    public void testOutputForSimplePageAndReplication() {
        PartitionedOutputOperator partitionedOutputOperator = TestPartitionedOutputOperator.createPartitionedOutputOperator(true);
        for (int i = 0; i < 100; ++i) {
            partitionedOutputOperator.addInput(new Page(1000, new Block[]{NULL_BLOCK, TESTING_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(51200L * TESTING_PAGE_WITH_NULL_BLOCK.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(51200 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithDictionaryAndReplication() {
        PartitionedOutputOperator partitionedOutputOperator = TestPartitionedOutputOperator.createPartitionedOutputOperator(true);
        for (int i = 0; i < 100; ++i) {
            partitionedOutputOperator.addInput(new Page(1000, new Block[]{NULL_BLOCK, TESTING_DICTIONARY_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(51200L * TESTING_PAGE_WITH_NULL_BLOCK.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(51200 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithRunLengthAndReplication() {
        PartitionedOutputOperator partitionedOutputOperator = TestPartitionedOutputOperator.createPartitionedOutputOperator(true);
        for (int i = 0; i < 100; ++i) {
            partitionedOutputOperator.addInput(new Page(1000, new Block[]{NULL_BLOCK, TESTING_RLE_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(51200L * TESTING_PAGE_WITH_NULL_BLOCK.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(51200 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount()));
    }

    private static PartitionedOutputOperator createPartitionedOutputOperator(boolean shouldReplicate) {
        LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new InterpretedHashGenerator((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}), 512);
        OutputPartitioning outputPartitioning = shouldReplicate ? new OutputPartitioning((PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty()), true, OptionalInt.of(0)) : new OutputPartitioning((PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty(), Optional.empty()), false, OptionalInt.empty());
        PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager(), false);
        DriverContext driverContext = TestingTaskContext.builder((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULER, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(MAX_MEMORY).setQueryMaxTotalMemory(MAX_MEMORY).build().addPipelineContext(0, true, true, false).addDriverContext();
        OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
        for (int partition = 0; partition < 512; ++partition) {
            buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
        }
        PartitionedOutputBuffer buffer = new PartitionedOutputBuffer("task-instance-id", new StateMachine("bufferState", (Executor)SCHEDULER, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers.withNoMoreBufferIds(), new DataSize(9.223372036854776E18, DataSize.Unit.BYTE), () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)SCHEDULER);
        buffer.registerLifespanCompletionCallback(ignore -> {});
        if (shouldReplicate) {
            PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((OutputBuffer)buffer, PARTITION_MAX_MEMORY);
            return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), REPLICATION_TYPES, Function.identity(), Optional.of(outputPartitioning), serdeFactory).createOperator(driverContext);
        }
        PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((OutputBuffer)buffer, PARTITION_MAX_MEMORY);
        return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), TYPES, Function.identity(), Optional.of(outputPartitioning), serdeFactory).createOperator(driverContext);
    }
}

