/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GenericLongFunction;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.operator.project.TestPageProcessor;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.testng.annotations.Test;

public class TestScanFilterAndProjectOperator
extends AbstractTestFunctions {
    private static final TableHandle TESTING_TABLE_HANDLE = new TableHandle(new ConnectorId("test"), new ConnectorTableHandle(){}, new ConnectorTransactionHandle(){}, Optional.empty());
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)this.metadata, new PageFunctionCompiler((Metadata)this.metadata, 0));
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));

    @Test
    public void testPageSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageSourceMergeOutput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).build();
        CallExpression filter = Expressions.call((String)OperatorType.EQUAL.name(), (FunctionHandle)MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.of(filter), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(SessionTestUtils.TEST_SESSION.getSqlFunctionProperties(), Optional.of(filter), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new FixedPageSource((Iterable)input), cursorProcessor, pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.empty(), new DataSize(64.0, DataSize.Unit.KILOBYTE), 2);
        SourceOperator operator = factory.createOperator(this.newDriverContext());
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        List<Page> actual = TestScanFilterAndProjectOperator.toPages((Operator)operator);
        Assert.assertEquals((int)actual.size(), (int)1);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(10L).row(10L).row(10L).row(10L).build();
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actual.get(0), expected.get(0));
    }

    @Test
    public void testPageSourceLazyLoad() {
        Block inputBlock = BlockAssertions.createLongSequenceBlock(0, 100);
        Page input = new Page(100, new Block[]{inputBlock, new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections, (Object)"key");
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestPageProcessor.SelectAllFilter()), (List)ImmutableList.of((Object)new PageProjectionWithOutputs((PageProjection)new TestPageProcessor.LazyPagePageProjection(), new int[]{0})));
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new SinglePagePageSource(input), cursorProcessor, () -> pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{inputBlock})));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageSourceLazyBlock() {
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections);
        Block inputBlock = BlockAssertions.createLongSequenceBlock(0, 10);
        CountingLazyPageSource pageSource = new CountingLazyPageSource((List<Page>)ImmutableList.of((Object)new Page(new Block[]{inputBlock})));
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> pageSource, cursorProcessor, pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{inputBlock})));
        Page expectedPage = expected.toPage();
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Page actualPage = actual.toPage();
        PageAssertions.assertPageEquals(actual.getTypes(), actualPage, expectedPage);
        Assert.assertEquals((long)pageSource.getCompletedBytes(), (long)expectedPage.getSizeInBytes());
        Assert.assertEquals((long)pageSource.getCompletedPositions(), (long)expectedPage.getPositionCount());
        Assert.assertEquals((long)operator.getOperatorContext().getOperatorStats().getRawInputDataSize().toBytes(), (long)expectedPage.getSizeInBytes());
        Assert.assertEquals((long)operator.getOperatorContext().getOperatorStats().getInputPositions(), (long)expected.getRowCount());
    }

    @Test
    public void testRecordCursorSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)VarcharType.VARCHAR), input)), cursorProcessor, pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageYield() {
        int totalRows = 1000;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), totalRows, 1);
        DriverContext driverContext = this.newDriverContext();
        int totalColumns = 20;
        ImmutableList.Builder functions = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            functions.add((Object)new GenericLongFunction("page_col" + i, value -> {
                driverContext.getYieldSignal().forceYieldForTesting();
                return value;
            }));
        }
        Metadata metadata = this.functionAssertions.getMetadata();
        FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
        functionAndTypeManager.registerBuiltInFunctions((List)functions.build());
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(metadata, new PageFunctionCompiler(metadata, 0));
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            projections.add((Object)Expressions.call((String)"generic_long_page_col", (FunctionHandle)functionAndTypeManager.lookupFunction("generic_long_page_col" + i, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        }
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections.build(), (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections.build(), false, 8192);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int i = 1; i <= totalRows * totalColumns; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            Page page = operator.getOutput();
            if (i == totalColumns) {
                org.testng.Assert.assertNotNull((Object)page);
                Assert.assertEquals((int)page.getPositionCount(), (int)totalRows);
                Assert.assertEquals((int)page.getChannelCount(), (int)totalColumns);
                for (int j = 0; j < totalColumns; ++j) {
                    Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, page.getBlock(j)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
                }
            } else {
                org.testng.Assert.assertNull((Object)page);
            }
            driverContext.getYieldSignal().reset();
        }
    }

    @Test
    public void testRecordCursorYield() {
        int length = 15;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), length, 0);
        DriverContext driverContext = this.newDriverContext();
        Metadata metadata = this.functionAssertions.getMetadata();
        FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
        functionAndTypeManager.registerBuiltInFunctions((List)ImmutableList.of((Object)((Object)new GenericLongFunction("record_cursor", value -> {
            driverContext.getYieldSignal().forceYieldForTesting();
            return value;
        }))));
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(metadata, new PageFunctionCompiler(metadata, 0));
        ImmutableList projections = ImmutableList.of((Object)Expressions.call((String)"generic_long_record_cursor", (FunctionHandle)functionAndTypeManager.lookupFunction("generic_long_record_cursor", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(driverContext.getSession().getSqlFunctionProperties(), Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)BigintType.BIGINT), input)), cursorProcessor, pageProcessor, TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int i = 0; i < length; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            org.testng.Assert.assertNull((Object)operator.getOutput());
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
        Page output = operator.getOutput();
        driverContext.getYieldSignal().reset();
        org.testng.Assert.assertNotNull((Object)output);
        Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, output.getBlock(0)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
    }

    private static List<Page> toPages(Operator operator) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int nullPages = 0;
        while (!operator.isFinished()) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) {
                org.testng.Assert.assertTrue((nullPages < 1000000 ? 1 : 0) != 0, (String)"Too many null pages; infinite loop?");
                ++nullPages;
                continue;
            }
            outputPages.add((Object)outputPage);
            nullPages = 0;
        }
        return outputPages.build();
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    private static class CountingLazyPageSource
    implements ConnectorPageSource {
        private Iterator<Page> pages;
        private long completedBytes;
        private long completedPositions;

        public CountingLazyPageSource(List<Page> pages) {
            this.pages = Objects.requireNonNull(pages, "pages is null").iterator();
        }

        public void close() {
            this.pages = Iterators.forArray((Object[])new Page[0]);
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public long getSystemMemoryUsage() {
            return 0L;
        }

        public boolean isFinished() {
            return !this.pages.hasNext();
        }

        public Page getNextPage() {
            if (this.isFinished()) {
                return null;
            }
            Page page = this.pages.next();
            int channelCount = page.getChannelCount();
            Block[] blocks = new Block[channelCount];
            for (int i = 0; i < channelCount; ++i) {
                Block block = page.getBlock(i);
                blocks[i] = new LazyBlock(block.getPositionCount(), (LazyBlockLoader)new CountingLazyBlockLoader(block));
            }
            this.completedPositions += (long)page.getPositionCount();
            return new Page(page.getPositionCount(), blocks);
        }

        public long getCompletedBytes() {
            return this.completedBytes;
        }

        public long getCompletedPositions() {
            return this.completedPositions;
        }

        private final class CountingLazyBlockLoader
        implements LazyBlockLoader<LazyBlock> {
            private Block loaderBlock;

            public CountingLazyBlockLoader(Block block) {
                this.loaderBlock = block;
            }

            public final void load(LazyBlock lazyBlock) {
                Preconditions.checkState((this.loaderBlock != null ? 1 : 0) != 0, (Object)"loaderBlock already loaded");
                Block loadedBlock = this.loaderBlock.getLoadedBlock();
                CountingLazyPageSource.this.completedBytes = CountingLazyPageSource.this.completedBytes + loadedBlock.getSizeInBytes();
                this.loaderBlock = null;
                lazyBlock.setBlock(loadedBlock);
            }
        }
    }

    public class SinglePagePageSource
    implements ConnectorPageSource {
        private Page page;

        public SinglePagePageSource(Page page) {
            this.page = page;
        }

        public void close() {
            this.page = null;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getCompletedPositions() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public long getSystemMemoryUsage() {
            return 0L;
        }

        public boolean isFinished() {
            return this.page == null;
        }

        public Page getNextPage() {
            Page page = this.page;
            this.page = null;
            return page;
        }
    }
}

