/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTopNOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testSingleFieldKey() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).pageBreak().row(5L, 0.5).row(4L, 0.41).row(6L, 0.6).pageBreak().build();
        TopNOperator.TopNOperatorFactory operatorFactory = new TopNOperator.TopNOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{6L, 0.6}).row(new Object[]{5L, 0.5}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testMultiFieldKey() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row("a", 1L).row("b", 2L).pageBreak().row("f", 3L).row("a", 4L).pageBreak().row("d", 5L).row("d", 7L).row("e", 6L).build();
        TopNOperator.TopNOperatorFactory operatorFactory = new TopNOperator.TopNOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), 3, (List)ImmutableList.of((Object)0, (Object)1), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.DESC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"f", 3L}).row(new Object[]{"e", 6L}).row(new Object[]{"d", 7L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testReverseOrder() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).pageBreak().row(5L, 0.5).row(4L, 0.41).row(6L, 0.6).pageBreak().build();
        TopNOperator.TopNOperatorFactory operatorFactory = new TopNOperator.TopNOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{-1L, -0.1}).row(new Object[]{1L, 0.1}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLimitZero() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).build();
        TopNOperator.TopNOperatorFactory factory = new TopNOperator.TopNOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), 0, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST));
        try (Operator operator = factory.createOperator(this.driverContext);){
            Assert.assertEquals((boolean)operator.isFinished(), (boolean)true);
            Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
            Assert.assertEquals((Object)operator.getOutput(), null);
        }
    }

    @Test
    public void testExceedMemoryLimit() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).build();
        DriverContext smallDiverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(1.0, DataSize.Unit.BYTE)).addPipelineContext(0, true, true, false).addDriverContext();
        TopNOperator.TopNOperatorFactory operatorFactory = new TopNOperator.TopNOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), 100, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        try (Operator operator = operatorFactory.createOperator(smallDiverContext);){
            operator.addInput(input.get(0));
            org.testng.Assert.fail((String)"must fail because of exceeding local memory limit");
        }
        catch (ExceededMemoryLimitException exceededMemoryLimitException) {
            // empty catch block
        }
    }
}

