/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.testng.annotations.Test;
import sun.misc.Unsafe;

public class TestUncheckedByteArrays {
    private static final int POSITIONS_PER_PAGE = 10000;

    private TestUncheckedByteArrays() {
    }

    @Test
    public static void testSetByte() {
        byte[] source = new byte[10000];
        ThreadLocalRandom.current().nextBytes(source);
        TestUncheckedByteArrays.testSequential(Bytes.asList((byte[])source), Unsafe.ARRAY_BYTE_INDEX_SCALE, UncheckedByteArrays::setByteUnchecked, UncheckedByteArrays::getByteUnchecked);
        TestUncheckedByteArrays.testRandom(Bytes.asList((byte[])source), Unsafe.ARRAY_BYTE_INDEX_SCALE, UncheckedByteArrays::setByteUnchecked, UncheckedByteArrays::getByteUnchecked);
    }

    @Test
    public static void testSetShort() {
        List source = IntStream.range(0, 10000).mapToObj(i -> (short)ThreadLocalRandom.current().nextInt(256)).collect(Collectors.toList());
        TestUncheckedByteArrays.testSequential(source, Unsafe.ARRAY_SHORT_INDEX_SCALE, UncheckedByteArrays::setShortUnchecked, UncheckedByteArrays::getShortUnchecked);
        TestUncheckedByteArrays.testRandom(source, Unsafe.ARRAY_SHORT_INDEX_SCALE, UncheckedByteArrays::setShortUnchecked, UncheckedByteArrays::getShortUnchecked);
    }

    @Test
    public static void testSetInt() {
        List source = IntStream.range(0, 10000).boxed().collect(Collectors.toList());
        TestUncheckedByteArrays.testSequential(source, Unsafe.ARRAY_INT_INDEX_SCALE, UncheckedByteArrays::setIntUnchecked, UncheckedByteArrays::getIntUnchecked);
        TestUncheckedByteArrays.testRandom(source, Unsafe.ARRAY_INT_INDEX_SCALE, UncheckedByteArrays::setIntUnchecked, UncheckedByteArrays::getIntUnchecked);
    }

    @Test
    public static void testSetLong() {
        List source = LongStream.range(0L, 10000L).boxed().collect(Collectors.toList());
        TestUncheckedByteArrays.testSequential(source, Unsafe.ARRAY_LONG_INDEX_SCALE, UncheckedByteArrays::setLongUnchecked, UncheckedByteArrays::getLongUnchecked);
        TestUncheckedByteArrays.testRandom(source, Unsafe.ARRAY_LONG_INDEX_SCALE, UncheckedByteArrays::setLongUnchecked, UncheckedByteArrays::getLongUnchecked);
    }

    private static <T> void testSequential(List<T> source, int elementSize, TriFunction<byte[], Integer, T> writeFunction, BiFunction<byte[], Integer, T> readFunction) {
        byte[] destination = new byte[source.size() * elementSize];
        int index = 0;
        for (T value : source) {
            index = writeFunction.apply(destination, index, (byte[])value);
        }
        Assert.assertEquals((int)index, (int)(10000 * elementSize));
        TestUncheckedByteArrays.assertCopied(source, destination, elementSize, readFunction);
    }

    private static <T> void testRandom(List<T> source, int elementSize, TriFunction<byte[], Integer, T> writeFunction, BiFunction<byte[], Integer, T> readFunction) {
        byte[] destination = new byte[source.size() * elementSize];
        ArrayList<T> expected = new ArrayList<T>();
        List positions = IntStream.range(0, 10000).boxed().collect(Collectors.toList());
        Collections.shuffle(positions);
        int index = 0;
        for (int i = 0; i < 10000; ++i) {
            int position = (Integer)positions.get(i);
            index = writeFunction.apply(destination, index, (byte[])source.get(position));
            expected.add(source.get(position));
        }
        Assert.assertEquals((int)index, (int)(10000 * elementSize));
        TestUncheckedByteArrays.assertCopied(expected, destination, elementSize, readFunction);
    }

    private static <T> void assertCopied(List<T> expected, byte[] actual, int elementSize, BiFunction<byte[], Integer, T> readFunction) {
        for (int index = 0; index < expected.size(); ++index) {
            Assert.assertEquals(readFunction.apply(actual, index * elementSize), expected.get(index));
        }
    }

    @FunctionalInterface
    private static interface TriFunction<T, U, S> {
        public int apply(T var1, U var2, S var3);
    }
}

