/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class TestingOperatorContext {
    public static OperatorContext create(ScheduledExecutorService scheduledExecutor) {
        Executor executor = MoreExecutors.directExecutor();
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)executor, (ScheduledExecutorService)scheduledExecutor, (Session)TestingSession.testSessionBuilder().build());
        MemoryTrackingContext pipelineMemoryContext = new MemoryTrackingContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        PipelineContext pipelineContext = new PipelineContext(1, taskContext, executor, scheduledExecutor, pipelineMemoryContext, false, false, false);
        DriverContext driverContext = new DriverContext(pipelineContext, executor, scheduledExecutor, pipelineMemoryContext, Lifespan.taskWide(), Optional.empty());
        OperatorContext operatorContext = driverContext.addOperatorContext(1, new PlanNodeId("test"), "operator type");
        return operatorContext;
    }

    private TestingOperatorContext() {
    }
}

