/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import java.math.BigDecimal;

public abstract class AbstractTestDecimalSumAggregation
extends AbstractTestAggregationFunction {
    protected abstract DecimalType getDecimalType();

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = this.getDecimalType().createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            this.writeDecimalToBlock(AbstractTestDecimalSumAggregation.getBigDecimalForCounter(i), blockBuilder);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected abstract void writeDecimalToBlock(BigDecimal var1, BlockBuilder var2);

    private static BigDecimal getBigDecimalForCounter(int i) {
        String iAsString = String.valueOf(Math.abs(i));
        return new BigDecimal(String.valueOf(i) + "." + iAsString + iAsString).setScale(2, 1);
    }

    public SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = start; i < start + length; ++i) {
            sum = sum.add(AbstractTestDecimalSumAggregation.getBigDecimalForCounter(i));
        }
        return new SqlDecimal(sum.unscaledValue(), sum.precision(), sum.scale());
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }
}

