/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.Precision;
import org.testng.Assert;

public final class AggregationTestUtils {
    private AggregationTestUtils() {
    }

    public static void assertAggregation(InternalAggregationFunction function, Object expectedValue, Block ... blocks) {
        AggregationTestUtils.assertAggregation(function, expectedValue, new Page(blocks));
    }

    public static void assertAggregation(InternalAggregationFunction function, Object expectedValue, Page page) {
        BiFunction<Object, Object, Boolean> equalAssertion = expectedValue instanceof Double && !expectedValue.equals(Double.NaN) ? (actual, expected) -> Precision.equals((double)((Double)actual), (double)((Double)expected), (double)1.0E-10) : (expectedValue instanceof Float && !expectedValue.equals(Float.valueOf(Float.NaN)) ? (actual, expected) -> Precision.equals((float)((Float)actual).floatValue(), (float)((Float)expected).floatValue(), (float)1.0E-10f) : Objects::equals);
        AggregationTestUtils.assertAggregation(function, equalAssertion, null, page, expectedValue);
    }

    public static void assertAggregation(InternalAggregationFunction function, BiFunction<Object, Object, Boolean> equalAssertion, String testDescription, Page page, Object expectedValue) {
        int positions = page.getPositionCount();
        for (int i = 1; i < page.getChannelCount(); ++i) {
            Assert.assertEquals((int)positions, (int)page.getBlock(i).getPositionCount(), (String)"input blocks provided are not equal in position count");
        }
        if (positions == 0) {
            AggregationTestUtils.assertAggregationInternal(function, equalAssertion, testDescription, expectedValue, new Page[0]);
        } else if (positions == 1) {
            AggregationTestUtils.assertAggregationInternal(function, equalAssertion, testDescription, expectedValue, page);
        } else {
            int split = positions / 2;
            Page page1 = page.getRegion(0, split);
            Page page2 = page.getRegion(split, positions - split);
            AggregationTestUtils.assertAggregationInternal(function, equalAssertion, testDescription, expectedValue, page1, page2);
        }
    }

    public static Block getIntermediateBlock(Accumulator accumulator) {
        BlockBuilder blockBuilder = accumulator.getIntermediateType().createBlockBuilder(null, 1000);
        accumulator.evaluateIntermediate(blockBuilder);
        return blockBuilder.build();
    }

    public static Block getIntermediateBlock(GroupedAccumulator accumulator) {
        BlockBuilder blockBuilder = accumulator.getIntermediateType().createBlockBuilder(null, 1000);
        accumulator.evaluateIntermediate(0, blockBuilder);
        return blockBuilder.build();
    }

    public static Block getFinalBlock(Accumulator accumulator) {
        BlockBuilder blockBuilder = accumulator.getFinalType().createBlockBuilder(null, 1000);
        accumulator.evaluateFinal(blockBuilder);
        return blockBuilder.build();
    }

    public static Block getFinalBlock(GroupedAccumulator accumulator) {
        BlockBuilder blockBuilder = accumulator.getFinalType().createBlockBuilder(null, 1000);
        accumulator.evaluateFinal(0, blockBuilder);
        return blockBuilder.build();
    }

    private static void assertAggregationInternal(InternalAggregationFunction function, BiFunction<Object, Object, Boolean> isEqual, String testDescription, Object expectedValue, Page ... pages) {
        AggregationTestUtils.assertFunctionEquals(isEqual, testDescription, AggregationTestUtils.aggregation(function, pages), expectedValue);
        AggregationTestUtils.assertFunctionEquals(isEqual, testDescription, AggregationTestUtils.partialAggregation(function, pages), expectedValue);
        if (pages.length > 0) {
            AggregationTestUtils.assertFunctionEquals(isEqual, testDescription, AggregationTestUtils.groupedAggregation(isEqual, function, pages), expectedValue);
            AggregationTestUtils.assertFunctionEquals(isEqual, testDescription, AggregationTestUtils.groupedPartialAggregation(isEqual, function, pages), expectedValue);
            AggregationTestUtils.assertFunctionEquals(isEqual, testDescription, AggregationTestUtils.distinctAggregation(function, pages), expectedValue);
        }
    }

    private static void assertFunctionEquals(BiFunction<Object, Object, Boolean> isEqual, String testDescription, Object actualValue, Object expectedValue) {
        if (!isEqual.apply(actualValue, expectedValue).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            if (testDescription != null) {
                sb.append(String.format("Test: %s, ", testDescription));
            }
            sb.append(String.format("Expected: %s, actual: %s", expectedValue, actualValue));
            Assert.fail((String)sb.toString());
        }
    }

    public static Object distinctAggregation(InternalAggregationFunction function, Page ... pages) {
        Optional<Integer> maskChannel = Optional.of(pages[0].getChannelCount());
        Object aggregation = AggregationTestUtils.aggregation(function, AggregationTestUtils.createArgs(function), maskChannel, AggregationTestUtils.maskPages(true, pages));
        Page[] dupedPages = new Page[pages.length * 2];
        System.arraycopy(AggregationTestUtils.maskPages(true, pages), 0, dupedPages, 0, pages.length);
        System.arraycopy(AggregationTestUtils.maskPages(false, pages), 0, dupedPages, pages.length, pages.length);
        Object aggregationWithDupes = AggregationTestUtils.aggregation(function, AggregationTestUtils.createArgs(function), maskChannel, dupedPages);
        Assert.assertEquals((Object)aggregationWithDupes, (Object)aggregation, (String)"Inconsistent results with mask");
        return aggregation;
    }

    private static Page[] maskPages(boolean maskValue, Page ... pages) {
        Page[] maskedPages = new Page[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            Page page = pages[i];
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, page.getPositionCount());
            for (int j = 0; j < page.getPositionCount(); ++j) {
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, maskValue);
            }
            maskedPages[i] = page.appendColumn(blockBuilder.build());
        }
        return maskedPages;
    }

    public static Object aggregation(InternalAggregationFunction function, Block ... blocks) {
        return AggregationTestUtils.aggregation(function, new Page(blocks));
    }

    public static Object aggregation(InternalAggregationFunction function, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.aggregation(function, AggregationTestUtils.createArgs(function), Optional.empty(), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.aggregation(function, AggregationTestUtils.reverseArgs(function), Optional.empty(), AggregationTestUtils.reverseColumns(pages));
            Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with reversed channels");
        }
        aggregationWithOffset = AggregationTestUtils.aggregation(function, AggregationTestUtils.offsetArgs(function, 3), Optional.empty(), AggregationTestUtils.offsetColumns(pages, 3));
        Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with channel offset");
        return aggregation;
    }

    private static Object aggregation(InternalAggregationFunction function, int[] args, Optional<Integer> maskChannel, Page ... pages) {
        Accumulator aggregation = function.bind(Ints.asList((int[])args), maskChannel).createAccumulator(UpdateMemory.NOOP);
        for (Page page : pages) {
            if (page.getPositionCount() <= 0) continue;
            aggregation.addInput(page);
        }
        Block block = AggregationTestUtils.getFinalBlock(aggregation);
        return BlockAssertions.getOnlyValue(aggregation.getFinalType(), block);
    }

    public static Object partialAggregation(InternalAggregationFunction function, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.partialAggregation(function, AggregationTestUtils.createArgs(function), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.partialAggregation(function, AggregationTestUtils.reverseArgs(function), AggregationTestUtils.reverseColumns(pages));
            Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with reversed channels");
        }
        aggregationWithOffset = AggregationTestUtils.partialAggregation(function, AggregationTestUtils.offsetArgs(function, 3), AggregationTestUtils.offsetColumns(pages, 3));
        Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with channel offset");
        return aggregation;
    }

    public static Object partialAggregation(InternalAggregationFunction function, int[] args, Page ... pages) {
        AccumulatorFactory factory = function.bind(Ints.asList((int[])args), Optional.empty());
        Accumulator finalAggregation = factory.createIntermediateAccumulator();
        Accumulator emptyAggregation = factory.createAccumulator(UpdateMemory.NOOP);
        Block emptyBlock = AggregationTestUtils.getIntermediateBlock(emptyAggregation);
        finalAggregation.addIntermediate(emptyBlock);
        for (Page page : pages) {
            Accumulator partialAggregation = factory.createAccumulator(UpdateMemory.NOOP);
            if (page.getPositionCount() > 0) {
                partialAggregation.addInput(page);
            }
            Block partialBlock = AggregationTestUtils.getIntermediateBlock(partialAggregation);
            finalAggregation.addIntermediate(partialBlock);
        }
        finalAggregation.addIntermediate(emptyBlock);
        Block finalBlock = AggregationTestUtils.getFinalBlock(finalAggregation);
        return BlockAssertions.getOnlyValue(finalAggregation.getFinalType(), finalBlock);
    }

    public static Object groupedAggregation(InternalAggregationFunction function, Page ... pages) {
        return AggregationTestUtils.groupedAggregation(Objects::equals, function, pages);
    }

    public static Object groupedAggregation(BiFunction<Object, Object, Boolean> isEqual, InternalAggregationFunction function, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.groupedAggregation(function, AggregationTestUtils.createArgs(function), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.groupedAggregation(function, AggregationTestUtils.reverseArgs(function), AggregationTestUtils.reverseColumns(pages));
            AggregationTestUtils.assertFunctionEquals(isEqual, "Inconsistent results with reversed channels", aggregationWithOffset, aggregation);
        }
        aggregationWithOffset = AggregationTestUtils.groupedAggregation(function, AggregationTestUtils.offsetArgs(function, 3), AggregationTestUtils.offsetColumns(pages, 3));
        AggregationTestUtils.assertFunctionEquals(isEqual, "Consistent results with channel offset", aggregationWithOffset, aggregation);
        return aggregation;
    }

    public static Object groupedAggregation(InternalAggregationFunction function, int[] args, Page ... pages) {
        GroupedAccumulator groupedAggregation = function.bind(Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
        for (Page page : pages) {
            groupedAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(0, page.getPositionCount()), page);
        }
        Object groupValue = AggregationTestUtils.getGroupValue(groupedAggregation, 0);
        for (Page page : pages) {
            groupedAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(4000, page.getPositionCount()), page);
        }
        Object largeGroupValue = AggregationTestUtils.getGroupValue(groupedAggregation, 4000);
        Assert.assertEquals((Object)largeGroupValue, (Object)groupValue, (String)"Inconsistent results with large group id");
        return groupValue;
    }

    public static Object groupedPartialAggregation(BiFunction<Object, Object, Boolean> isEqual, InternalAggregationFunction function, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.groupedPartialAggregation(function, AggregationTestUtils.createArgs(function), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.groupedPartialAggregation(function, AggregationTestUtils.reverseArgs(function), AggregationTestUtils.reverseColumns(pages));
            AggregationTestUtils.assertFunctionEquals(isEqual, "Consistent results with reversed channels", aggregationWithOffset, aggregation);
        }
        aggregationWithOffset = AggregationTestUtils.groupedPartialAggregation(function, AggregationTestUtils.offsetArgs(function, 3), AggregationTestUtils.offsetColumns(pages, 3));
        AggregationTestUtils.assertFunctionEquals(isEqual, "Consistent results with channel offset", aggregationWithOffset, aggregation);
        return aggregation;
    }

    public static Object groupedPartialAggregation(InternalAggregationFunction function, int[] args, Page ... pages) {
        AccumulatorFactory factory = function.bind(Ints.asList((int[])args), Optional.empty());
        GroupedAccumulator finalAggregation = factory.createGroupedIntermediateAccumulator(UpdateMemory.NOOP);
        GroupedAccumulator emptyAggregation = factory.createGroupedAccumulator(UpdateMemory.NOOP);
        Block emptyBlock = AggregationTestUtils.getIntermediateBlock(emptyAggregation);
        finalAggregation.addIntermediate(AggregationTestUtils.createGroupByIdBlock(0, emptyBlock.getPositionCount()), emptyBlock);
        for (Page page : pages) {
            GroupedAccumulator partialAggregation = factory.createGroupedAccumulator(UpdateMemory.NOOP);
            partialAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(0, page.getPositionCount()), page);
            Block partialBlock = AggregationTestUtils.getIntermediateBlock(partialAggregation);
            finalAggregation.addIntermediate(AggregationTestUtils.createGroupByIdBlock(0, partialBlock.getPositionCount()), partialBlock);
        }
        finalAggregation.addIntermediate(AggregationTestUtils.createGroupByIdBlock(0, emptyBlock.getPositionCount()), emptyBlock);
        return AggregationTestUtils.getGroupValue(finalAggregation, 0);
    }

    public static GroupByIdBlock createGroupByIdBlock(int groupId, int positions) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, positions);
        for (int i = 0; i < positions; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        return new GroupByIdBlock((long)groupId, blockBuilder.build());
    }

    private static int[] createArgs(InternalAggregationFunction function) {
        int[] args = new int[function.getParameterTypes().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = i;
        }
        return args;
    }

    public static int[] reverseArgs(InternalAggregationFunction function) {
        int[] args = AggregationTestUtils.createArgs(function);
        Collections.reverse(Ints.asList((int[])args));
        return args;
    }

    public static int[] offsetArgs(InternalAggregationFunction function, int offset) {
        int[] args = AggregationTestUtils.createArgs(function);
        int i = 0;
        while (i < args.length) {
            int n = i++;
            args[n] = args[n] + offset;
        }
        return args;
    }

    public static Page[] reverseColumns(Page[] pages) {
        Page[] newPages = new Page[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            Page page = pages[i];
            if (page.getPositionCount() == 0) {
                newPages[i] = page;
                continue;
            }
            Block[] newBlocks = new Block[page.getChannelCount()];
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                newBlocks[channel] = page.getBlock(page.getChannelCount() - channel - 1);
            }
            newPages[i] = new Page(page.getPositionCount(), newBlocks);
        }
        return newPages;
    }

    public static Page[] offsetColumns(Page[] pages, int offset) {
        Page[] newPages = new Page[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            int channel;
            Page page = pages[i];
            Block[] newBlocks = new Block[page.getChannelCount() + offset];
            for (channel = 0; channel < offset; ++channel) {
                newBlocks[channel] = AggregationTestUtils.createNullRLEBlock(page.getPositionCount());
            }
            for (channel = 0; channel < page.getChannelCount(); ++channel) {
                newBlocks[channel + offset] = page.getBlock(channel);
            }
            newPages[i] = new Page(page.getPositionCount(), newBlocks);
        }
        return newPages;
    }

    private static RunLengthEncodedBlock createNullRLEBlock(int positionCount) {
        return (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Type)BooleanType.BOOLEAN, null, (int)positionCount);
    }

    public static Object getGroupValue(GroupedAccumulator groupedAggregation, int groupId) {
        BlockBuilder out = groupedAggregation.getFinalType().createBlockBuilder(null, 1);
        groupedAggregation.evaluateFinal(groupId, out);
        return BlockAssertions.getOnlyValue(groupedAggregation.getFinalType(), out.build());
    }

    public static double[] constructDoublePrimitiveArray(int start, int length) {
        return IntStream.range(start, start + length).asDoubleStream().toArray();
    }
}

