/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayAggregation {
    private static final int ARRAY_SIZE = 10000000;

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public void arrayAggregation(BenchmarkData data) {
        data.getAccumulator().addInput(data.getPage());
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayAggregation().arrayAggregation(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.BULK).include(".*" + BenchmarkArrayAggregation.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private String name = "array_agg";
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String type = "BIGINT";
        private Page page;
        private Accumulator accumulator;

        @Setup(value=Level.Invocation)
        public void setup() {
            BigintType elementType;
            FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    break;
                }
                case "BOOLEAN": {
                    elementType = BooleanType.BOOLEAN;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            InternalAggregationFunction function = functionAndTypeManager.getAggregateFunctionImplementation(functionAndTypeManager.lookupFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{elementType})));
            this.accumulator = function.bind((List)ImmutableList.of((Object)0), Optional.empty()).createAccumulator(UpdateMemory.NOOP);
            Block block = BenchmarkData.createChannel(10000000, (Type)elementType);
            this.page = new Page(new Block[]{block});
        }

        private static Block createChannel(int arraySize, Type elementType) {
            BlockBuilder blockBuilder = elementType.createBlockBuilder(null, arraySize);
            for (int i = 0; i < arraySize; ++i) {
                if (elementType.getJavaType() == Long.TYPE) {
                    elementType.writeLong(blockBuilder, (long)i);
                    continue;
                }
                if (elementType.getJavaType() == Double.TYPE) {
                    elementType.writeDouble(blockBuilder, ThreadLocalRandom.current().nextDouble());
                    continue;
                }
                if (elementType.getJavaType() == Boolean.TYPE) {
                    elementType.writeBoolean(blockBuilder, ThreadLocalRandom.current().nextBoolean());
                    continue;
                }
                if (elementType.equals(VarcharType.VARCHAR)) {
                    elementType.writeSlice(blockBuilder, Slices.utf8Slice((String)Long.toString(ThreadLocalRandom.current().nextLong() % 100L)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return blockBuilder.build();
        }

        public Accumulator getAccumulator() {
            return this.accumulator;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

