/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestInput;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestInputBuilder;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestOutput;
import com.facebook.presto.operator.aggregation.groupByAggregations.GroupByAggregationTestUtils;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.internal.collections.Ints;

public class TestArrayAggregation {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testEmpty() {
        InternalAggregationFunction bigIntAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(bigIntAgg, null, BlockAssertions.createLongsBlock(new Long[0]));
    }

    @Test
    public void testNullOnly() {
        InternalAggregationFunction bigIntAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(bigIntAgg, Arrays.asList(null, null, null), BlockAssertions.createLongsBlock(null, null, null));
    }

    @Test
    public void testNullPartial() {
        InternalAggregationFunction bigIntAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(bigIntAgg, Arrays.asList(null, 2L, null, 3L, null), BlockAssertions.createLongsBlock(null, 2L, null, 3L, null));
    }

    @Test
    public void testBoolean() {
        InternalAggregationFunction booleanAgg = this.getAggregation(new Type[]{BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(booleanAgg, Arrays.asList(true, false), BlockAssertions.createBooleansBlock(true, false));
    }

    @Test
    public void testBigInt() {
        InternalAggregationFunction bigIntAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(bigIntAgg, Arrays.asList(2L, 1L, 2L), BlockAssertions.createLongsBlock(2L, 1L, 2L));
    }

    @Test
    public void testVarchar() {
        InternalAggregationFunction varcharAgg = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(varcharAgg, Arrays.asList("hello", "world"), BlockAssertions.createStringsBlock("hello", "world"));
    }

    @Test
    public void testDate() {
        InternalAggregationFunction varcharAgg = this.getAggregation(new Type[]{DateType.DATE});
        AggregationTestUtils.assertAggregation(varcharAgg, Arrays.asList(new SqlDate(1), new SqlDate(2), new SqlDate(4)), BlockAssertions.createTypedLongsBlock((Type)DateType.DATE, (Iterable<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)4L)));
    }

    @Test
    public void testArray() {
        InternalAggregationFunction varcharAgg = this.getAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(varcharAgg, Arrays.asList(Arrays.asList(1L), Arrays.asList(1L, 2L), Arrays.asList(1L, 2L, 3L)), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
    }

    @Test
    public void testEmptyStateOutputsNull() {
        InternalAggregationFunction bigIntAgg = this.getAggregation(new Type[]{BigintType.BIGINT});
        GroupedAccumulator groupedAccumulator = bigIntAgg.bind(Ints.asList((int[])new int[0]), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
        BlockBuilder blockBuilder = groupedAccumulator.getFinalType().createBlockBuilder(null, 1000);
        groupedAccumulator.evaluateFinal(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.isNull(0));
    }

    @Test
    public void testWithMultiplePages() {
        InternalAggregationFunction varcharAgg = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{BlockAssertions.createStringsBlock("hello", "world", "hello2", "world2", "hello3", "world3", "goodbye")}, varcharAgg);
        AggregationTestOutput testOutput = new AggregationTestOutput(ImmutableList.of((Object)"hello", (Object)"world", (Object)"hello2", (Object)"world2", (Object)"hello3", (Object)"world3", (Object)"goodbye"));
        AggregationTestInput testInput = testInputBuilder.build();
        testInput.runPagesOnAccumulatorWithAssertion(0L, testInput.createGroupedAccumulator(), testOutput);
    }

    @Test
    public void testMultipleGroupsWithMultiplePages() {
        InternalAggregationFunction varcharAgg = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c", "d", "e");
        Block block2 = BlockAssertions.createStringsBlock("f", "g", "h", "i", "j");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"));
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, varcharAgg);
        AggregationTestInput test1 = testInputBuilder1.build();
        GroupedAccumulator groupedAccumulator = test1.createGroupedAccumulator();
        test1.runPagesOnAccumulatorWithAssertion(0L, groupedAccumulator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableList.of((Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j"));
        AggregationTestInputBuilder testBuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, varcharAgg);
        AggregationTestInput test2 = testBuilder2.build();
        test2.runPagesOnAccumulatorWithAssertion(255L, groupedAccumulator, aggregationTestOutput2);
    }

    @Test
    public void testManyValues() {
        InternalAggregationFunction varcharAgg = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        int numGroups = 50000;
        int arraySize = 30;
        Random random = new Random();
        GroupedAccumulator groupedAccumulator = this.createGroupedAccumulator(varcharAgg);
        for (int j = 0; j < numGroups; ++j) {
            ArrayList<String> expectedValues = new ArrayList<String>();
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < arraySize; ++i) {
                String str = String.valueOf(random.nextInt());
                valueList.add(str);
                expectedValues.add(str);
            }
            Block block = BlockAssertions.createStringsBlock(valueList);
            AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{block}, varcharAgg);
            AggregationTestInput test1 = testInputBuilder.build();
            test1.runPagesOnAccumulatorWithAssertion(j, groupedAccumulator, new AggregationTestOutput(expectedValues));
        }
    }

    private GroupedAccumulator createGroupedAccumulator(InternalAggregationFunction function) {
        int[] args = GroupByAggregationTestUtils.createArgs(function);
        return function.bind(Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
    }

    private InternalAggregationFunction getAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("array_agg", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

