/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.testng.annotations.Test;

public class TestDoubleCorrelationAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 2, start + 2 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "corr";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double", (Object)"double");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        PearsonsCorrelation corr = new PearsonsCorrelation();
        return corr.correlation(AggregationTestUtils.constructDoublePrimitiveArray(start + 2, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length));
    }

    @Test
    public void testDivisionByZero() {
        this.testAggregation(null, BlockAssertions.createDoublesBlock(2.0, 2.0, 2.0, 2.0, 2.0), BlockAssertions.createDoublesBlock(1.0, 4.0, 9.0, 16.0, 25.0));
        this.testAggregation(null, BlockAssertions.createDoublesBlock(1.0, 4.0, 9.0, 16.0, 25.0), BlockAssertions.createDoublesBlock(2.0, 2.0, 2.0, 2.0, 2.0));
    }

    @Test
    public void testNonTrivialResult() {
        this.testNonTrivialAggregation(new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new double[]{1.0, 4.0, 9.0, 16.0, 25.0});
    }

    @Test
    public void testInverseCorrelation() {
        this.testNonTrivialAggregation(new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
    }

    private void testNonTrivialAggregation(double[] y, double[] x) {
        PearsonsCorrelation corr = new PearsonsCorrelation();
        double expected = corr.correlation(x, y);
        Preconditions.checkArgument((Double.isFinite(expected) && expected != 0.0 && expected != 1.0 ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(expected, BlockAssertions.createDoublesBlock(this.box(y)), BlockAssertions.createDoublesBlock(this.box(x)));
    }

    private Double[] box(double[] values) {
        return (Double[])DoubleStream.of(values).boxed().toArray(Double[]::new);
    }
}

