/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestInput;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestInputBuilder;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestOutput;
import com.facebook.presto.operator.aggregation.groupByAggregations.GroupByAggregationTestUtils;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.internal.collections.Ints;

public class TestHistogram {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"UTC");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);

    @Test
    public void testSimpleHistograms() {
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L), BlockAssertions.createStringsBlock("a", "b", "c"));
        aggregationFunction = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)100L, (Object)1L, (Object)200L, (Object)1L, (Object)300L, (Object)1L), BlockAssertions.createLongsBlock(100L, 200L, 300L));
        aggregationFunction = this.getAggregation(new Type[]{DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)0.1, (Object)1L, (Object)0.3, (Object)1L, (Object)0.2, (Object)1L), BlockAssertions.createDoublesBlock(0.1, 0.3, 0.2));
        aggregationFunction = this.getAggregation(new Type[]{BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)true, (Object)1L, (Object)false, (Object)1L), BlockAssertions.createBooleansBlock(true, false));
    }

    @Test
    public void testSharedGroupBy() {
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L), BlockAssertions.createStringsBlock("a", "b", "c"));
        aggregationFunction = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)100L, (Object)1L, (Object)200L, (Object)1L, (Object)300L, (Object)1L), BlockAssertions.createLongsBlock(100L, 200L, 300L));
        aggregationFunction = this.getAggregation(new Type[]{DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)0.1, (Object)1L, (Object)0.3, (Object)1L, (Object)0.2, (Object)1L), BlockAssertions.createDoublesBlock(0.1, 0.3, 0.2));
        aggregationFunction = this.getAggregation(new Type[]{BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)true, (Object)1L, (Object)false, (Object)1L), BlockAssertions.createBooleansBlock(true, false));
    }

    @Test
    public void testDuplicateKeysValues() {
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)2L, (Object)"b", (Object)1L), BlockAssertions.createStringsBlock("a", "b", "a"));
        aggregationFunction = this.getAggregation(new Type[]{TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE});
        long timestampWithTimeZone1 = DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), (TimeZoneKey)TIME_ZONE_KEY);
        long timestampWithTimeZone2 = DateTimeEncoding.packDateTimeWithZone((long)new DateTime(2015, 1, 1, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), (TimeZoneKey)TIME_ZONE_KEY);
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)new SqlTimestampWithTimeZone(timestampWithTimeZone1), (Object)2L, (Object)new SqlTimestampWithTimeZone(timestampWithTimeZone2), (Object)1L), BlockAssertions.createLongsBlock(timestampWithTimeZone1, timestampWithTimeZone1, timestampWithTimeZone2));
    }

    @Test
    public void testWithNulls() {
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)1L, (Object)1L, (Object)2L, (Object)1L), BlockAssertions.createLongsBlock(2L, null, 1L));
        AggregationTestUtils.assertAggregation(aggregationFunction, null, BlockAssertions.createLongsBlock(new Long[]{null}));
    }

    @Test
    public void testArrayHistograms() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{arrayType});
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)1L, (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"), (Object)1L, (Object)ImmutableList.of((Object)"c", (Object)"b", (Object)"a"), (Object)1L), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"), (Object)ImmutableList.of((Object)"c", (Object)"b", (Object)"a"))));
    }

    @Test
    public void testMapHistograms() {
        MapType innerMapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{innerMapType});
        BlockBuilder builder = innerMapType.createBlockBuilder(null, 3);
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"a", (Object)"b")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"c", (Object)"d")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)1L, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)1L, (Object)ImmutableMap.of((Object)"e", (Object)"f"), (Object)1L), builder.build());
    }

    @Test
    public void testRowHistograms() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        InternalAggregationFunction aggregationFunction = this.getAggregation(new Type[]{innerRowType});
        BlockBuilder builder = innerRowType.createBlockBuilder(null, 3);
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 1L, 1.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2L, 2.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 3L, 3.0));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)1L, (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)1L, (Object)ImmutableList.of((Object)3L, (Object)3.0), (Object)1L), builder.build());
    }

    @Test
    public void testLargerHistograms() {
        InternalAggregationFunction aggregationFunction = this.getInternalDefaultVarCharAggregationn();
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)25L, (Object)"b", (Object)10L, (Object)"c", (Object)12L, (Object)"d", (Object)1L, (Object)"e", (Object)2L), BlockAssertions.createStringsBlock("a", "b", "c", "d", "e", "e", "c", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "c", "c", "b", "a", "c", "c", "b", "a", "c", "c", "b", "a", "c", "c", "b", "a", "c", "c"));
    }

    @Test
    public void testEmptyHistogramOutputsNull() {
        InternalAggregationFunction function = this.getInternalDefaultVarCharAggregationn();
        GroupedAccumulator groupedAccumulator = function.bind(Ints.asList((int[])new int[0]), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
        BlockBuilder blockBuilder = groupedAccumulator.getFinalType().createBlockBuilder(null, 1000);
        groupedAccumulator.evaluateFinal(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.isNull(0));
    }

    @Test
    public void testSharedGroupByWithOverlappingValuesRunner() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testSharedGroupByWithOverlappingValuesRunner(classicFunction);
        this.testSharedGroupByWithOverlappingValuesRunner(singleInstanceFunction);
    }

    @Test
    public void testSharedGroupByWithDistinctValuesPerGroup() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testSharedGroupByWithDistinctValuesPerGroupRunner(classicFunction);
        this.testSharedGroupByWithDistinctValuesPerGroupRunner(singleInstanceFunction);
    }

    @Test
    public void testSharedGroupByWithOverlappingValuesPerGroup() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testSharedGroupByWithOverlappingValuesPerGroupRunner(classicFunction);
        this.testSharedGroupByWithOverlappingValuesPerGroupRunner(singleInstanceFunction);
    }

    @Test
    public void testSharedGroupByWithManyGroups() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testManyValuesInducingRehash(classicFunction);
        this.testManyValuesInducingRehash(singleInstanceFunction);
    }

    private void testManyValuesInducingRehash(InternalAggregationFunction aggregationFunction) {
        double distinctFraction = 0.1f;
        int numGroups = 50000;
        int itemCount = 30;
        Random random = new Random();
        GroupedAccumulator groupedAccumulator = this.createGroupedAccumulator(aggregationFunction);
        for (int j = 0; j < numGroups; ++j) {
            HashMap<String, Long> expectedValues = new HashMap<String, Long>();
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < itemCount; ++i) {
                boolean distinctValue;
                String str = String.valueOf(i % 10);
                String item = IntStream.range(0, itemCount).mapToObj(x -> str).collect(Collectors.joining());
                boolean bl = distinctValue = random.nextDouble() < distinctFraction;
                if (distinctValue) {
                    item = j + "-" + item;
                    valueList.add(item);
                } else {
                    valueList.add(item);
                }
                expectedValues.compute(item, (k, v) -> {
                    long l;
                    if (v == null) {
                        l = 1L;
                    } else {
                        v = v + 1L;
                        l = v;
                    }
                    return l;
                });
            }
            Block block = BlockAssertions.createStringsBlock(valueList);
            AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{block}, aggregationFunction);
            AggregationTestInput test1 = testInputBuilder.build();
            test1.runPagesOnAccumulatorWithAssertion(j, groupedAccumulator, new AggregationTestOutput(expectedValues));
        }
    }

    private GroupedAccumulator createGroupedAccumulator(InternalAggregationFunction function) {
        int[] args = GroupByAggregationTestUtils.createArgs(function);
        return function.bind(Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
    }

    private void testSharedGroupByWithOverlappingValuesPerGroupRunner(InternalAggregationFunction aggregationFunction) {
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c");
        Block block2 = BlockAssertions.createStringsBlock("b", "c", "d");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L));
        AggregationTestInputBuilder testBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, aggregationFunction);
        AggregationTestInput test1 = testBuilder1.build();
        GroupedAccumulator groupedAccumulator = test1.createGroupedAccumulator();
        test1.runPagesOnAccumulatorWithAssertion(0L, groupedAccumulator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableMap.of((Object)"b", (Object)1L, (Object)"c", (Object)1L, (Object)"d", (Object)1L));
        AggregationTestInputBuilder testbuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, aggregationFunction);
        AggregationTestInput test2 = testbuilder2.build();
        test2.runPagesOnAccumulatorWithAssertion(255L, groupedAccumulator, aggregationTestOutput2);
    }

    private void testSharedGroupByWithDistinctValuesPerGroupRunner(InternalAggregationFunction aggregationFunction) {
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c");
        Block block2 = BlockAssertions.createStringsBlock("d", "e", "f");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L));
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, aggregationFunction);
        AggregationTestInput test1 = testInputBuilder1.build();
        GroupedAccumulator groupedAccumulator = test1.createGroupedAccumulator();
        test1.runPagesOnAccumulatorWithAssertion(0L, groupedAccumulator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableMap.of((Object)"d", (Object)1L, (Object)"e", (Object)1L, (Object)"f", (Object)1L));
        AggregationTestInputBuilder testBuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, aggregationFunction);
        AggregationTestInput test2 = testBuilder2.build();
        test2.runPagesOnAccumulatorWithAssertion(255L, groupedAccumulator, aggregationTestOutput2);
    }

    private void testSharedGroupByWithOverlappingValuesRunner(InternalAggregationFunction aggregationFunction) {
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c", "d", "a1", "b2", "c3", "d4", "a", "b2", "c", "d4", "a3", "b3", "c3", "b2");
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, aggregationFunction);
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableMap.builder().put((Object)"a", (Object)2L).put((Object)"b", (Object)1L).put((Object)"c", (Object)2L).put((Object)"d", (Object)1L).put((Object)"a1", (Object)1L).put((Object)"b2", (Object)3L).put((Object)"c3", (Object)2L).put((Object)"d4", (Object)2L).put((Object)"a3", (Object)1L).put((Object)"b3", (Object)1L).build());
        AggregationTestInput test1 = testInputBuilder1.build();
        test1.runPagesOnAccumulatorWithAssertion(0L, test1.createGroupedAccumulator(), aggregationTestOutput1);
    }

    private InternalAggregationFunction getInternalDefaultVarCharAggregationn() {
        return this.getAggregation(new Type[]{VarcharType.VARCHAR});
    }

    private InternalAggregationFunction getAggregation(Type ... arguments) {
        FunctionAndTypeManager functionAndTypeManager = this.getFunctionManager(HistogramGroupImplementation.NEW);
        return functionAndTypeManager.getAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("histogram", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }

    public FunctionAndTypeManager getFunctionManager() {
        return this.getFunctionManager(HistogramGroupImplementation.NEW);
    }

    public FunctionAndTypeManager getFunctionManager(HistogramGroupImplementation groupMode) {
        return MetadataManager.createTestMetadataManager((FeaturesConfig)new FeaturesConfig().setHistogramGroupImplementation(groupMode)).getFunctionAndTypeManager();
    }
}

