/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.HyperLogLogUtils;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHyperLogLogUtils {
    @Test
    public void testStandardErrorToBuckets() {
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0326), (int)1024);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0325), (int)1024);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0324), (int)2048);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0231), (int)2048);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.023), (int)2048);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0229), (int)4096);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0164), (int)4096);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0163), (int)4096);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0162), (int)8192);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0116), (int)8192);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0115), (int)8192);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0114), (int)16384);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.008126), (int)16384);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.008125), (int)16384);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.008124), (int)32768);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.00576), (int)32768);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.00575), (int)32768);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.00574), (int)65536);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0040626), (int)65536);
        Assert.assertEquals((int)HyperLogLogUtils.standardErrorToBuckets((double)0.0040625), (int)65536);
    }

    @Test
    public void testStandardErrorToBucketsBounds() {
        try {
            HyperLogLogUtils.standardErrorToBuckets((double)0.0040624);
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
        }
        try {
            HyperLogLogUtils.standardErrorToBuckets((double)0.26001);
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
        }
    }
}

