/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;

public class TestLongDecimalMinAggregation
extends AbstractTestAggregationFunction {
    public static final DecimalType LONG_DECIMAL = DecimalType.createDecimalType((int)30, (int)5);

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = LONG_DECIMAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL, (BlockBuilder)blockBuilder, (BigDecimal)BigDecimal.valueOf(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return SqlDecimal.of((long)start, (int)30, (int)5);
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)LONG_DECIMAL.getTypeSignature().toString());
    }
}

