/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.QuantileDigestParametricType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.operator.aggregation.TestMergeStatisticalDigestFunction;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class TestMergeQuantileDigestFunction
extends TestMergeStatisticalDigestFunction {
    public static final BiFunction<Object, Object, Boolean> QDIGEST_EQUALITY = (actualBinary, expectedBinary) -> {
        if (actualBinary == null && expectedBinary == null) {
            return true;
        }
        Objects.requireNonNull(actualBinary, "actual value was null");
        Objects.requireNonNull(expectedBinary, "expected value was null");
        QuantileDigest actual = new QuantileDigest(Slices.wrappedBuffer((byte[])((SqlVarbinary)actualBinary).getBytes()));
        QuantileDigest expected = new QuantileDigest(Slices.wrappedBuffer((byte[])((SqlVarbinary)expectedBinary).getBytes()));
        return actual.getCount() == expected.getCount() && actual.getMin() == expected.getMin() && actual.getMax() == expected.getMax() && actual.getAlpha() == expected.getAlpha() && actual.getMaxError() == expected.getMaxError();
    };

    @Override
    protected BiFunction<Object, Object, Boolean> getEquality() {
        return QDIGEST_EQUALITY;
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        Type type = QuantileDigestParametricType.QDIGEST.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)DoubleType.DOUBLE)));
        BlockBuilder blockBuilder = type.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            QuantileDigest qdigest = new QuantileDigest(0.0);
            qdigest.add((long)i);
            type.writeSlice(blockBuilder, qdigest.serialize());
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"qdigest(double)");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        QuantileDigest qdigest = new QuantileDigest(0.0);
        for (int i = start; i < start + length; ++i) {
            qdigest.add((long)i);
        }
        return new SqlVarbinary(qdigest.serialize().getBytes());
    }
}

