/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.testing.TestingSession;
import java.util.List;
import java.util.function.BiFunction;
import org.testng.annotations.Test;

public abstract class TestMergeStatisticalDigestFunction
extends AbstractTestAggregationFunction {
    protected TestMergeStatisticalDigestFunction() {
        super(TestingSession.testSessionBuilder().setSystemProperty("tdigest_enabled", "true").build());
    }

    protected abstract BiFunction<Object, Object, Boolean> getEquality();

    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected abstract List<String> getFunctionParameterTypes();

    @Override
    public abstract Object getExpectedValue(int var1, int var2);

    @Override
    @Test
    public void testMultiplePositions() {
        AggregationTestUtils.assertAggregation(this.getFunction(), this.getEquality(), "test multiple positions", new Page(this.getSequenceBlocks(0, 5)), this.getExpectedValue(0, 5));
    }

    @Override
    @Test
    public void testMixedNullAndNonNullPositions() {
        AggregationTestUtils.assertAggregation(this.getFunction(), this.getEquality(), "test mixed null and nonnull position", new Page(this.createAlternatingNullsBlock(this.getFunction().getParameterTypes(), this.getSequenceBlocks(0, 10))), this.getExpectedValueIncludingNulls(0, 10, 20));
    }
}

