/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.RowPageBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestInput;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestInputBuilder;
import com.facebook.presto.operator.aggregation.groupByAggregations.AggregationTestOutput;
import com.facebook.presto.operator.aggregation.groupByAggregations.GroupByAggregationTestUtils;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMultimapAggAggregation {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testSingleValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L));
    }

    @Test
    public void testMultiValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)2.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    @Test
    public void testOrderValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)1L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)3L, (Object)2L, (Object)1L));
    }

    @Test
    public void testDuplicateValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b", (Object)"c"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L, (Object)1L, (Object)1L));
    }

    @Test
    public void testNullMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of(), (Type)VarcharType.VARCHAR, ImmutableList.of());
    }

    @Test
    public void testDoubleMapMultimap() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)1L), (Object)ImmutableMap.of((Object)"b", (Object)2L, (Object)"c", (Object)3L, (Object)"d", (Object)4L), (Object)ImmutableMap.of((Object)"a", (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)mapType, expectedValues);
    }

    @Test
    public void testDoubleArrayMultimap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)arrayType, expectedValues);
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Type)innerRowType, ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)ImmutableList.of((Object)3L, (Object)3.0)));
    }

    @Test
    public void testMultiplePages() {
        InternalAggregationFunction aggFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = this.getGroupedAccumulator(aggFunction);
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, 0, (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)3L));
    }

    @Test
    public void testMultiplePagesAndGroups() {
        InternalAggregationFunction aggFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = this.getGroupedAccumulator(aggFunction);
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, 0, (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, 300, (Type)BigintType.BIGINT, ImmutableList.of((Object)7L, (Object)7L), (Type)BigintType.BIGINT, ImmutableList.of((Object)8L, (Object)9L));
    }

    @Test
    public void testManyValues() {
        InternalAggregationFunction aggFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = this.getGroupedAccumulator(aggFunction);
        int numGroups = 30000;
        int numKeys = 10;
        int numValueArraySize = 2;
        Random random = new Random();
        for (int group = 0; group < numGroups; ++group) {
            ImmutableList.Builder keyBuilder = ImmutableList.builder();
            ImmutableList.Builder valueBuilder = ImmutableList.builder();
            for (int i = 0; i < numKeys; ++i) {
                long key = random.nextLong();
                for (int j = 0; j < numValueArraySize; ++j) {
                    long value = random.nextLong();
                    keyBuilder.add((Object)key);
                    valueBuilder.add((Object)value);
                }
            }
            TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, group, (Type)BigintType.BIGINT, keyBuilder.build(), (Type)BigintType.BIGINT, valueBuilder.build());
        }
    }

    @Test
    public void testEmptyStateOutputIsNull() {
        InternalAggregationFunction aggregationFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = aggregationFunction.bind(Ints.asList((int[])new int[0]), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
        BlockBuilder blockBuilder = groupedAccumulator.getFinalType().createBlockBuilder(null, 1);
        groupedAccumulator.evaluateFinal(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.isNull(0));
    }

    private static <K, V> void testMultimapAgg(Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        Preconditions.checkState((expectedKeys.size() == expectedValues.size() ? 1 : 0) != 0, (Object)"expectedKeys and expectedValues should have equal size");
        InternalAggregationFunction aggFunc = TestMultimapAggAggregation.getInternalAggregationFunction(keyType, valueType);
        TestMultimapAggAggregation.testMultimapAgg(aggFunc, keyType, expectedKeys, valueType, expectedValues);
    }

    private static InternalAggregationFunction getInternalAggregationFunction(Type keyType, Type valueType) {
        return FUNCTION_AND_TYPE_MANAGER.getAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("multimap_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType, valueType})));
    }

    private static <K, V> void testMultimapAgg(InternalAggregationFunction aggFunc, Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        HashMap map = new HashMap();
        for (int i = 0; i < expectedKeys.size(); ++i) {
            if (!map.containsKey(expectedKeys.get(i))) {
                map.put(expectedKeys.get(i), new ArrayList());
            }
            ((List)map.get(expectedKeys.get(i))).add(expectedValues.get(i));
        }
        RowPageBuilder builder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        for (int i = 0; i < expectedKeys.size(); ++i) {
            builder.row(expectedKeys.get(i), expectedValues.get(i));
        }
        AggregationTestUtils.assertAggregation(aggFunc, map.isEmpty() ? null : map, builder.build());
    }

    private static <K, V> void testMultimapAggWithGroupBy(InternalAggregationFunction aggregationFunction, GroupedAccumulator groupedAccumulator, int groupId, Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        RowPageBuilder pageBuilder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        ImmutableMultimap.Builder outputBuilder = ImmutableMultimap.builder();
        for (int i = 0; i < expectedValues.size(); ++i) {
            pageBuilder.row(expectedKeys.get(i), expectedValues.get(i));
            outputBuilder.put(expectedKeys.get(i), expectedValues.get(i));
        }
        Page page = pageBuilder.build();
        AggregationTestInput input = new AggregationTestInputBuilder(new Block[]{page.getBlock(0), page.getBlock(1)}, aggregationFunction).build();
        AggregationTestOutput testOutput = new AggregationTestOutput(outputBuilder.build().asMap());
        input.runPagesOnAccumulatorWithAssertion(groupId, groupedAccumulator, testOutput);
    }

    private GroupedAccumulator getGroupedAccumulator(InternalAggregationFunction aggFunction) {
        return aggFunction.bind(Ints.asList((int[])GroupByAggregationTestUtils.createArgs(aggFunction)), Optional.empty()).createGroupedAccumulator(UpdateMemory.NOOP);
    }
}

