/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestRealSumAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"real");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        float sum = 0.0f;
        for (int i = start; i < start + length; ++i) {
            sum += (float)i;
        }
        return Float.valueOf(sum);
    }
}

