/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedSet {
    private static final String FUNCTION_NAME = "typed_set_test";

    @Test
    public void testConstructor() {
        for (int i = -2; i <= -1; ++i) {
            try {
                new TypedSet((Type)BigintType.BIGINT, i, FUNCTION_NAME);
                Assert.fail((String)"Should throw exception if expectedSize < 0");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            new TypedSet(null, 1, FUNCTION_NAME);
            Assert.fail((String)"Should throw exception if type is null");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetElementPosition() {
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, initialTypedSetEntryCount, FUNCTION_NAME);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            typedSet.add((Block)blockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)elementCount);
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)j);
        }
    }

    @Test
    public void testGetElementPositionWithNull() {
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, initialTypedSetEntryCount, FUNCTION_NAME);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                blockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            }
            typedSet.add((Block)blockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)(elementCount - elementCount / 10 + 1));
        int nullCount = 0;
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            if (!blockBuilder.isNull(j)) {
                Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)(j - nullCount + 1));
                continue;
            }
            Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)0);
            ++nullCount;
        }
    }

    @Test
    public void testGetElementPositionWithProvidedEmptyBlockBuilder() {
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        BlockBuilder emptyBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, emptyBlockBuilder, initialTypedSetEntryCount, FUNCTION_NAME);
        BlockBuilder externalBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                externalBlockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(externalBlockBuilder, (long)i);
            }
            typedSet.add((Block)externalBlockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)emptyBlockBuilder.getPositionCount());
        Assert.assertEquals((int)typedSet.size(), (int)(elementCount - elementCount / 10 + 1));
        for (int j = 0; j < typedSet.size(); ++j) {
            Assert.assertEquals((int)typedSet.positionOf((Block)emptyBlockBuilder, j), (int)j);
        }
    }

    @Test
    public void testGetElementPositionWithProvidedNonEmptyBlockBuilder() {
        int i;
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        BlockBuilder firstBlockBuilder = pageBuilder.getBlockBuilder(0);
        for (int i2 = 0; i2 < elementCount; ++i2) {
            BigintType.BIGINT.writeLong(firstBlockBuilder, (long)i2);
        }
        pageBuilder.declarePositions(elementCount);
        BlockBuilder secondBlockBuilder = pageBuilder.getBlockBuilder(0);
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, secondBlockBuilder, initialTypedSetEntryCount, FUNCTION_NAME);
        BlockBuilder externalBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                externalBlockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(externalBlockBuilder, (long)i);
            }
            typedSet.add((Block)externalBlockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)(secondBlockBuilder.getPositionCount() - elementCount));
        Assert.assertEquals((int)typedSet.size(), (int)(elementCount - elementCount / 10 + 1));
        for (i = 0; i < typedSet.size(); ++i) {
            int expectedPositionInSecondBlockBuilder = i + elementCount;
            Assert.assertEquals((int)typedSet.positionOf((Block)secondBlockBuilder, expectedPositionInSecondBlockBuilder), (int)expectedPositionInSecondBlockBuilder);
        }
    }

    @Test
    public void testGetElementPositionRandom() {
        TypedSet set = new TypedSet((Type)VarcharType.VARCHAR, 1, FUNCTION_NAME);
        this.testGetElementPositionRandomFor(set);
        BlockBuilder emptyBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 3);
        TypedSet setWithPassedInBuilder = new TypedSet((Type)VarcharType.VARCHAR, emptyBlockBuilder, 1, FUNCTION_NAME);
        this.testGetElementPositionRandomFor(setWithPassedInBuilder);
    }

    @Test
    public void testBigintSimpleTypedSet() {
        ImmutableList expectedSetSizes = ImmutableList.of((Object)1, (Object)10, (Object)100, (Object)1000);
        ImmutableList longBlocks = ImmutableList.of((Object)BlockAssertions.createEmptyLongsBlock(), (Object)BlockAssertions.createLongsBlock(1L), (Object)BlockAssertions.createLongsBlock(1L, 2L, 3L), (Object)BlockAssertions.createLongsBlock(1L, 2L, 3L, 1L, 2L, 3L), (Object)BlockAssertions.createLongsBlock(1L, null, 3L), (Object)BlockAssertions.createLongsBlock(null, null, null), (Object)BlockAssertions.createLongSequenceBlock(0, 100), (Object)BlockAssertions.createLongSequenceBlock(-100, 100), (Object)BlockAssertions.createLongsBlock(Collections.nCopies(1, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies(100, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies((Integer)expectedSetSizes.get(expectedSetSizes.size() - 1) * 2, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies((Integer)expectedSetSizes.get(expectedSetSizes.size() - 1) * 2, 0L)), (Object[])new Block[0]);
        Iterator iterator = expectedSetSizes.iterator();
        while (iterator.hasNext()) {
            int expectedSetSize = (Integer)iterator.next();
            for (Block block : longBlocks) {
                TestTypedSet.testBigint(block, expectedSetSize);
            }
        }
    }

    @Test
    public void testMemoryExceeded() {
        try {
            TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, 10, FUNCTION_NAME);
            int i = 0;
            while ((long)i <= TypedSet.MAX_FUNCTION_MEMORY.toBytes() + 1L) {
                Block block = BlockAssertions.createLongsBlock(Collections.nCopies(1, Long.valueOf(i)));
                typedSet.add(block, 0);
                ++i;
            }
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT.toErrorCode());
        }
    }

    private void testGetElementPositionRandomFor(TypedSet set) {
        BlockBuilder keys = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"abc"));
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            set.add((Block)keys, i);
        }
        BlockBuilder values = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"abc"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"bad"));
        values.appendNull();
        Assert.assertEquals((int)set.positionOf((Block)values, 4), (int)-1);
        Assert.assertEquals((int)set.positionOf((Block)values, 2), (int)0);
        Assert.assertEquals((int)set.positionOf((Block)values, 1), (int)2);
        Assert.assertEquals((int)set.positionOf((Block)values, 0), (int)1);
        Assert.assertFalse((boolean)set.contains((Block)values, 3));
        set.add((Block)values, 4);
        Assert.assertTrue((boolean)set.contains((Block)values, 4));
    }

    private static void testBigint(Block longBlock, int expectedSetSize) {
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, expectedSetSize, FUNCTION_NAME);
        TestTypedSet.testBigintFor(typedSet, longBlock);
        BlockBuilder emptyBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, expectedSetSize);
        TypedSet typedSetWithPassedInBuilder = new TypedSet((Type)BigintType.BIGINT, emptyBlockBuilder, expectedSetSize, FUNCTION_NAME);
        TestTypedSet.testBigintFor(typedSetWithPassedInBuilder, longBlock);
    }

    private static void testBigintFor(TypedSet typedSet, Block longBlock) {
        HashSet<Long> set = new HashSet<Long>();
        for (int blockPosition = 0; blockPosition < longBlock.getPositionCount(); ++blockPosition) {
            long number = BigintType.BIGINT.getLong(longBlock, blockPosition);
            Assert.assertEquals((boolean)typedSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)typedSet.size(), (int)set.size());
            set.add(number);
            typedSet.add(longBlock, blockPosition);
            Assert.assertEquals((boolean)typedSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)typedSet.size(), (int)set.size());
        }
    }
}

