/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class TestVarBinaryMinAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, length);
        for (int i = 0; i < length; ++i) {
            VarbinaryType.VARBINARY.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])Ints.toByteArray((int)i)));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        Slice min = null;
        for (int i = 0; i < length; ++i) {
            Slice slice = Slices.wrappedBuffer((byte[])Ints.toByteArray((int)i));
            min = min == null ? slice : (Slice)Ordering.natural().min((Object)min, (Object)slice);
        }
        return min.toStringUtf8();
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"varchar");
    }
}

