/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;

abstract class AbstractTestFixedHistogramAggregation
extends AbstractTestAggregationFunction {
    private static final int NUM_BINS = 5;
    protected final String method;

    protected AbstractTestFixedHistogramAggregation(String method) {
        this.method = method;
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        int positionCount = 2 * length;
        BlockBuilder samples = DoubleType.DOUBLE.createBlockBuilder(null, positionCount);
        BlockBuilder weights = DoubleType.DOUBLE.createBlockBuilder(null, positionCount);
        for (int weight = 1; weight < 3; ++weight) {
            for (int i = start; i < start + length; ++i) {
                int bin = Math.max(Math.min(i, 4), 0);
                DoubleType.DOUBLE.writeDouble(samples, (double)bin);
                DoubleType.DOUBLE.writeDouble(weights, (double)weight);
            }
        }
        return new Block[]{BlockAssertions.createRLEBlock(5L, positionCount), samples.build(), weights.build(), BlockAssertions.createRLEBlock(this.method, positionCount), BlockAssertions.createRLEBlock(0.0, positionCount), BlockAssertions.createRLEBlock(5.0, positionCount)};
    }

    @Override
    protected String getFunctionName() {
        return "differential_entropy";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"integer", (Object)"double", (Object)"double", (Object)"varchar", (Object)"double", (Object)"double");
    }

    protected static void generateSamplesAndWeights(int start, int length, List<Double> samples, List<Double> weights) {
        for (int weight = 1; weight < 3; ++weight) {
            for (int i = start; i < start + length; ++i) {
                int bin = Math.max(Math.min(i, 4), 0);
                samples.add(Double.valueOf(bin));
                weights.add(Double.valueOf(weight));
            }
        }
    }

    protected static double calculateEntropy(List<Double> samples, List<Double> weights) {
        double totalWeight = weights.stream().mapToDouble(weight -> weight).sum();
        if (totalWeight == 0.0) {
            return Double.NaN;
        }
        HashMap<Double, Double> bucketWeights = new HashMap<Double, Double>();
        for (int i = 0; i < samples.size(); ++i) {
            double sample = samples.get(i);
            double weight2 = weights.get(i);
            bucketWeights.put(sample, bucketWeights.getOrDefault(sample, 0.0) + weight2);
        }
        double entropy = bucketWeights.values().stream().mapToDouble(weight -> weight == 0.0 ? 0.0 : weight / totalWeight * Math.log(totalWeight / weight)).sum();
        return entropy / Math.log(2.0);
    }
}

