/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import java.util.Random;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

abstract class AbstractTestStateStrategy {
    protected static final double MIN = 0.0;
    protected static final double MAX = 10.0;
    private final Function<Integer, DifferentialEntropyStateStrategy> strategySupplier;
    private final boolean weighted;

    protected AbstractTestStateStrategy(Function<Integer, DifferentialEntropyStateStrategy> strategySupplier, boolean weighted) {
        this.strategySupplier = strategySupplier;
        this.weighted = weighted;
    }

    @Test
    public void testUniformDistribution() {
        DifferentialEntropyStateStrategy strategy = this.strategySupplier.apply(2000);
        Random random = new Random(13L);
        for (int i = 0; i < 9999999; ++i) {
            double value = 10.0f * random.nextFloat();
            if (this.weighted) {
                strategy.add(value, 1.0);
                continue;
            }
            strategy.add(value);
        }
        double expected = Math.log(10.0) / Math.log(2.0);
        Assert.assertEquals((double)strategy.calculateEntropy(), (double)expected, (double)0.1);
    }

    @Test
    public void testNormalDistribution() {
        DifferentialEntropyStateStrategy strategy = this.strategySupplier.apply(200000);
        Random random = new Random(13L);
        double sigma = 0.5;
        for (int i = 0; i < 9999999; ++i) {
            double value = 5.0 + sigma * random.nextGaussian();
            if (this.weighted) {
                strategy.add(value, 1.0);
                continue;
            }
            strategy.add(value);
        }
        double expected = 0.5 * Math.log(17.079468445347132 * sigma * sigma) / Math.log(2.0);
        Assert.assertEquals((double)strategy.calculateEntropy(), (double)expected, (double)0.02);
    }
}

