/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.TestingTicker;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.executor.PrioritizedSplitRunner;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.CompletedWork;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionProfiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageProcessor {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @Test
    public void testProjectNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of(), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assert.assertEquals((int)outputPage.getChannelCount(), (int)0);
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)inputPage.getPositionCount());
    }

    @Test
    public void testFilterNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsRange((int)0, (int)50))), (List)ImmutableList.of());
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assert.assertEquals((int)outputPage.getChannelCount(), (int)0);
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)50);
    }

    @Test
    public void testPartialFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsRange((int)25, (int)50))), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(25, 75)}));
    }

    @Test
    public void testPartialFilterAsList() {
        this.testPartialFilterAsList((Type)BooleanType.BOOLEAN, 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)RealType.REAL, 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)BigintType.BIGINT, 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)VarcharType.VARCHAR, 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)BooleanType.BOOLEAN, 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)RealType.REAL, 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)BigintType.BIGINT, 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)VarcharType.VARCHAR, 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)new ArrayType((Type)BigintType.BIGINT), 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)new ArrayType((Type)VarcharType.VARCHAR), 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR)))), 100, 0.5f, 0.5f, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)new ArrayType((Type)BigintType.BIGINT), 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)new ArrayType((Type)VarcharType.VARCHAR), 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        this.testPartialFilterAsList((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR)))), 100, 0.5f, 0.5f, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
    }

    @Test
    public void testSelectAllFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testSelectNoneFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectNoneFilter()), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testProjectEmptyPage() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 0)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testSelectNoneFilterLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectNoneFilter()), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(1, (Type)BigintType.BIGINT, 0)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testProjectLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new PageProjectionWithOutputs((PageProjection)new LazyPagePageProjection(), new int[]{0})), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), memoryContext, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testBatchedOutput() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 20480)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)3);
        for (int i = 0; i < outputPages.size(); ++i) {
            Page actualPage = ((Optional)outputPages.get(i)).orElse(null);
            int offset = i * 8192;
            Page expectedPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(offset, offset + Math.min(inputPage.getPositionCount() - offset, 8192))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actualPage, expectedPage);
        }
    }

    @Test
    public void testAdaptiveBatchSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)VarcharType.VARCHAR, 0)), OptionalInt.of(8192));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)1024));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        int batchSize = 8192;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() <= 0x400000L) continue;
            batchSize /= 2;
        }
        Arrays.fill(slices, Slices.allocate((int)128));
        inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
        outputPages = ImmutableList.copyOf(output);
        int offset = 0;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, Math.min(inputPage.getPositionCount() - offset, batchSize)))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            offset += ((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getPositionCount();
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() >= 0x100000L) continue;
            batchSize *= 2;
        }
    }

    @Test
    public void testOptimisticProcessing() {
        InvocationCountPageProjection firstProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0));
        InvocationCountPageProjection secondProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new PageProjectionWithOutputs((PageProjection)firstProjection, new int[]{0}), (Object)new PageProjectionWithOutputs((PageProjection)secondProjection, new int[]{1})), OptionalInt.of(8192));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)1024));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        int batchSize = 8192;
        while (inputPage.getBlock(0).getRegionSizeInBytes(0, batchSize) > 0x400000L) {
            batchSize /= 2;
        }
        int pageCount = 0;
        while (output.hasNext()) {
            Page actualPage = output.next().orElse(null);
            Block sliceBlock = BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize));
            Page expectedPage = new Page(new Block[]{sliceBlock, sliceBlock});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), actualPage, expectedPage);
            ++pageCount;
            if (actualPage.getSizeInBytes() <= 0x400000L) continue;
            batchSize /= 2;
        }
        Assert.assertEquals((int)secondProjection.getInvocationCount(), (int)pageCount);
        Assert.assertTrue((firstProjection.getInvocationCount() < secondProjection.getInvocationCount() ? 1 : 0) != 0);
    }

    @Test
    public void testRetainedSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)VarcharType.VARCHAR, 0), (Object)this.createInputPageProjectionWithOutputs(1, (Type)VarcharType.VARCHAR, 1)), OptionalInt.of(8192));
        String value = String.join((CharSequence)"", Collections.nCopies(10000, "a"));
        List<String> values = Collections.nCopies(800, value);
        Page inputPage = new Page(new Block[]{BlockAssertions.createStringsBlock(values), BlockAssertions.createStringsBlock(values)});
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), memoryContext, inputPage);
        output.hasNext();
        Assert.assertEquals((long)(memoryContext.getBytes() - (long)ClassLayout.parseClass(VariableWidthBlock.class).instanceSize()), (long)inputPage.getRetainedSizeInBytes());
    }

    @Test
    public void testYieldProjection() {
        int rows = 128;
        int columns = 20;
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)IntStream.range(0, 20).mapToObj(i -> new PageProjectionWithOutputs((PageProjection)new YieldPageProjection((PageProjection)new InputPageProjection(0)), new int[]{i})).collect(ImmutableList.toImmutableList()), OptionalInt.of(8192));
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, yieldSignal, inputPage);
        for (int i2 = 0; i2 < columns - 1; ++i2) {
            Assert.assertTrue((boolean)output.hasNext());
            Assert.assertNull(output.next().orElse(null));
            Assert.assertTrue((boolean)yieldSignal.isSet());
            yieldSignal.reset();
        }
        Assert.assertTrue((boolean)output.hasNext());
        Page actualPage = output.next().orElse(null);
        Assert.assertNotNull((Object)actualPage);
        Assert.assertTrue((boolean)yieldSignal.isSet());
        yieldSignal.reset();
        Object[] blocks = new Block[columns];
        Arrays.fill(blocks, BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, rows)));
        Page expectedPage = new Page((Block[])blocks);
        PageAssertions.assertPageEquals(Collections.nCopies(columns, VarcharType.VARCHAR), actualPage, expectedPage);
        Assert.assertFalse((boolean)output.hasNext());
    }

    @Test
    public void testExpressionProfiler() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        CallExpression add10Expression = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        TestingTicker testingTicker = new TestingTicker();
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        Supplier projectionSupplier = functionCompiler.compileProjection(TestingConnectorSession.SESSION.getSqlFunctionProperties(), (RowExpression)add10Expression, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(1, 11)});
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
        for (int i = 0; i < 100; ++i) {
            profiler.start();
            Work work = projection.project(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), page, SelectedPositions.positionsRange((int)0, (int)page.getPositionCount()));
            if (i < 10) {
                testingTicker.increment(10L, TimeUnit.SECONDS);
                profiler.stop(page.getPositionCount());
                Assert.assertTrue((boolean)profiler.isExpressionExpensive());
            } else {
                testingTicker.increment(0L, TimeUnit.NANOSECONDS);
                profiler.stop(page.getPositionCount());
                Assert.assertFalse((boolean)profiler.isExpressionExpensive());
            }
            work.process();
        }
    }

    @Test
    public void testIncreasingBatchSize() {
        int rows = 1024;
        TestingTicker testingTicker = new TestingTicker();
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)), OptionalInt.of(1), profiler);
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        long previousPositionCount = 1L;
        long totalPositionCount = 0L;
        while (totalPositionCount < (long)rows) {
            Optional<Page> page = output.next();
            Assert.assertTrue((boolean)page.isPresent());
            long positionCount = page.get().getPositionCount();
            if (positionCount > 1L && (totalPositionCount += positionCount) != (long)rows) {
                Assert.assertEquals((long)positionCount, (long)(previousPositionCount * 2L));
            }
            previousPositionCount = positionCount;
        }
    }

    @Test
    public void testDecreasingBatchSize() {
        int rows = 1024;
        TestingTicker testingTicker = new TestingTicker();
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, new Duration(0.0, TimeUnit.MILLISECONDS));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)), OptionalInt.of(512), profiler);
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        long previousPositionCount = 1L;
        long totalPositionCount = 0L;
        while (totalPositionCount < (long)rows) {
            Optional<Page> page = output.next();
            Assert.assertTrue((boolean)page.isPresent());
            long positionCount = page.get().getPositionCount();
            totalPositionCount += positionCount;
            if (positionCount > 1L && previousPositionCount != 1L) {
                Assert.assertEquals((long)positionCount, (long)(previousPositionCount / 2L));
            }
            previousPositionCount = positionCount;
        }
    }

    private PageProjectionWithOutputs createInputPageProjectionWithOutputs(int inputChannel, Type type, int outputChannel) {
        return new PageProjectionWithOutputs((PageProjection)new InputPageProjection(inputChannel), new int[]{outputChannel});
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, Page inputPage) {
        return this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, DriverYieldSignal yieldSignal, Page inputPage) {
        return this.processAndAssertRetainedPageSize(pageProcessor, yieldSignal, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), inputPage);
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, DriverYieldSignal yieldSignal, AggregatedMemoryContext memoryContext, Page inputPage) {
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), yieldSignal, memoryContext.newLocalMemoryContext(PageProcessor.class.getSimpleName()), inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        return output;
    }

    private void testPartialFilterAsList(Type type, int positionCount, float primitiveNullRate, float nestedNullRate, boolean useBlockView, List<BlockAssertions.Encoding> wrappings) {
        int[] positions = IntStream.range(0, positionCount / 2).map(x -> x * 2).toArray();
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsList((int[])positions, (int)0, (int)(positionCount / 2)))), (List)ImmutableList.of((Object)this.createInputPageProjectionWithOutputs(0, (Type)BigintType.BIGINT, 0)), OptionalInt.of(8192));
        Page inputPage = PageAssertions.createPageWithRandomData((List<Type>)ImmutableList.of((Object)type), positionCount, false, false, primitiveNullRate, nestedNullRate, useBlockView, wrappings);
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)type), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{inputPage.getBlock(0).copyPositions(positions, 0, positionCount / 2)}));
    }

    private static class SelectNoneFilter
    implements PageFilter {
        private SelectNoneFilter() {
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(SqlFunctionProperties properties, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)0);
        }
    }

    public static class SelectAllFilter
    implements PageFilter {
        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(SqlFunctionProperties properties, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)page.getPositionCount());
        }
    }

    public static class TestingPageFilter
    implements PageFilter {
        private final SelectedPositions selectedPositions;

        public TestingPageFilter(SelectedPositions selectedPositions) {
            this.selectedPositions = selectedPositions;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(SqlFunctionProperties properties, Page page) {
            return this.selectedPositions;
        }
    }

    public static class LazyPagePageProjection
    implements PageProjection {
        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0, 1});
        }

        public Work<List<Block>> project(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new CompletedWork((Object)ImmutableList.of((Object)page.getBlock(0).getLoadedBlock()));
        }
    }

    private class YieldPageProjection
    extends InvocationCountPageProjection {
        public YieldPageProjection(PageProjection delegate) {
            super(delegate);
        }

        @Override
        public Work<List<Block>> project(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new YieldPageProjectionWork(properties, yieldSignal, page, selectedPositions);
        }

        private class YieldPageProjectionWork
        implements Work<List<Block>> {
            private final DriverYieldSignal yieldSignal;
            private final Work<List<Block>> work;

            public YieldPageProjectionWork(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
                this.yieldSignal = yieldSignal;
                this.work = YieldPageProjection.this.delegate.project(properties, yieldSignal, page, selectedPositions);
            }

            public boolean process() {
                Assert.assertTrue((boolean)this.work.process());
                this.yieldSignal.setWithDelay(1L, TestPageProcessor.this.executor);
                this.yieldSignal.forceYieldForTesting();
                return true;
            }

            public List<Block> getResult() {
                return (List)this.work.getResult();
            }
        }
    }

    private static class InvocationCountPageProjection
    implements PageProjection {
        protected final PageProjection delegate;
        private int invocationCount;

        public InvocationCountPageProjection(PageProjection delegate) {
            this.delegate = delegate;
        }

        public boolean isDeterministic() {
            return this.delegate.isDeterministic();
        }

        public InputChannels getInputChannels() {
            return this.delegate.getInputChannels();
        }

        public Work<List<Block>> project(SqlFunctionProperties properties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.setInvocationCount(this.getInvocationCount() + 1);
            return this.delegate.project(properties, yieldSignal, page, selectedPositions);
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(int invocationCount) {
            this.invocationCount = invocationCount;
        }
    }
}

