/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockFlattener;
import com.facebook.presto.common.block.BlockSerdeUtil;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.UncheckedStackArrayAllocator;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.ArrayBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.facebook.presto.operator.repartition.MapBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.OptimizedPartitionedOutputOperator;
import com.facebook.presto.operator.repartition.RowBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.VariableWidthBlockEncodingBuffer;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockEncodingBuffers {
    private static final int POSITIONS_PER_BLOCK = 1000;
    public static final String STRING_VALUE = "0123456789";

    @Test
    public void testBigint() {
        this.testBlock((Type)BigintType.BIGINT, BlockAssertions.createRandomLongsBlock(1000, 0.2f));
    }

    @Test
    public void testLongDecimal() {
        this.testBlock((Type)DecimalType.createDecimalType((int)19), BlockAssertions.createRandomLongDecimalsBlock(1000, 0.2f));
    }

    @Test
    public void testInteger() {
        this.testBlock((Type)IntegerType.INTEGER, BlockAssertions.createRandomIntsBlock(1000, 0.2f));
    }

    @Test
    public void testSmallint() {
        this.testBlock((Type)SmallintType.SMALLINT, BlockAssertions.createRandomSmallintsBlock(1000, 0.2f));
    }

    @Test
    public void testBoolean() {
        this.testBlock((Type)BooleanType.BOOLEAN, BlockAssertions.createRandomBooleansBlock(1000, 0.2f));
    }

    @Test
    public void testVarchar() {
        this.testBlock((Type)VarcharType.VARCHAR, BlockAssertions.createRandomStringBlock(1000, 0.2f, 10));
        this.testBlock((Type)VarcharType.VARCHAR, BlockAssertions.createRandomStringBlock(1000, 0.2f, 0));
        this.testBlock((Type)VarcharType.VARCHAR, (Block)BlockAssertions.createRleBlockWithRandomValue(BlockAssertions.createRandomStringBlock(1000, 0.2f, 0), 1000));
    }

    @Test
    public void testArray() {
        this.testNestedBlock((Type)new ArrayType((Type)BigintType.BIGINT));
        this.testNestedBlock((Type)new ArrayType((Type)DecimalType.createDecimalType((int)18)));
        this.testNestedBlock((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19)));
        this.testNestedBlock((Type)new ArrayType((Type)IntegerType.INTEGER));
        this.testNestedBlock((Type)new ArrayType((Type)SmallintType.SMALLINT));
        this.testNestedBlock((Type)new ArrayType((Type)BooleanType.BOOLEAN));
        this.testNestedBlock((Type)new ArrayType((Type)VarcharType.VARCHAR));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)18))));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)19))));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testNestedBlock((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)));
    }

    @Test
    public void testMap() {
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)DecimalType.createDecimalType((int)19)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)DecimalType.createDecimalType((int)19))));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)BigintType.BIGINT)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)DecimalType.createDecimalType((int)19), (Type)new ArrayType((Type)DecimalType.createDecimalType((int)19))));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)new ArrayType((Type)SmallintType.SMALLINT)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)new ArrayType((Type)BooleanType.BOOLEAN)));
        this.testNestedBlock((Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR)));
    }

    @Test
    public void testRow() {
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19), (Object)DecimalType.createDecimalType((int)19))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19), (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT, (Object)SmallintType.SMALLINT)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BigintType.BIGINT)), (Object)BigintType.BIGINT)), (Object)BigintType.BIGINT)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)DecimalType.createDecimalType((int)19))), (Object)DecimalType.createDecimalType((int)18))), (Object)DecimalType.createDecimalType((int)17))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)IntegerType.INTEGER)), (Object)IntegerType.INTEGER)), (Object)IntegerType.INTEGER)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)SmallintType.SMALLINT)), (Object)SmallintType.SMALLINT)), (Object)SmallintType.SMALLINT)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)BooleanType.BOOLEAN)), (Object)BooleanType.BOOLEAN)), (Object)BooleanType.BOOLEAN)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)VarcharType.VARCHAR)), (Object)VarcharType.VARCHAR)), (Object)VarcharType.VARCHAR)));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new ArrayType((Type)IntegerType.INTEGER))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)new ArrayType((Type)SmallintType.SMALLINT))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)new ArrayType((Type)BooleanType.BOOLEAN))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)new ArrayType((Type)VarcharType.VARCHAR))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)DecimalType.createDecimalType((int)19)), (Object)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)19)))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)BlockAssertions.createMapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)SmallintType.SMALLINT), (Object)BlockAssertions.createMapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)BlockAssertions.createMapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN))));
        this.testNestedBlock((Type)RowType.withDefaultFieldNames((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR), (Object)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR))));
    }

    @Test
    public void testBufferSizeEstimation() {
        Block[] blocks = new Block[2];
        blocks[0] = BlockAssertions.createRandomLongsBlock(1000, 0.5f);
        Object[] strings = new String[1000];
        Arrays.fill(strings, STRING_VALUE);
        blocks[1] = BlockAssertions.createStringsBlock((String[])strings);
        ImmutableList expectedMaxBufferCapacities = ImmutableList.of((Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)1200, (Object)4800, (Object)((int)((double)(1000 * STRING_VALUE.length()) * (double)1.2f))));
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
        blocks[0] = BlockAssertions.createRandomLongsBlock(1000, 0.0f);
        blocks[1] = BlockAssertions.createRleBlockWithRandomValue(BlockAssertions.createStringsBlock(STRING_VALUE), 1000);
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
        blocks[0] = BlockAssertions.createRandomDictionaryBlock(BlockAssertions.createRandomLongsBlock(200, 0.0f), 1000);
        blocks[1] = BlockAssertions.createRandomDictionaryBlock(BlockAssertions.createStringsBlock(STRING_VALUE), 1000);
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
        int[] offsets = IntStream.rangeClosed(0, 1000).toArray();
        boolean[] nulls = new boolean[1000];
        blocks[1] = ArrayBlock.fromElementBlock((int)1000, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createStringsBlock((String[])strings));
        expectedMaxBufferCapacities = ImmutableList.of((Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)1200, (Object)4800, (Object)ImmutableList.of((Object)1200, (Object)4800, (Object)((int)((double)(1000 * STRING_VALUE.length()) * (double)1.2f)))));
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
        blocks[1] = ArrayBlock.fromElementBlock((int)1000, Optional.of(nulls), (int[])offsets, (Block)BlockAssertions.createRandomDictionaryBlock(BlockAssertions.createStringsBlock(STRING_VALUE, STRING_VALUE), 1000));
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
        RunLengthEncodedBlock keyBlock = BlockAssertions.createRLEBlock(1L, 1000);
        Block valueBlock = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).createBlockFromKeyValue(1000, Optional.of(nulls), offsets, BlockAssertions.createRandomLongsBlock(1000, 0.5f), (Block)BlockAssertions.createRLEBlock(1L, 1000));
        blocks[0] = BlockAssertions.createRandomLongsBlock(1000, 0.5f);
        blocks[1] = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).createBlockFromKeyValue(1000, Optional.of(nulls), offsets, (Block)keyBlock, valueBlock);
        expectedMaxBufferCapacities = ImmutableList.of((Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)4800, (Object)9600, (Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)4800, (Object)9600, (Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)1200, (Object)9600))));
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
        blocks[1] = RowBlock.fromFieldBlocks((int)1000, Optional.of(nulls), (Block[])new Block[]{BlockAssertions.createRandomLongsBlock(1000, 0.0f), BlockAssertions.createRLEBlock(1L, 1000)});
        expectedMaxBufferCapacities = ImmutableList.of((Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)1200, (Object)4800, (Object)ImmutableList.of((Object)1200, (Object)9600), (Object)ImmutableList.of((Object)1200, (Object)9600)));
        this.assertEstimatedBufferMaxCapacities(new Page(blocks), (List<Object>)expectedMaxBufferCapacities);
    }

    private void assertEstimatedBufferMaxCapacities(Page page, List<Object> expectedMaxBufferCapacities) {
        int channelCount = page.getChannelCount();
        int positionCount = page.getPositionCount();
        DecodedBlockNode[] decodedBlocks = new DecodedBlockNode[channelCount];
        BlockFlattener flattener = new BlockFlattener((ArrayAllocator)new UncheckedStackArrayAllocator());
        Closer blockLeaseCloser = Closer.create();
        long estimatedSerializedPageSize = 0L;
        for (int i = 0; i < decodedBlocks.length; ++i) {
            decodedBlocks[i] = OptimizedPartitionedOutputOperator.decodeBlock((BlockFlattener)flattener, (Closer)blockLeaseCloser, (Block)page.getBlock(i));
            estimatedSerializedPageSize += decodedBlocks[i].getEstimatedSerializedSizeInBytes();
        }
        int[] positions = IntStream.range(0, positionCount).toArray();
        for (int i = 0; i < decodedBlocks.length; ++i) {
            BlockEncodingBuffer buffer = AbstractBlockEncodingBuffer.createBlockEncodingBuffers((DecodedBlockNode)decodedBlocks[i], (ArrayAllocator)new UncheckedStackArrayAllocator(1000), (boolean)false);
            buffer.setupDecodedBlocksAndPositions(decodedBlocks[i], positions, positionCount, (int)estimatedSerializedPageSize, estimatedSerializedPageSize);
            this.assertEstimatedBufferMaxCapacity(buffer, (List)expectedMaxBufferCapacities.get(i));
        }
        try {
            blockLeaseCloser.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void assertEstimatedBufferMaxCapacity(BlockEncodingBuffer buffer, List<Object> expectedMaxBufferCapacities) {
        if (buffer instanceof ArrayBlockEncodingBuffer) {
            Assert.assertEquals((int)expectedMaxBufferCapacities.size(), (int)3);
            Assert.assertEquals((Object)((ArrayBlockEncodingBuffer)buffer).getEstimatedNullsBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(0));
            Assert.assertEquals((Object)((ArrayBlockEncodingBuffer)buffer).getEstimatedOffsetBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(1));
            this.assertEstimatedBufferMaxCapacity(((ArrayBlockEncodingBuffer)buffer).getValuesBuffers(), (List)expectedMaxBufferCapacities.get(2));
        } else if (buffer instanceof MapBlockEncodingBuffer) {
            Assert.assertEquals((int)expectedMaxBufferCapacities.size(), (int)4);
            Assert.assertEquals((Object)((MapBlockEncodingBuffer)buffer).getEstimatedOffsetBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(0));
            Assert.assertEquals((Object)((MapBlockEncodingBuffer)buffer).getEstimatedHashTableBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(1));
            this.assertEstimatedBufferMaxCapacity(((MapBlockEncodingBuffer)buffer).getKeyBuffers(), (List)expectedMaxBufferCapacities.get(2));
            this.assertEstimatedBufferMaxCapacity(((MapBlockEncodingBuffer)buffer).getValueBuffers(), (List)expectedMaxBufferCapacities.get(3));
        } else if (buffer instanceof RowBlockEncodingBuffer) {
            BlockEncodingBuffer[] fieldBuffers = ((RowBlockEncodingBuffer)buffer).getFieldBuffers();
            Assert.assertEquals((int)expectedMaxBufferCapacities.size(), (int)(fieldBuffers.length + 2));
            Assert.assertEquals((Object)((RowBlockEncodingBuffer)buffer).getEstimatedNullsBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(0));
            Assert.assertEquals((Object)((RowBlockEncodingBuffer)buffer).getEstimatedOffsetBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(1));
            for (int i = 0; i < fieldBuffers.length; ++i) {
                this.assertEstimatedBufferMaxCapacity(fieldBuffers[i], (List)expectedMaxBufferCapacities.get(i + 2));
            }
        } else if (buffer instanceof VariableWidthBlockEncodingBuffer) {
            Assert.assertEquals((int)expectedMaxBufferCapacities.size(), (int)3);
            Assert.assertEquals((Object)((VariableWidthBlockEncodingBuffer)buffer).getEstimatedNullsBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(0));
            Assert.assertEquals((Object)((VariableWidthBlockEncodingBuffer)buffer).getEstimatedOffsetBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(1));
            Assert.assertEquals((Object)((VariableWidthBlockEncodingBuffer)buffer).getEstimatedSliceBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(2));
        } else {
            Assert.assertEquals((int)expectedMaxBufferCapacities.size(), (int)2);
            Assert.assertEquals((Object)((AbstractBlockEncodingBuffer)buffer).getEstimatedNullsBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(0));
            Assert.assertEquals((Object)((AbstractBlockEncodingBuffer)buffer).getEstimatedValueBufferMaxCapacity(), (Object)expectedMaxBufferCapacities.get(1));
        }
    }

    private void testBlock(Type type, Block block) {
        Objects.requireNonNull(type);
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.createAllNullsBlock(type, 1000));
        TestBlockEncodingBuffers.assertSerialized(type, block);
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        TestBlockEncodingBuffers.assertSerialized(type, block.getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY))).getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))).getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))).getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))).getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))).getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block, 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))).getRegion(500, 333));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block.getRegion(500, 333), 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block.getRegion(500, 333), 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block.getRegion(500, 333), 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block.getRegion(500, 333), 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block.getRegion(500, 333), 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH))));
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.wrapBlock(block.getRegion(500, 333), 1000, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY))));
    }

    private void testNestedBlock(Type type) {
        Objects.requireNonNull(type);
        TestBlockEncodingBuffers.assertSerialized(type, BlockAssertions.createAllNullsBlock(type, 1000));
        BlockStatus blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of());
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, false, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of());
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
        blockStatus = this.buildBlockStatusWithType(type, 1000, true, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestBlockEncodingBuffers.assertSerialized(type, blockStatus.block, blockStatus.expectedRowSizes);
    }

    private static void assertSerialized(Type type, Block block) {
        TestBlockEncodingBuffers.assertSerialized(type, block, null);
    }

    private static void assertSerialized(Type type, Block block, int[] expectedRowSizes) {
        Closer blockLeaseCloser = Closer.create();
        BlockFlattener flattener = new BlockFlattener((ArrayAllocator)new UncheckedStackArrayAllocator());
        DecodedBlockNode decodedBlock = OptimizedPartitionedOutputOperator.decodeBlock((BlockFlattener)flattener, (Closer)blockLeaseCloser, (Block)block);
        BlockEncodingBuffer buffers = AbstractBlockEncodingBuffer.createBlockEncodingBuffers((DecodedBlockNode)decodedBlock, (ArrayAllocator)new UncheckedStackArrayAllocator(1000), (boolean)false);
        int[] positions = IntStream.range(0, block.getPositionCount() / 2).toArray();
        TestBlockEncodingBuffers.copyPositions(decodedBlock, buffers, positions, expectedRowSizes);
        positions = IntStream.range(block.getPositionCount() / 2, block.getPositionCount()).toArray();
        TestBlockEncodingBuffers.copyPositions(decodedBlock, buffers, positions, expectedRowSizes);
        BlockAssertions.assertBlockEquals(type, TestBlockEncodingBuffers.serialize(buffers), block);
        buffers.resetBuffers();
        positions = IntStream.range(0, block.getPositionCount()).filter(n -> n % 2 == 0).toArray();
        Block expectedBlock = block.copyPositions(positions, 0, positions.length);
        TestBlockEncodingBuffers.copyPositions(decodedBlock, buffers, positions, expectedRowSizes);
        try {
            blockLeaseCloser.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        BlockAssertions.assertBlockEquals(type, TestBlockEncodingBuffers.serialize(buffers), expectedBlock);
    }

    private static void copyPositions(DecodedBlockNode decodedBlock, BlockEncodingBuffer buffer, int[] positions, int[] expectedRowSizes) {
        buffer.setupDecodedBlocksAndPositions(decodedBlock, positions, positions.length, (int)decodedBlock.getRetainedSizeInBytes(), decodedBlock.getEstimatedSerializedSizeInBytes());
        ((AbstractBlockEncodingBuffer)buffer).checkValidPositions();
        if (expectedRowSizes != null) {
            int[] actualSizes = new int[positions.length];
            buffer.accumulateSerializedRowSizes(actualSizes);
            int[] expectedSizes = Arrays.stream(positions).map(i -> expectedRowSizes[i]).toArray();
            Assert.assertEquals((Object)actualSizes, (Object)expectedSizes);
        }
        buffer.setNextBatch(0, positions.length);
        buffer.appendDataInBatch();
    }

    private static Block serialize(BlockEncodingBuffer buffer) {
        DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(buffer.getSerializedSizeInBytes()));
        buffer.serializeTo((SliceOutput)output);
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager();
        return BlockSerdeUtil.readBlock((BlockEncodingSerde)blockEncodingSerde, (SliceInput)output.slice().getInput());
    }

    private BlockStatus buildBlockStatusWithType(Type type, int positionCount, boolean isView, List<BlockAssertions.Encoding> wrappings) {
        return this.buildBlockStatusWithType(type, positionCount, isView, 0.2f, 0.2f, wrappings);
    }

    private BlockStatus buildBlockStatusWithType(Type type, int positionCount, boolean isView, float primitiveNullRate, float nestedNullRate, List<BlockAssertions.Encoding> wrappings) {
        BlockStatus blockStatus = null;
        if (isView) {
            positionCount *= 2;
        }
        if (type == BigintType.BIGINT) {
            blockStatus = TestBlockEncodingBuffers.buildBigintBlockStatus(positionCount, primitiveNullRate);
        } else if (type instanceof DecimalType) {
            blockStatus = !((DecimalType)type).isShort() ? TestBlockEncodingBuffers.buildLongDecimalBlockStatus(positionCount, primitiveNullRate) : TestBlockEncodingBuffers.buildShortDecimalBlockStatus(positionCount, primitiveNullRate);
        } else if (type == IntegerType.INTEGER) {
            blockStatus = this.buildIntegerBlockStatus(positionCount, primitiveNullRate);
        } else if (type == SmallintType.SMALLINT) {
            blockStatus = this.buildSmallintBlockStatus(positionCount, primitiveNullRate);
        } else if (type == BooleanType.BOOLEAN) {
            blockStatus = this.buildBooleanBlockStatus(positionCount, primitiveNullRate);
        } else if (type == VarcharType.VARCHAR) {
            blockStatus = this.buildVarcharBlockStatus(positionCount, primitiveNullRate, 10);
        } else {
            boolean[] isNull = null;
            if (nestedNullRate > 0.0f) {
                isNull = new boolean[positionCount];
            }
            int[] offsets = new int[positionCount + 1];
            for (int position = 0; position < positionCount; ++position) {
                if (nestedNullRate > 0.0f && ThreadLocalRandom.current().nextDouble(1.0) < (double)nestedNullRate) {
                    isNull[position] = true;
                    offsets[position + 1] = offsets[position];
                    continue;
                }
                offsets[position + 1] = offsets[position] + (type instanceof RowType ? 1 : ThreadLocalRandom.current().nextInt(10) + 1);
            }
            if (type instanceof ArrayType) {
                blockStatus = this.buildArrayBlockStatus((ArrayType)type, positionCount, isView, Optional.ofNullable(isNull), offsets, primitiveNullRate, nestedNullRate, wrappings);
            } else if (type instanceof MapType) {
                blockStatus = this.buildMapBlockStatus((MapType)type, positionCount, isView, Optional.ofNullable(isNull), offsets, primitiveNullRate, nestedNullRate, wrappings);
            } else if (type instanceof RowType) {
                blockStatus = this.buildRowBlockStatus((RowType)type, positionCount, isView, Optional.ofNullable(isNull), offsets, primitiveNullRate, nestedNullRate, wrappings);
            } else {
                throw new UnsupportedOperationException(String.format("type %s is not supported.", type));
            }
        }
        if (isView) {
            int offset = (positionCount /= 2) / 2;
            Block blockView = blockStatus.block.getRegion(offset, positionCount);
            int[] expectedRowSizesView = Arrays.stream(blockStatus.expectedRowSizes, offset, offset + positionCount).toArray();
            blockStatus = new BlockStatus(blockView, expectedRowSizesView);
        }
        blockStatus = this.buildDictRleBlockStatus(blockStatus, positionCount, wrappings);
        return blockStatus;
    }

    private static BlockStatus buildBigintBlockStatus(int positionCount, float nullRate) {
        Block block = BlockAssertions.createRandomLongsBlock(positionCount, nullRate);
        int[] expectedRowSizes = IntStream.generate(() -> 9).limit(positionCount).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private static BlockStatus buildShortDecimalBlockStatus(int positionCount, float nullRate) {
        Block block = BlockAssertions.createRandomShortDecimalsBlock(positionCount, nullRate);
        int[] expectedRowSizes = IntStream.generate(() -> 9).limit(positionCount).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private static BlockStatus buildLongDecimalBlockStatus(int positionCount, float nullRate) {
        Block block = BlockAssertions.createRandomLongDecimalsBlock(positionCount, nullRate);
        int[] expectedRowSizes = IntStream.generate(() -> 17).limit(positionCount).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private BlockStatus buildIntegerBlockStatus(int positionCount, float nullRate) {
        Block block = BlockAssertions.createRandomIntsBlock(positionCount, nullRate);
        int[] expectedRowSizes = IntStream.generate(() -> 5).limit(positionCount).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private BlockStatus buildSmallintBlockStatus(int positionCount, float nullRate) {
        Block block = BlockAssertions.createRandomSmallintsBlock(positionCount, nullRate);
        int[] expectedRowSizes = IntStream.generate(() -> 3).limit(positionCount).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private BlockStatus buildBooleanBlockStatus(int positionCount, float nullRate) {
        Block block = BlockAssertions.createRandomBooleansBlock(positionCount, nullRate);
        int[] expectedRowSizes = IntStream.generate(() -> 2).limit(positionCount).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private BlockStatus buildVarcharBlockStatus(int positionCount, float nullRate, int maxStringLength) {
        Block block = BlockAssertions.createRandomStringBlock(positionCount, nullRate, maxStringLength);
        int[] expectedRowSizes = IntStream.range(0, positionCount).map(i -> block.getSliceLength(i) + 5).toArray();
        return new BlockStatus(block, expectedRowSizes);
    }

    private BlockStatus buildDictRleBlockStatus(BlockStatus blockStatus, int positionCount, List<BlockAssertions.Encoding> wrappings) {
        Preconditions.checkArgument((blockStatus.block.getPositionCount() == positionCount ? 1 : 0) != 0);
        if (wrappings.isEmpty()) {
            return blockStatus;
        }
        BlockStatus wrappedBlockStatus = blockStatus;
        block4: for (int i = wrappings.size() - 1; i >= 0; --i) {
            switch (wrappings.get(i)) {
                case DICTIONARY: {
                    wrappedBlockStatus = this.buildDictionaryBlockStatus(blockStatus, positionCount);
                    continue block4;
                }
                case RUN_LENGTH: {
                    wrappedBlockStatus = this.buildRleBlockStatus(blockStatus, positionCount);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(String.format("wrappings %s is incorrect", wrappings));
                }
            }
        }
        return wrappedBlockStatus;
    }

    private BlockStatus buildDictionaryBlockStatus(BlockStatus dictionary, int positionCount) {
        DictionaryBlock dictionaryBlock = BlockAssertions.createRandomDictionaryBlock(dictionary.block, positionCount);
        int[] mappedExpectedRowSizes = IntStream.range(0, positionCount).map(i -> dictionary.expectedRowSizes[dictionaryBlock.getId(i)]).toArray();
        return new BlockStatus((Block)dictionaryBlock, mappedExpectedRowSizes);
    }

    private BlockStatus buildRleBlockStatus(BlockStatus blockStatus, int positionCount) {
        int[] expectedRowSizes = new int[positionCount];
        Arrays.setAll(expectedRowSizes, i -> blockStatus.expectedRowSizes[blockStatus.block.getPositionCount() / 2]);
        return new BlockStatus((Block)BlockAssertions.createRleBlockWithRandomValue(blockStatus.block, positionCount), expectedRowSizes);
    }

    private BlockStatus buildArrayBlockStatus(ArrayType arrayType, int positionCount, boolean isView, Optional<boolean[]> isNull, int[] offsets, float primitiveNullRate, float nestedNullRate, List<BlockAssertions.Encoding> wrappings) {
        Objects.requireNonNull(isNull);
        Objects.requireNonNull(offsets);
        BlockStatus valuesBlockStatus = this.buildBlockStatusWithType(arrayType.getElementType(), offsets[positionCount], isView, primitiveNullRate, nestedNullRate, wrappings);
        int[] expectedRowSizes = IntStream.range(0, positionCount).map(i -> 5 + Arrays.stream(valuesBlockStatus.expectedRowSizes, offsets[i], offsets[i + 1]).sum()).toArray();
        BlockStatus blockStatus = new BlockStatus(ArrayBlock.fromElementBlock((int)positionCount, isNull, (int[])offsets, (Block)valuesBlockStatus.block), expectedRowSizes);
        return blockStatus;
    }

    private BlockStatus buildMapBlockStatus(MapType mapType, int positionCount, boolean isView, Optional<boolean[]> isNull, int[] offsets, float primitiveNullRate, float nestedNullRate, List<BlockAssertions.Encoding> wrappings) {
        BlockStatus keyBlockStatus = this.buildBlockStatusWithType(mapType.getKeyType(), offsets[positionCount], isView, 0.0f, 0.0f, wrappings);
        BlockStatus valueBlockStatus = this.buildBlockStatusWithType(mapType.getValueType(), offsets[positionCount], isView, primitiveNullRate, nestedNullRate, wrappings);
        int[] expectedKeySizes = keyBlockStatus.expectedRowSizes;
        int[] expectedValueSizes = valueBlockStatus.expectedRowSizes;
        Arrays.setAll(expectedKeySizes, i -> expectedKeySizes[i] + expectedValueSizes[i]);
        int[] expectedRowSizes = IntStream.range(0, positionCount).map(i -> 5 + Arrays.stream(expectedKeySizes, offsets[i], offsets[i + 1]).sum()).toArray();
        Type keyType = mapType.getKeyType();
        BlockStatus blockStatus = new BlockStatus((Block)MapBlock.fromKeyValueBlock((int)positionCount, isNull, (int[])offsets, (Block)keyBlockStatus.block, (Block)valueBlockStatus.block), expectedRowSizes);
        return blockStatus;
    }

    private BlockStatus buildRowBlockStatus(RowType rowType, int positionCount, boolean isView, Optional<boolean[]> isNull, int[] offsets, float primitiveNullRate, float nestedNullRate, List<BlockAssertions.Encoding> wrappings) {
        Objects.requireNonNull(isNull);
        int[] expectedTotalFieldSizes = new int[positionCount];
        List fieldTypes = rowType.getTypeParameters();
        Block[] fieldBlocks = new Block[fieldTypes.size()];
        for (int i2 = 0; i2 < fieldBlocks.length; ++i2) {
            BlockStatus fieldBlockStatus = this.buildBlockStatusWithType((Type)fieldTypes.get(i2), positionCount, isView, primitiveNullRate, nestedNullRate, wrappings);
            fieldBlocks[i2] = fieldBlockStatus.block;
            Arrays.setAll(expectedTotalFieldSizes, j -> expectedTotalFieldSizes[j] + fieldBlockStatus.expectedRowSizes[j]);
        }
        int[] expectedRowSizes = IntStream.range(0, positionCount).map(i -> 5 + Arrays.stream(expectedTotalFieldSizes, offsets[i], offsets[i + 1]).sum()).toArray();
        BlockStatus blockStatus = new BlockStatus(RowBlock.fromFieldBlocks((int)positionCount, isNull, (Block[])fieldBlocks), expectedRowSizes);
        return blockStatus;
    }

    private static class BlockStatus {
        private final Block block;
        private final int[] expectedRowSizes;

        BlockStatus(Block block, int[] expectedRowSizes) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.expectedRowSizes = Objects.requireNonNull(expectedRowSizes, "expectedRowSizes is null");
        }
    }
}

