/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestRegexpFunctions
extends AbstractTestFunctions {
    AbstractTestRegexpFunctions(RegexLibrary regexLibrary) {
        super(new FeaturesConfig().setRegexLibrary(regexLibrary));
    }

    @BeforeClass
    public void setUp() {
        this.registerScalar(AbstractTestRegexpFunctions.class);
    }

    @ScalarFunction(deterministic=false)
    @SqlType(value="varchar")
    public static Slice invalidUtf8() {
        return Slices.wrappedBuffer((byte[])new byte[]{65, 65, -19, -96, -128, 65, 65, 65, 65, -19, -65, -65, 65, 65, 65});
    }

    @Test
    public void testRegexpLike() {
        this.functionAssertions.tryEvaluate("REGEXP_LIKE(invalid_utf8(), invalid_utf8())", (Type)BooleanType.BOOLEAN);
        this.assertFunction("REGEXP_LIKE('Stephen', 'Ste(v|ph)en')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Stevens', 'Ste(v|ph)en')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Stephen', '^Ste(v|ph)en$')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Stevens', '^Ste(v|ph)en$')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REGEXP_LIKE('hello world', '[a-z]')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('hello\nworld', '.*hello\nworld.*')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-z]+$')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REGEXP_LIKE('Hello', '^(?i)[a-z]+$')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-zA-Z]+$')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('test', 'test\\b')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testRegexCharLike() {
        this.assertFunction("REGEXP_LIKE('ala', CHAR 'ala  ')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REGEXP_LIKE('ala  ', CHAR 'ala  ')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testRegexpReplace() {
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]')", (Type)VarcharType.createVarcharType((int)10), " .");
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]', '*')", (Type)VarcharType.createVarcharType((int)65), "*** *****.");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})')", (Type)VarcharType.createVarcharType((int)21), "call  now");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})', '($1) $2-$3')", (Type)VarcharType.createVarcharType((int)2331), "call (555) 123-4444 now");
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', 'x', 'x')", (Type)VarcharType.createVarcharType((int)71), "xxx xxx xxx");
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', 'x', '\\x')", (Type)VarcharType.createVarcharType((int)143), "xxx xxx xxx");
        this.assertFunction("REGEXP_REPLACE('xxx', '', 'y')", (Type)VarcharType.createVarcharType((int)7), "yxyxyxy");
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '\\')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', 'x', '$0')", (Type)VarcharType.createVarcharType((int)143), "xxx xxx xxx");
        this.assertFunction("REGEXP_REPLACE('xxx', '(x)', '$01')", (Type)VarcharType.createVarcharType((int)19), "xxx");
        this.assertFunction("REGEXP_REPLACE('xxx', 'x', '$05')", (Type)VarcharType.createVarcharType((int)19), "x5x5x5");
        this.assertFunction("REGEXP_REPLACE('123456789', '(1)(2)(3)(4)(5)(6)(7)(8)(9)', '$10')", (Type)VarcharType.createVarcharType((int)139), "10");
        this.assertFunction("REGEXP_REPLACE('1234567890', '(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)', '$10')", (Type)VarcharType.createVarcharType((int)175), "0");
        this.assertFunction("REGEXP_REPLACE('1234567890', '(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)', '$11')", (Type)VarcharType.createVarcharType((int)175), "11");
        this.assertFunction("REGEXP_REPLACE('1234567890', '(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)', '$1a')", (Type)VarcharType.createVarcharType((int)175), "1a");
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '$1')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '$a')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '$')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("REGEXP_REPLACE('wxyz', '(?<xyz>[xyz])', '${xyz}${xyz}')", (Type)VarcharType.createVarcharType((int)124), "wxxyyzz");
        this.assertFunction("REGEXP_REPLACE('wxyz', '(?<w>w)|(?<xyz>[xyz])', '[${w}](${xyz})')", (Type)VarcharType.createVarcharType((int)144), "[w]()[](x)[](y)[](z)");
        this.assertFunction("REGEXP_REPLACE('xyz', '(?<xyz>[xyz])+', '${xyz}')", (Type)VarcharType.createVarcharType((int)39), "z");
        this.assertFunction("REGEXP_REPLACE('xyz', '(?<xyz>[xyz]+)', '${xyz}')", (Type)VarcharType.createVarcharType((int)39), "xyz");
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', '(?<name>x)', '${}')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', '(?<name>x)', '${0}')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', '(?<name>x)', '${nam}')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("REGEXP_REPLACE(VARCHAR 'x', '.*', 'xxxxx')", (Type)VarcharType.createUnboundedVarcharType(), "xxxxxxxxxx");
    }

    @Test
    public void testRegexpReplaceLambda() {
        this.assertFunction("REGEXP_REPLACE('x', '(x)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "X");
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', '(x)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "XXX XXX XXX");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w)', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "new");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w)', x -> x[1] || upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "nNeEwW");
        this.assertFunction("REGEXP_REPLACE('new york', '(\\w)(\\w*)', x -> upper(x[1]) || lower(x[2]))", (Type)VarcharType.createUnboundedVarcharType(), "New York");
        this.assertFunction("REGEXP_REPLACE('new york', '((\\w)(\\w*))', x -> upper(x[2]) || lower(x[3]))", (Type)VarcharType.createUnboundedVarcharType(), "New York");
        this.assertFunction("REGEXP_REPLACE('new york', '(n\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "NEW york");
        this.assertFunction("REGEXP_REPLACE('new york', '(y\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "new YORK");
        this.assertFunction("REGEXP_REPLACE('new york city', '(yo\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "new YORK city");
        this.assertFunction("REGEXP_REPLACE('abc abc', '(abc)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "m m");
        this.assertFunction("REGEXP_REPLACE('123 456', '([0-9]*)', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "123 456");
        this.assertFunction("REGEXP_REPLACE('123 456', '(([0-9]*) ([0-9]*))', x -> x[2] || x[3])", (Type)VarcharType.createUnboundedVarcharType(), "123456");
        this.assertFunction("REGEXP_REPLACE('abbabba', '(abba)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mbba");
        this.assertFunction("REGEXP_REPLACE('abbabba', '(abba)', x -> 'm' || x[1])", (Type)VarcharType.createUnboundedVarcharType(), "mabbabba");
        this.assertFunction("REGEXP_REPLACE('abcde', 'ab(c)?de', x -> CASE WHEN x[1] IS NULL THEN 'foo' ELSE 'bar' END)", (Type)VarcharType.createUnboundedVarcharType(), "bar");
        this.assertFunction("REGEXP_REPLACE('abc', '(.)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mmm");
        this.assertFunction("REGEXP_REPLACE('abc', '.', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mmm");
        this.assertFunction("REGEXP_REPLACE('abbabba', 'abba', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mbba");
        this.assertFunction("REGEXP_REPLACE('abc abc', 'abc', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "m m");
        this.assertFunction("REGEXP_REPLACE('abc', '', x -> 'OK')", (Type)VarcharType.createUnboundedVarcharType(), "OKaOKbOKcOK");
        this.assertFunction("REGEXP_REPLACE('abc', '()', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "abc");
        this.assertFunction("REGEXP_REPLACE('abc', '()', x -> 'OK')", (Type)VarcharType.createUnboundedVarcharType(), "OKaOKbOKcOK");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "NEW");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w*)', x -> x[1] || upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "newNEW");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w*)', x -> CAST(length(x[1]) AS VARCHAR))", (Type)VarcharType.createUnboundedVarcharType(), "30");
        this.assertFunction("REGEXP_REPLACE('new york', '(\\w*)', x -> '<' || x[1] || '>')", (Type)VarcharType.createUnboundedVarcharType(), "<new><> <york><>");
        this.assertFunction("REGEXP_REPLACE('aaa', '(b)?', x -> x[1] )", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> 'OK')", (Type)VarcharType.createUnboundedVarcharType(), "OK");
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> x[1] || 'OK')", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> 'OK' || x[1])", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> CASE WHEN x[1] IS NULL THEN 'foo' ELSE 'bar' END)", (Type)VarcharType.createUnboundedVarcharType(), "foo");
        this.assertFunction("REGEXP_REPLACE('ab', '(a)?(b)?', x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('aaa', '(a)', x -> CAST(NULL AS VARCHAR))", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('ab', '(a)?(b)?', x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NULL) OR (x[1] IS NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abacdb', '(a)?(b)?', x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NULL) OR (x[1] IS NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('new york', '(a)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "new york");
        this.assertFunction("REGEXP_REPLACE('', '(a)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "");
        this.assertFunction("REGEXP_REPLACE(null, '(a)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('new', null, x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', '(c)', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "abde");
        this.assertFunction("REGEXP_REPLACE('abde', '(c)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "abde");
        this.assertInvalidFunction("REGEXP_REPLACE('new', '(\\w)', x -> upper(x[2]))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('new', '(\\w)', x -> upper(x[0]))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('abc', '', x -> x[1])", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('x', 'x', x -> upper(x[1]))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('abbabba', 'abba', x -> 'm' || x[1])", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testRegexpExtract() {
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)')", (Type)VarcharType.createVarcharType((int)15), "world");
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', 1)", (Type)VarcharType.createVarcharType((int)15), "orld");
        this.assertFunction("REGEXP_EXTRACT('rat cat\nbat dog', 'ra(.)|blah(.)(.)', 2)", (Type)VarcharType.createVarcharType((int)15), null);
        this.assertFunction("REGEXP_EXTRACT('12345', 'x')", (Type)VarcharType.createVarcharType((int)5), null);
        this.assertFunction("REGEXP_EXTRACT('Baby X', 'by ([A-Z].*)\\b[a-z]')", (Type)VarcharType.createVarcharType((int)6), null);
        this.assertInvalidFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', -1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', 2)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testRegexpExtractAll() {
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', '.at')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)15)), ImmutableList.of((Object)"rat", (Object)"cat", (Object)"bat"));
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', '(.)at', 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)15)), ImmutableList.of((Object)"r", (Object)"c", (Object)"b"));
        ArrayList<Object> nullList = new ArrayList<Object>();
        nullList.add(null);
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', 'ra(.)|blah(.)(.)', 2)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)15)), nullList);
        this.assertInvalidFunction("REGEXP_EXTRACT_ALL('hello', '(.)', 2)", "Pattern has 1 groups. Cannot access group 2");
        this.assertFunction("REGEXP_EXTRACT_ALL('12345', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)""));
        this.assertInvalidFunction("REGEXP_EXTRACT_ALL('12345', '(')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testRegexpSplit() {
        this.assertFunction("REGEXP_SPLIT('a.b:c;d', '[\\.:;]')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT('a.b:c;d', '\\.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b:c;d"));
        this.assertFunction("REGEXP_SPLIT('a.b:c;d', ':')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a.b", (Object)"c;d"));
        this.assertFunction("REGEXP_SPLIT('a,b,c', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("REGEXP_SPLIT('a1b2c3d', '\\d')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT('a1b2346c3d', '\\d+')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)10)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT('abcd', 'x')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"abcd"));
        this.assertFunction("REGEXP_SPLIT('abcd', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)""));
        this.assertFunction("REGEXP_SPLIT('', 'x')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), ImmutableList.of((Object)""));
        this.assertFunction("REGEXP_SPLIT('a,b,c,d', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT(',,a,,,b,c,d,,', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)13)), ImmutableList.of((Object)"", (Object)"", (Object)"a", (Object)"", (Object)"", (Object)"b", (Object)"c", (Object)"d", (Object)"", (Object)""));
        this.assertFunction("REGEXP_SPLIT(',,,', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)""));
    }
}

