/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.Utils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProjectionWithOutputs;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;

public final class FunctionAssertions
implements Closeable {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final int TEST_ROW_NUMBER_OF_FIELDS = 2500;
    private static final RowType TEST_ROW_TYPE = FunctionAssertions.createTestRowType(2500);
    private static final Block TEST_ROW_DATA = FunctionAssertions.createTestRowData(TEST_ROW_TYPE);
    private static final Page SOURCE_PAGE = new Page(new Block[]{BlockAssertions.createLongsBlock(1234L), BlockAssertions.createStringsBlock("hello"), BlockAssertions.createDoublesBlock(12.34), BlockAssertions.createBooleansBlock(true), BlockAssertions.createLongsBlock(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis()), BlockAssertions.createStringsBlock("%el%"), BlockAssertions.createStringsBlock(new String[]{null}), BlockAssertions.createTimestampsWithTimezoneBlock(DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Z"))), BlockAssertions.createSlicesBlock(Slices.wrappedBuffer((byte[])new byte[]{-85})), BlockAssertions.createIntsBlock(1234), TEST_ROW_DATA});
    private static final Page ZERO_CHANNEL_PAGE = new Page(1);
    private static final Map<VariableReferenceExpression, Integer> INPUT_MAPPING = ImmutableMap.builder().put((Object)new VariableReferenceExpression("bound_long", (Type)BigintType.BIGINT), (Object)0).put((Object)new VariableReferenceExpression("bound_string", (Type)VarcharType.VARCHAR), (Object)1).put((Object)new VariableReferenceExpression("bound_double", (Type)DoubleType.DOUBLE), (Object)2).put((Object)new VariableReferenceExpression("bound_boolean", (Type)BooleanType.BOOLEAN), (Object)3).put((Object)new VariableReferenceExpression("bound_timestamp", (Type)BigintType.BIGINT), (Object)4).put((Object)new VariableReferenceExpression("bound_pattern", (Type)VarcharType.VARCHAR), (Object)5).put((Object)new VariableReferenceExpression("bound_null_string", (Type)VarcharType.VARCHAR), (Object)6).put((Object)new VariableReferenceExpression("bound_timestamp_with_timezone", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE), (Object)7).put((Object)new VariableReferenceExpression("bound_binary_literal", (Type)VarbinaryType.VARBINARY), (Object)8).put((Object)new VariableReferenceExpression("bound_integer", (Type)IntegerType.INTEGER), (Object)9).put((Object)new VariableReferenceExpression("bound_row", (Type)TEST_ROW_TYPE), (Object)10).build();
    private static final TypeProvider SYMBOL_TYPES = TypeProvider.fromVariables(INPUT_MAPPING.keySet());
    private static final PageSourceProvider PAGE_SOURCE_PROVIDER = new TestPageSourceProvider();
    private static final PlanNodeId SOURCE_ID = new PlanNodeId("scan");
    private final Session session;
    private final LocalQueryRunner runner;
    private final Metadata metadata;
    private final ExpressionCompiler compiler;

    public FunctionAssertions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    public FunctionAssertions(Session session) {
        this(session, new FeaturesConfig());
    }

    public FunctionAssertions(Session session, FeaturesConfig featuresConfig) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.runner = new LocalQueryRunner(session, featuresConfig);
        this.metadata = this.runner.getMetadata();
        this.compiler = this.runner.getExpressionCompiler();
    }

    public FunctionAndTypeManager getFunctionAndTypeManager() {
        return this.runner.getFunctionAndTypeManager();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public FunctionAssertions addFunctions(List<? extends SqlFunction> functionInfos) {
        this.metadata.registerBuiltInFunctions(functionInfos);
        return this;
    }

    public FunctionAssertions addScalarFunctions(Class<?> clazz) {
        this.metadata.registerBuiltInFunctions(new FunctionListBuilder().scalars(clazz).getFunctions());
        return this;
    }

    public void assertFunction(String projection, Type expectedType, Object expected) {
        if (expected instanceof Slice) {
            expected = ((Slice)expected).toStringUtf8();
        }
        Object actual = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void assertFunctionWithError(String projection, Type expectedType, double expected, double delta) {
        Number actual = (Number)this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((double)actual.doubleValue(), (double)expected, (double)delta);
    }

    public void assertFunctionString(String projection, Type expectedType, String expected) {
        Object actual = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((String)actual.toString(), (String)expected);
    }

    public void tryEvaluate(String expression, Type expectedType) {
        this.tryEvaluate(expression, expectedType, this.session);
    }

    private void tryEvaluate(String expression, Type expectedType, Session session) {
        this.selectUniqueValue(expression, expectedType, session, this.compiler);
    }

    public void tryEvaluateWithAll(String expression, Type expectedType) {
        this.tryEvaluateWithAll(expression, expectedType, this.session);
    }

    public void tryEvaluateWithAll(String expression, Type expectedType, Session session) {
        this.executeProjectionWithAll(expression, expectedType, session, this.compiler);
    }

    public void executeProjectionWithFullEngine(String projection) {
        MaterializedResult result = this.runner.execute("SELECT " + projection);
    }

    protected <T> T selectSingleValue(String projection, Type expectedType, Class<T> clazz) {
        Object object = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals(object.getClass(), clazz);
        return (T)object;
    }

    private Object selectSingleValue(String projection, Type expectedType, ExpressionCompiler compiler) {
        return this.selectUniqueValue(projection, expectedType, this.session, compiler);
    }

    private Object selectUniqueValue(String projection, Type expectedType, Session session, ExpressionCompiler compiler) {
        List<Object> results = this.executeProjectionWithAll(projection, expectedType, session, compiler);
        HashSet<Object> resultSet = new HashSet<Object>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only one result unique result, but got " + resultSet));
        return Iterables.getOnlyElement(resultSet);
    }

    @Deprecated
    public void assertInvalidFunction(String projection) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)"Expected to fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void assertInvalidFunction(String projection, StandardErrorCode errorCode, String messagePattern) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)("Expected to throw a PrestoException with message matching " + messagePattern));
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)errorCode.toErrorCode());
                Assert.assertTrue((e.getMessage().equals(messagePattern) || e.getMessage().matches(messagePattern) ? 1 : 0) != 0, (String)String.format("Error message [%s] doesn't match [%s]", e.getMessage(), messagePattern));
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidFunction(String projection, String messagePattern) {
        this.assertInvalidFunction(projection, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, messagePattern);
    }

    public void assertInvalidFunction(String projection, SemanticErrorCode expectedErrorCode) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)String.format("Expected to throw %s exception", expectedErrorCode));
        }
        catch (SemanticException e) {
            try {
                Assert.assertEquals((Object)e.getCode(), (Object)expectedErrorCode);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidFunction(String projection, SemanticErrorCode expectedErrorCode, String message) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)String.format("Expected to throw %s exception", expectedErrorCode));
        }
        catch (SemanticException e) {
            try {
                Assert.assertEquals((Object)e.getCode(), (Object)expectedErrorCode);
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidFunction(String projection, ErrorCodeSupplier expectedErrorCode) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)String.format("Expected to throw %s exception", expectedErrorCode.toErrorCode()));
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)expectedErrorCode.toErrorCode());
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertNumericOverflow(String projection, String message) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)("Expected to throw an NUMERIC_VALUE_OUT_OF_RANGE exception with message " + message));
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidCast(String projection) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)"Expected to throw an INVALID_CAST_ARGUMENT exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidCast(String projection, String message) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)"Expected to throw an INVALID_CAST_ARGUMENT exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    private void evaluateInvalid(String projection) {
        this.selectSingleValue(projection, (Type)UnknownType.UNKNOWN, this.compiler);
    }

    public void assertCachedInstanceHasBoundedRetainedSize(String projection) {
        Objects.requireNonNull(projection, "projection is null");
        Expression projectionExpression = FunctionAssertions.createExpression(this.session, projection, this.metadata, SYMBOL_TYPES);
        RowExpression projectionRowExpression = this.toRowExpression(this.session, projectionExpression);
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(this.session.getSqlFunctionProperties(), Optional.empty(), (List)ImmutableList.of((Object)projectionRowExpression)).get();
        long maxRetainedSize = 0L;
        int maxIterationCount = 0;
        for (int iterationCount = 0; iterationCount < Math.max(1000, maxIterationCount * 4); ++iterationCount) {
            Iterator output = processor.process(this.session.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), SOURCE_PAGE);
            Iterators.getOnlyElement((Iterator)output);
            long retainedSize = processor.getProjections().stream().mapToLong(this::getRetainedSizeOfCachedInstance).sum();
            if (retainedSize > maxRetainedSize) {
                maxRetainedSize = retainedSize;
                maxIterationCount = iterationCount;
            }
            if (maxRetainedSize < 0x100000L) continue;
            Assert.fail((String)String.format("The retained size of cached instance of function invocation is likely unbounded: %s", projection));
        }
    }

    private long getRetainedSizeOfCachedInstance(PageProjectionWithOutputs projection) {
        Field[] fields = projection.getPageProjection().getClass().getDeclaredFields();
        long retainedSize = 0L;
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (!fieldName.startsWith("__cachedInstance")) continue;
            try {
                retainedSize += this.getRetainedSizeOf(field.get(projection));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return retainedSize;
    }

    private long getRetainedSizeOf(Object object) {
        Field[] fields;
        if (object instanceof PageBuilder) {
            return ((PageBuilder)object).getRetainedSizeInBytes();
        }
        if (object instanceof Block) {
            return ((Block)object).getRetainedSizeInBytes();
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            if (type == int[].class) {
                return SizeOf.sizeOf((int[])((int[])object));
            }
            if (type == boolean[].class) {
                return SizeOf.sizeOf((boolean[])((boolean[])object));
            }
            if (type == byte[].class) {
                return SizeOf.sizeOf((byte[])((byte[])object));
            }
            if (type == long[].class) {
                return SizeOf.sizeOf((long[])((long[])object));
            }
            if (type == short[].class) {
                return SizeOf.sizeOf((short[])((short[])object));
            }
            if (type == Block[].class) {
                Object[] objects = (Object[])object;
                return Arrays.stream(objects).mapToLong(this::getRetainedSizeOf).sum();
            }
            throw new IllegalArgumentException(String.format("Unknown type encountered: %s", type));
        }
        long retainedSize = ClassLayout.parseClass(type).instanceSize();
        for (Field field : fields = type.getDeclaredFields()) {
            try {
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                retainedSize += this.getRetainedSizeOf(field.get(object));
            }
            catch (IllegalAccessException t) {
                throw new RuntimeException(t);
            }
        }
        return retainedSize;
    }

    private List<Object> executeProjectionWithAll(String projection, Type expectedType, Session session, ExpressionCompiler compiler) {
        Objects.requireNonNull(projection, "projection is null");
        Expression projectionExpression = FunctionAssertions.createExpression(session, projection, this.metadata, SYMBOL_TYPES);
        RowExpression projectionRowExpression = this.toRowExpression(session, projectionExpression);
        ArrayList<Object> results = new ArrayList<Object>();
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            FunctionAssertions.assertType(result.getTypes(), expectedType);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        OperatorFactory operatorFactory = FunctionAssertions.compileFilterProject(session.getSqlFunctionProperties(), Optional.empty(), projectionRowExpression, compiler);
        Object directOperatorValue = this.selectSingleValue(operatorFactory, expectedType, session);
        results.add(directOperatorValue);
        Object interpretedValue = this.interpret(projectionExpression, expectedType, session);
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = FunctionAssertions.compileScanFilterProject(session.getSqlFunctionProperties(), Optional.empty(), projectionRowExpression, compiler);
        Object scanOperatorValue = this.selectSingleValue(scanProjectOperatorFactory, expectedType, FunctionAssertions.createNormalSplit(), session);
        results.add(scanOperatorValue);
        Object recordValue = this.selectSingleValue(scanProjectOperatorFactory, expectedType, FunctionAssertions.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            FunctionAssertions.assertType(result.getTypes(), expectedType);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        Assert.assertEquals((Object)projectionRowExpression.getType(), (Object)expectedType);
        return results;
    }

    private RowExpression toRowExpression(Session session, Expression projectionExpression) {
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)session, (Metadata)this.metadata, (SqlParser)SQL_PARSER, (TypeProvider)SYMBOL_TYPES, (Expression)projectionExpression, (List)ImmutableList.of(), (WarningCollector)WarningCollector.NOOP);
        return this.toRowExpression(projectionExpression, expressionTypes, INPUT_MAPPING);
    }

    private Object selectSingleValue(OperatorFactory operatorFactory, Type type, Session session) {
        Operator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        return this.selectSingleValue(operator, type);
    }

    private Object selectSingleValue(SourceOperatorFactory operatorFactory, Type type, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return this.selectSingleValue((Operator)operator, type);
    }

    private Object selectSingleValue(Operator operator, Type type) {
        Page output = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((int)output.getPositionCount(), (int)1);
        Assert.assertEquals((int)output.getChannelCount(), (int)1);
        Block block = output.getBlock(0);
        Assert.assertEquals((int)block.getPositionCount(), (int)1);
        return type.getObjectValue(this.session.getSqlFunctionProperties(), block, 0);
    }

    public void assertFilter(String filter, boolean expected, boolean withNoInputColumns) {
        this.assertFilter(filter, expected, withNoInputColumns, this.compiler);
    }

    private void assertFilter(String filter, boolean expected, boolean withNoInputColumns, ExpressionCompiler compiler) {
        List<Boolean> results = this.executeFilterWithAll(filter, SessionTestUtils.TEST_SESSION, withNoInputColumns, compiler);
        HashSet<Boolean> resultSet = new HashSet<Boolean>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only [" + expected + "] result unique result, but got " + resultSet));
        Assert.assertEquals((boolean)((Boolean)Iterables.getOnlyElement(resultSet)), (boolean)expected);
    }

    private List<Boolean> executeFilterWithAll(String filter, Session session, boolean executeWithNoInputColumns, ExpressionCompiler compiler) {
        Boolean interpretedValue;
        Objects.requireNonNull(filter, "filter is null");
        Expression filterExpression = FunctionAssertions.createExpression(session, filter, this.metadata, SYMBOL_TYPES);
        RowExpression filterRowExpression = this.toRowExpression(session, filterExpression);
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        OperatorFactory operatorFactory = FunctionAssertions.compileFilterProject(session.getSqlFunctionProperties(), Optional.of(filterRowExpression), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), compiler);
        results.add(FunctionAssertions.executeFilter(operatorFactory, session));
        if (executeWithNoInputColumns) {
            operatorFactory = FunctionAssertions.compileFilterWithNoInputColumns(session.getSqlFunctionProperties(), filterRowExpression, compiler);
            results.add(FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory, session));
        }
        if ((interpretedValue = (Boolean)this.interpret(filterExpression, (Type)BooleanType.BOOLEAN, session)) == null) {
            interpretedValue = false;
        }
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = FunctionAssertions.compileScanFilterProject(session.getSqlFunctionProperties(), Optional.of(filterRowExpression), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), compiler);
        boolean scanOperatorValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, FunctionAssertions.createNormalSplit(), session);
        results.add(scanOperatorValue);
        boolean recordValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, FunctionAssertions.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(filterExpression)) {
            Boolean queryResult;
            MaterializedResult result = this.runner.execute("SELECT TRUE WHERE " + filter);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            if (result.getMaterializedRows().isEmpty()) {
                queryResult = false;
            } else {
                Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
                queryResult = (Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            }
            results.add(queryResult);
        }
        return results;
    }

    public static Expression createExpression(String expression, Metadata metadata, TypeProvider symbolTypes) {
        return FunctionAssertions.createExpression(SessionTestUtils.TEST_SESSION, expression, metadata, symbolTypes);
    }

    public static Expression createExpression(Session session, String expression, Metadata metadata, TypeProvider symbolTypes) {
        Expression parsedExpression = SQL_PARSER.createExpression(expression, ParsingUtil.createParsingOptions((Session)session));
        parsedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)parsedExpression);
        final ExpressionAnalysis analysis = ExpressionAnalyzer.analyzeExpressions((Session)session, (Metadata)metadata, (SqlParser)SQL_PARSER, (TypeProvider)symbolTypes, (Iterable)ImmutableList.of((Object)parsedExpression), (List)ImmutableList.of(), (WarningCollector)WarningCollector.NOOP, (boolean)false);
        Expression rewrittenExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                Type coercion = analysis.getCoercion(node);
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coercion.getTypeSignature().toString(), false, analysis.isTypeOnlyCoercion(node));
                }
                return rewrittenExpression;
            }

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (analysis.isColumnReference((Expression)node)) {
                    return this.rewriteExpression((Expression)node, context, treeRewriter);
                }
                Expression rewrittenExpression = treeRewriter.defaultRewrite((Expression)node, (Object)context);
                Type coercion = analysis.getCoercion((Expression)node);
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coercion.getTypeSignature().toString());
                }
                return rewrittenExpression;
            }
        }, (Expression)parsedExpression);
        return CanonicalizeExpressionRewriter.canonicalizeExpression((Expression)rewrittenExpression);
    }

    private static boolean executeFilterWithNoInputColumns(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilter(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(SourceOperatorFactory operatorFactory, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return FunctionAssertions.executeFilter((Operator)operator);
    }

    private static boolean executeFilter(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)1);
            Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(page.getBlock(0), 0));
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean executeFilterWithNoInputColumns(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, ZERO_CHANNEL_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)0);
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean needsBoundValue(Expression projectionExpression) {
        final AtomicBoolean hasSymbolReferences = new AtomicBoolean();
        new DefaultTraversalVisitor<Void, Void>(){

            protected Void visitSymbolReference(SymbolReference node, Void context) {
                hasSymbolReferences.set(true);
                return null;
            }
        }.process((Node)projectionExpression, null);
        return hasSymbolReferences.get();
    }

    private Object interpret(Expression expression, Type expectedType, Session session) {
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)session, (Metadata)this.metadata, (SqlParser)SQL_PARSER, (TypeProvider)SYMBOL_TYPES, (Expression)expression, Collections.emptyList(), (WarningCollector)WarningCollector.NOOP);
        ExpressionInterpreter evaluator = ExpressionInterpreter.expressionInterpreter((Expression)expression, (Metadata)this.metadata, (Session)session, (Map)expressionTypes);
        Object result = evaluator.evaluate(variable -> {
            Symbol symbol = new Symbol(variable.getName());
            int position = 0;
            int channel = INPUT_MAPPING.get(new VariableReferenceExpression(symbol.getName(), SYMBOL_TYPES.get((Expression)symbol.toSymbolReference())));
            Type type = SYMBOL_TYPES.get((Expression)symbol.toSymbolReference());
            Block block = SOURCE_PAGE.getBlock(channel);
            if (block.isNull(position)) {
                return null;
            }
            Class javaType = type.getJavaType();
            if (javaType == Boolean.TYPE) {
                return type.getBoolean(block, position);
            }
            if (javaType == Long.TYPE) {
                return type.getLong(block, position);
            }
            if (javaType == Double.TYPE) {
                return type.getDouble(block, position);
            }
            if (javaType == Slice.class) {
                return type.getSlice(block, position);
            }
            if (javaType == Block.class) {
                return type.getObject(block, position);
            }
            throw new UnsupportedOperationException("not yet implemented");
        });
        Block block = Utils.nativeValueToBlock((Type)expectedType, (Object)result);
        return expectedType.getObjectValue(session.getSqlFunctionProperties(), block, 0);
    }

    private static OperatorFactory compileFilterWithNoInputColumns(SqlFunctionProperties sqlFunctionProperties, RowExpression filter, ExpressionCompiler compiler) {
        try {
            Supplier processor = compiler.compilePageProcessor(sqlFunctionProperties, Optional.of(filter), (List)ImmutableList.of());
            return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), processor, (List)ImmutableList.of(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + filter + ": " + e.getMessage(), e);
        }
    }

    private static OperatorFactory compileFilterProject(SqlFunctionProperties sqlFunctionProperties, Optional<RowExpression> filter, RowExpression projection, ExpressionCompiler compiler) {
        try {
            Supplier processor = compiler.compilePageProcessor(sqlFunctionProperties, filter, (List)ImmutableList.of((Object)projection));
            return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), processor, (List)ImmutableList.of((Object)projection.getType()), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + projection + ": " + e.getMessage(), e);
        }
    }

    private static SourceOperatorFactory compileScanFilterProject(SqlFunctionProperties sqlFunctionProperties, Optional<RowExpression> filter, RowExpression projection, ExpressionCompiler compiler) {
        try {
            Supplier cursorProcessor = compiler.compileCursorProcessor(sqlFunctionProperties, filter, (List)ImmutableList.of((Object)projection), (Object)SOURCE_ID);
            Supplier pageProcessor = compiler.compilePageProcessor(sqlFunctionProperties, filter, (List)ImmutableList.of((Object)projection));
            return new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), SOURCE_ID, PAGE_SOURCE_PROVIDER, cursorProcessor, pageProcessor, new TableHandle(new ConnectorId("test"), new ConnectorTableHandle(){}, new ConnectorTransactionHandle(){}, Optional.empty()), (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)projection.getType()), Optional.empty(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling filter " + filter + ": " + e.getMessage(), e);
        }
    }

    private RowExpression toRowExpression(Expression projection, Map<NodeRef<Expression>, Type> expressionTypes, Map<VariableReferenceExpression, Integer> layout) {
        return SqlToRowExpressionTranslator.translate((Expression)projection, expressionTypes, layout, (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)this.session);
    }

    private static Page getAtMostOnePage(Operator operator, Page sourcePage) {
        if (operator.needsInput()) {
            operator.addInput(sourcePage);
        }
        Page result = operator.getOutput();
        operator.finish();
        while (!operator.isFinished()) {
            Assert.assertTrue((boolean)operator.isBlocked().isDone());
            Page output = operator.getOutput();
            if (output == null) continue;
            Assert.assertNull((Object)result);
            result = output;
        }
        return result;
    }

    private static DriverContext createDriverContext(Session session) {
        return TestingTaskContext.createTaskContext((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULED_EXECUTOR, (Session)session).addPipelineContext(0, true, true, false).addDriverContext();
    }

    private static void assertType(List<Type> types, Type expectedType) {
        Assert.assertTrue((types.size() == 1 ? 1 : 0) != 0, (String)("Expected one type, but got " + types));
        Type actualType = types.get(0);
        Assert.assertEquals((Object)actualType, (Object)expectedType);
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    private static Split createRecordSetSplit() {
        return new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplit(true));
    }

    private static Split createNormalSplit() {
        return new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplit(false));
    }

    private static RowType createTestRowType(int numberOfFields) {
        Iterator types = Iterables.cycle((Object[])new Type[]{BigintType.BIGINT, IntegerType.INTEGER, VarcharType.VARCHAR, DoubleType.DOUBLE, BooleanType.BOOLEAN, VarbinaryType.VARBINARY, RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nested_nested_column", (Type)VarcharType.VARCHAR)))}).iterator();
        ArrayList<RowType.Field> fields = new ArrayList<RowType.Field>();
        for (int fieldIdx = 0; fieldIdx < numberOfFields; ++fieldIdx) {
            fields.add(new RowType.Field(Optional.of("nested_column_" + fieldIdx), (Type)types.next()));
        }
        return RowType.from(fields);
    }

    private static Block createTestRowData(RowType rowType) {
        Iterator values = Iterables.cycle((Object[])new Object[]{1234L, 34, "hello", 12.34, true, Slices.wrappedBuffer((byte[])new byte[]{-85}), BlockAssertions.createRowBlock((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), new Object[][]{Collections.singleton("innerFieldValue").toArray()}).getBlock(0)}).iterator();
        int numFields = rowType.getFields().size();
        Object[] rowValues = new Object[numFields];
        for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            rowValues[fieldIdx] = values.next();
        }
        return BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{rowValues});
    }

    private static class TestSplit
    implements ConnectorSplit {
        private final boolean recordSet;

        private TestSplit(boolean recordSet) {
            this.recordSet = recordSet;
        }

        private boolean isRecordSet() {
            return this.recordSet;
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class TestPageSourceProvider
    implements PageSourceProvider {
        private TestPageSourceProvider() {
        }

        public ConnectorPageSource createPageSource(Session session, Split split, TableHandle table, List<ColumnHandle> columns) {
            Assertions.assertInstanceOf((Object)split.getConnectorSplit(), TestSplit.class);
            TestSplit testSplit = (TestSplit)split.getConnectorSplit();
            if (testSplit.isRecordSet()) {
                InMemoryRecordSet records = InMemoryRecordSet.builder((Collection)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)VarbinaryType.VARBINARY, (Object)IntegerType.INTEGER, (Object)TEST_ROW_TYPE)).addRow(new Object[]{1234L, "hello", 12.34, true, new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis(), "%el%", null, DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Z")), Slices.wrappedBuffer((byte[])new byte[]{-85}), 1234, TEST_ROW_DATA.getBlock(0)}).build();
                return new RecordPageSource((RecordSet)records);
            }
            return new FixedPageSource((Iterable)ImmutableList.of((Object)SOURCE_PAGE));
        }
    }
}

