/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.ArrayCombinationsFunction;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayCombinationsFunction
extends AbstractTestFunctions {
    @Test
    public void testCombinationCount() {
        for (int n = 0; n < 5; ++n) {
            for (int k = 0; k <= n; ++k) {
                Assert.assertEquals((long)ArrayCombinationsFunction.combinationCount((int)n, (int)k), (long)(LongMath.factorial((int)n) / LongMath.factorial((int)(n - k)) / LongMath.factorial((int)k)));
            }
        }
        Assert.assertEquals((int)ArrayCombinationsFunction.combinationCount((int)42, (int)7), (int)26978328);
        Assert.assertEquals((int)ArrayCombinationsFunction.combinationCount((int)100, (int)4), (int)3921225);
    }

    @Test
    public void testBasic() {
        this.assertFunction("combinations(ARRAY['bar', 'foo', 'baz', 'foo'], 0)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of()));
        this.assertFunction("combinations(ARRAY['bar', 'foo', 'baz', 'foo'], 1)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar"), (Object)ImmutableList.of((Object)"foo"), (Object)ImmutableList.of((Object)"baz"), (Object)ImmutableList.of((Object)"foo")));
        this.assertFunction("combinations(ARRAY['bar', 'foo', 'baz', 'foo'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo"), (Object)ImmutableList.of((Object)"bar", (Object)"baz"), (Object)ImmutableList.of((Object)"foo", (Object)"baz"), (Object)ImmutableList.of((Object)"bar", (Object)"foo"), (Object)ImmutableList.of((Object)"foo", (Object)"foo"), (Object)ImmutableList.of((Object)"baz", (Object)"foo")));
        this.assertFunction("combinations(ARRAY['bar', 'foo', 'baz', 'foo'], 3)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz"), (Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"foo"), (Object)ImmutableList.of((Object)"bar", (Object)"baz", (Object)"foo"), (Object)ImmutableList.of((Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("combinations(ARRAY['bar', 'foo', 'baz', 'foo'], 4)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("combinations(ARRAY['bar', 'foo', 'baz', 'foo'], 5)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of());
        this.assertFunction("combinations(ARRAY['a', 'bb', 'ccc', 'dddd'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))), ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"bb"), (Object)ImmutableList.of((Object)"a", (Object)"ccc"), (Object)ImmutableList.of((Object)"bb", (Object)"ccc"), (Object)ImmutableList.of((Object)"a", (Object)"dddd"), (Object)ImmutableList.of((Object)"bb", (Object)"dddd"), (Object)ImmutableList.of((Object)"ccc", (Object)"dddd")));
    }

    @Test
    public void testLimits() {
        this.assertInvalidFunction("combinations(sequence(1, 40), -1)", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "combination size must not be negative: -1");
        this.assertInvalidFunction("combinations(sequence(1, 40), 10)", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "combination size must not exceed 5: 10");
        this.assertInvalidFunction("combinations(sequence(1, 100), 5)", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "combinations exceed max size");
    }

    @Test
    public void testCardinality() {
        for (int n = 0; n < 5; ++n) {
            for (int k = 0; k <= n; ++k) {
                String array = "ARRAY" + ContiguousSet.closedOpen((int)0, (int)n).asList();
                this.assertFunction(String.format("cardinality(combinations(%s, %s))", array, k), (Type)BigintType.BIGINT, LongMath.factorial((int)n) / LongMath.factorial((int)(n - k)) / LongMath.factorial((int)k));
            }
        }
    }

    @Test
    public void testNull() {
        this.assertFunction("combinations(CAST(NULL AS array(bigint)), 2)", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)), null);
        this.assertFunction("combinations(ARRAY['foo', NULL, 'bar'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of(Arrays.asList("foo", null), Arrays.asList("foo", "bar"), Arrays.asList(null, "bar")));
        this.assertFunction("combinations(ARRAY [NULL, NULL, NULL], 2)", (Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN)), ImmutableList.of(Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null)));
        this.assertFunction("combinations(ARRAY [NULL, 3, NULL], 2)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(null, 3), Arrays.asList(null, null), Arrays.asList(3, null)));
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("combinations(ARRAY[1, 2, 3], 2)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)3), (Object)ImmutableList.of((Object)2, (Object)3)));
        this.assertFunction("combinations(ARRAY[1.1E0, 2.1E0, 3.1E0], 2)", (Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableList.of((Object)ImmutableList.of((Object)1.1, (Object)2.1), (Object)ImmutableList.of((Object)1.1, (Object)3.1), (Object)ImmutableList.of((Object)2.1, (Object)3.1)));
        this.assertFunction("combinations(ARRAY[true, false, true], 2)", (Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)), ImmutableList.of((Object)ImmutableList.of((Object)true, (Object)false), (Object)ImmutableList.of((Object)true, (Object)true), (Object)ImmutableList.of((Object)false, (Object)true)));
        this.assertFunction("combinations(ARRAY[ARRAY['A1', 'A2'], ARRAY['B1'], ARRAY['C1', 'C2']], 2)", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)))), ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)"A1", (Object)"A2"), (Object)ImmutableList.of((Object)"B1")), (Object)ImmutableList.of((Object)ImmutableList.of((Object)"A1", (Object)"A2"), (Object)ImmutableList.of((Object)"C1", (Object)"C2")), (Object)ImmutableList.of((Object)ImmutableList.of((Object)"B1"), (Object)ImmutableList.of((Object)"C1", (Object)"C2"))));
        this.assertFunction("combinations(ARRAY['\u4fe1\u5ff5\u7231', '\u5e0c\u671b', '\u671b'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"\u4fe1\u5ff5\u7231", (Object)"\u5e0c\u671b"), (Object)ImmutableList.of((Object)"\u4fe1\u5ff5\u7231", (Object)"\u671b"), (Object)ImmutableList.of((Object)"\u5e0c\u671b", (Object)"\u671b")));
        this.assertFunction("combinations(ARRAY[], 2)", (Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN)), ImmutableList.of());
        this.assertFunction("combinations(ARRAY[''], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))), ImmutableList.of());
        this.assertFunction("combinations(ARRAY['', ''], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))), ImmutableList.of((Object)ImmutableList.of((Object)"", (Object)"")));
    }
}

