/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBlockAndPositionNullConvention
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerParametricScalar(FunctionWithBlockAndPositionConvention.class);
    }

    @Test
    public void testBlockPosition() {
        this.assertFunction("test_block_position(9876543210)", (Type)BigintType.BIGINT, 9876543210L);
        Assert.assertFalse((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionBigint.get());
        this.assertFunction("test_block_position(bound_long)", (Type)BigintType.BIGINT, 1234L);
        Assert.assertTrue((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionBigint.get());
        this.assertFunction("test_block_position(3.0E0)", (Type)DoubleType.DOUBLE, 3.0);
        Assert.assertFalse((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionDouble.get());
        this.assertFunction("test_block_position(bound_double)", (Type)DoubleType.DOUBLE, 12.34);
        Assert.assertTrue((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionDouble.get());
        this.assertFunction("test_block_position(bound_string)", (Type)VarcharType.VARCHAR, "hello");
        Assert.assertTrue((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionSlice.get());
        this.assertFunction("test_block_position(false)", (Type)BooleanType.BOOLEAN, false);
        Assert.assertFalse((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionBoolean.get());
        this.assertFunction("test_block_position(bound_boolean)", (Type)BooleanType.BOOLEAN, true);
        Assert.assertTrue((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionBoolean.get());
    }

    @ScalarFunction(value="test_block_position", calledOnNullInput=true)
    public static class FunctionWithBlockAndPositionConvention {
        private static final AtomicBoolean hitBlockPositionBigint = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionDouble = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionSlice = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionBoolean = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionObject = new AtomicBoolean();

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Object object) {
            return object;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @BlockPosition @SqlType(value="E") Block block, @BlockIndex int position) {
            hitBlockPositionObject.set(true);
            return TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Slice specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Slice slice) {
            return slice;
        }

        @TypeParameter(value="E")
        @SqlType(value="E")
        public static Slice specializedSlice(@TypeParameter(value="E") Type type, @BlockPosition @SqlType(value="E", nativeContainerType=Slice.class) Block block, @BlockIndex int position) {
            hitBlockPositionSlice.set(true);
            return type.getSlice(block, position);
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Boolean speciailizedBoolean(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Boolean bool) {
            return bool;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Boolean speciailizedBoolean(@TypeParameter(value="E") Type type, @BlockPosition @SqlType(value="E", nativeContainerType=boolean.class) Block block, @BlockIndex int position) {
            hitBlockPositionBoolean.set(true);
            return type.getBoolean(block, position);
        }

        @SqlType(value="bigint")
        public static long getLong(@SqlNullable @SqlType(value="bigint") Long number) {
            return number;
        }

        @SqlType(value="bigint")
        public static long getBlockPosition(@BlockPosition @SqlType(value="bigint", nativeContainerType=long.class) Block block, @BlockIndex int position) {
            hitBlockPositionBigint.set(true);
            return BigintType.BIGINT.getLong(block, position);
        }

        @SqlType(value="double")
        @SqlNullable
        public static Double getDouble(@SqlNullable @SqlType(value="double") Double number) {
            return number;
        }

        @SqlType(value="double")
        @SqlNullable
        public static Double getDouble(@BlockPosition @SqlType(value="double", nativeContainerType=double.class) Block block, @BlockIndex int position) {
            hitBlockPositionDouble.set(true);
            return DoubleType.DOUBLE.getDouble(block, position);
        }
    }
}

